/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1.stub;

import com.google.ads.admanager.v1.GetUserRequest;
import com.google.ads.admanager.v1.ListUsersRequest;
import com.google.ads.admanager.v1.ListUsersResponse;
import com.google.ads.admanager.v1.User;
import com.google.ads.admanager.v1.UserServiceClient;
import com.google.ads.admanager.v1.stub.HttpJsonUserServiceCallableFactory;
import com.google.ads.admanager.v1.stub.UserServiceStub;
import com.google.ads.admanager.v1.stub.UserServiceStubSettings;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class HttpJsonUserServiceStub
extends UserServiceStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().build();
    private static final ApiMethodDescriptor<GetUserRequest, User> getUserMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.ads.admanager.v1.UserService/GetUser").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=networks/*/users/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)User.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListUsersRequest, ListUsersResponse> listUsersMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.ads.admanager.v1.UserService/ListUsers").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=networks/*}/users", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        serializer.putQueryParam(fields, "orderBy", (Object)request.getOrderBy());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "skip", (Object)request.getSkip());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListUsersResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<GetUserRequest, User> getUserCallable;
    private final UnaryCallable<ListUsersRequest, ListUsersResponse> listUsersCallable;
    private final UnaryCallable<ListUsersRequest, UserServiceClient.ListUsersPagedResponse> listUsersPagedCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonUserServiceStub create(UserServiceStubSettings settings) throws IOException {
        return new HttpJsonUserServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonUserServiceStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonUserServiceStub(UserServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final HttpJsonUserServiceStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonUserServiceStub(UserServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonUserServiceStub(UserServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonUserServiceCallableFactory());
    }

    protected HttpJsonUserServiceStub(UserServiceStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        HttpJsonCallSettings getUserTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getUserMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings listUsersTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listUsersMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        this.getUserCallable = callableFactory.createUnaryCallable(getUserTransportSettings, settings.getUserSettings(), clientContext);
        this.listUsersCallable = callableFactory.createUnaryCallable(listUsersTransportSettings, settings.listUsersSettings(), clientContext);
        this.listUsersPagedCallable = callableFactory.createPagedCallable(listUsersTransportSettings, settings.listUsersSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(getUserMethodDescriptor);
        methodDescriptors.add(listUsersMethodDescriptor);
        return methodDescriptors;
    }

    @Override
    public UnaryCallable<GetUserRequest, User> getUserCallable() {
        return this.getUserCallable;
    }

    @Override
    public UnaryCallable<ListUsersRequest, ListUsersResponse> listUsersCallable() {
        return this.listUsersCallable;
    }

    @Override
    public UnaryCallable<ListUsersRequest, UserServiceClient.ListUsersPagedResponse> listUsersPagedCallable() {
        return this.listUsersPagedCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

