/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1.stub;

import com.google.ads.admanager.v1.BatchCreateEntitySignalsMappingsRequest;
import com.google.ads.admanager.v1.BatchCreateEntitySignalsMappingsResponse;
import com.google.ads.admanager.v1.BatchUpdateEntitySignalsMappingsRequest;
import com.google.ads.admanager.v1.BatchUpdateEntitySignalsMappingsResponse;
import com.google.ads.admanager.v1.CreateEntitySignalsMappingRequest;
import com.google.ads.admanager.v1.EntitySignalsMapping;
import com.google.ads.admanager.v1.EntitySignalsMappingServiceClient;
import com.google.ads.admanager.v1.GetEntitySignalsMappingRequest;
import com.google.ads.admanager.v1.ListEntitySignalsMappingsRequest;
import com.google.ads.admanager.v1.ListEntitySignalsMappingsResponse;
import com.google.ads.admanager.v1.UpdateEntitySignalsMappingRequest;
import com.google.ads.admanager.v1.stub.EntitySignalsMappingServiceStub;
import com.google.ads.admanager.v1.stub.HttpJsonEntitySignalsMappingServiceStub;
import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class EntitySignalsMappingServiceStubSettings
extends StubSettings<EntitySignalsMappingServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().build();
    private final UnaryCallSettings<GetEntitySignalsMappingRequest, EntitySignalsMapping> getEntitySignalsMappingSettings;
    private final PagedCallSettings<ListEntitySignalsMappingsRequest, ListEntitySignalsMappingsResponse, EntitySignalsMappingServiceClient.ListEntitySignalsMappingsPagedResponse> listEntitySignalsMappingsSettings;
    private final UnaryCallSettings<CreateEntitySignalsMappingRequest, EntitySignalsMapping> createEntitySignalsMappingSettings;
    private final UnaryCallSettings<UpdateEntitySignalsMappingRequest, EntitySignalsMapping> updateEntitySignalsMappingSettings;
    private final UnaryCallSettings<BatchCreateEntitySignalsMappingsRequest, BatchCreateEntitySignalsMappingsResponse> batchCreateEntitySignalsMappingsSettings;
    private final UnaryCallSettings<BatchUpdateEntitySignalsMappingsRequest, BatchUpdateEntitySignalsMappingsResponse> batchUpdateEntitySignalsMappingsSettings;
    private static final PagedListDescriptor<ListEntitySignalsMappingsRequest, ListEntitySignalsMappingsResponse, EntitySignalsMapping> LIST_ENTITY_SIGNALS_MAPPINGS_PAGE_STR_DESC = new PagedListDescriptor<ListEntitySignalsMappingsRequest, ListEntitySignalsMappingsResponse, EntitySignalsMapping>(){

        public String emptyToken() {
            return "";
        }

        public ListEntitySignalsMappingsRequest injectToken(ListEntitySignalsMappingsRequest payload, String token) {
            return ListEntitySignalsMappingsRequest.newBuilder((ListEntitySignalsMappingsRequest)payload).setPageToken(token).build();
        }

        public ListEntitySignalsMappingsRequest injectPageSize(ListEntitySignalsMappingsRequest payload, int pageSize) {
            return ListEntitySignalsMappingsRequest.newBuilder((ListEntitySignalsMappingsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListEntitySignalsMappingsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListEntitySignalsMappingsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<EntitySignalsMapping> extractResources(ListEntitySignalsMappingsResponse payload) {
            return payload.getEntitySignalsMappingsList();
        }
    };
    private static final PagedListResponseFactory<ListEntitySignalsMappingsRequest, ListEntitySignalsMappingsResponse, EntitySignalsMappingServiceClient.ListEntitySignalsMappingsPagedResponse> LIST_ENTITY_SIGNALS_MAPPINGS_PAGE_STR_FACT = new PagedListResponseFactory<ListEntitySignalsMappingsRequest, ListEntitySignalsMappingsResponse, EntitySignalsMappingServiceClient.ListEntitySignalsMappingsPagedResponse>(){

        public ApiFuture<EntitySignalsMappingServiceClient.ListEntitySignalsMappingsPagedResponse> getFuturePagedResponse(UnaryCallable<ListEntitySignalsMappingsRequest, ListEntitySignalsMappingsResponse> callable, ListEntitySignalsMappingsRequest request, ApiCallContext context, ApiFuture<ListEntitySignalsMappingsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_ENTITY_SIGNALS_MAPPINGS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return EntitySignalsMappingServiceClient.ListEntitySignalsMappingsPagedResponse.createAsync((PageContext<ListEntitySignalsMappingsRequest, ListEntitySignalsMappingsResponse, EntitySignalsMapping>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<GetEntitySignalsMappingRequest, EntitySignalsMapping> getEntitySignalsMappingSettings() {
        return this.getEntitySignalsMappingSettings;
    }

    public PagedCallSettings<ListEntitySignalsMappingsRequest, ListEntitySignalsMappingsResponse, EntitySignalsMappingServiceClient.ListEntitySignalsMappingsPagedResponse> listEntitySignalsMappingsSettings() {
        return this.listEntitySignalsMappingsSettings;
    }

    public UnaryCallSettings<CreateEntitySignalsMappingRequest, EntitySignalsMapping> createEntitySignalsMappingSettings() {
        return this.createEntitySignalsMappingSettings;
    }

    public UnaryCallSettings<UpdateEntitySignalsMappingRequest, EntitySignalsMapping> updateEntitySignalsMappingSettings() {
        return this.updateEntitySignalsMappingSettings;
    }

    public UnaryCallSettings<BatchCreateEntitySignalsMappingsRequest, BatchCreateEntitySignalsMappingsResponse> batchCreateEntitySignalsMappingsSettings() {
        return this.batchCreateEntitySignalsMappingsSettings;
    }

    public UnaryCallSettings<BatchUpdateEntitySignalsMappingsRequest, BatchUpdateEntitySignalsMappingsResponse> batchUpdateEntitySignalsMappingsSettings() {
        return this.batchUpdateEntitySignalsMappingsSettings;
    }

    public EntitySignalsMappingServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonEntitySignalsMappingServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "admanager";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "admanager.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "admanager.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return EntitySignalsMappingServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(EntitySignalsMappingServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected EntitySignalsMappingServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.getEntitySignalsMappingSettings = settingsBuilder.getEntitySignalsMappingSettings().build();
        this.listEntitySignalsMappingsSettings = settingsBuilder.listEntitySignalsMappingsSettings().build();
        this.createEntitySignalsMappingSettings = settingsBuilder.createEntitySignalsMappingSettings().build();
        this.updateEntitySignalsMappingSettings = settingsBuilder.updateEntitySignalsMappingSettings().build();
        this.batchCreateEntitySignalsMappingsSettings = settingsBuilder.batchCreateEntitySignalsMappingsSettings().build();
        this.batchUpdateEntitySignalsMappingsSettings = settingsBuilder.batchUpdateEntitySignalsMappingsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<EntitySignalsMappingServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<GetEntitySignalsMappingRequest, EntitySignalsMapping> getEntitySignalsMappingSettings;
        private final PagedCallSettings.Builder<ListEntitySignalsMappingsRequest, ListEntitySignalsMappingsResponse, EntitySignalsMappingServiceClient.ListEntitySignalsMappingsPagedResponse> listEntitySignalsMappingsSettings;
        private final UnaryCallSettings.Builder<CreateEntitySignalsMappingRequest, EntitySignalsMapping> createEntitySignalsMappingSettings;
        private final UnaryCallSettings.Builder<UpdateEntitySignalsMappingRequest, EntitySignalsMapping> updateEntitySignalsMappingSettings;
        private final UnaryCallSettings.Builder<BatchCreateEntitySignalsMappingsRequest, BatchCreateEntitySignalsMappingsResponse> batchCreateEntitySignalsMappingsSettings;
        private final UnaryCallSettings.Builder<BatchUpdateEntitySignalsMappingsRequest, BatchUpdateEntitySignalsMappingsResponse> batchUpdateEntitySignalsMappingsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.getEntitySignalsMappingSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listEntitySignalsMappingsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_ENTITY_SIGNALS_MAPPINGS_PAGE_STR_FACT);
            this.createEntitySignalsMappingSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateEntitySignalsMappingSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.batchCreateEntitySignalsMappingsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.batchUpdateEntitySignalsMappingsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getEntitySignalsMappingSettings, this.listEntitySignalsMappingsSettings, this.createEntitySignalsMappingSettings, this.updateEntitySignalsMappingSettings, this.batchCreateEntitySignalsMappingsSettings, this.batchUpdateEntitySignalsMappingsSettings);
            Builder.initDefaults(this);
        }

        protected Builder(EntitySignalsMappingServiceStubSettings settings) {
            super((StubSettings)settings);
            this.getEntitySignalsMappingSettings = settings.getEntitySignalsMappingSettings.toBuilder();
            this.listEntitySignalsMappingsSettings = settings.listEntitySignalsMappingsSettings.toBuilder();
            this.createEntitySignalsMappingSettings = settings.createEntitySignalsMappingSettings.toBuilder();
            this.updateEntitySignalsMappingSettings = settings.updateEntitySignalsMappingSettings.toBuilder();
            this.batchCreateEntitySignalsMappingsSettings = settings.batchCreateEntitySignalsMappingsSettings.toBuilder();
            this.batchUpdateEntitySignalsMappingsSettings = settings.batchUpdateEntitySignalsMappingsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getEntitySignalsMappingSettings, this.listEntitySignalsMappingsSettings, this.createEntitySignalsMappingSettings, this.updateEntitySignalsMappingSettings, this.batchCreateEntitySignalsMappingsSettings, this.batchUpdateEntitySignalsMappingsSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(EntitySignalsMappingServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)EntitySignalsMappingServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)EntitySignalsMappingServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(EntitySignalsMappingServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.getEntitySignalsMappingSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listEntitySignalsMappingsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createEntitySignalsMappingSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.updateEntitySignalsMappingSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.batchCreateEntitySignalsMappingsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.batchUpdateEntitySignalsMappingsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<GetEntitySignalsMappingRequest, EntitySignalsMapping> getEntitySignalsMappingSettings() {
            return this.getEntitySignalsMappingSettings;
        }

        public PagedCallSettings.Builder<ListEntitySignalsMappingsRequest, ListEntitySignalsMappingsResponse, EntitySignalsMappingServiceClient.ListEntitySignalsMappingsPagedResponse> listEntitySignalsMappingsSettings() {
            return this.listEntitySignalsMappingsSettings;
        }

        public UnaryCallSettings.Builder<CreateEntitySignalsMappingRequest, EntitySignalsMapping> createEntitySignalsMappingSettings() {
            return this.createEntitySignalsMappingSettings;
        }

        public UnaryCallSettings.Builder<UpdateEntitySignalsMappingRequest, EntitySignalsMapping> updateEntitySignalsMappingSettings() {
            return this.updateEntitySignalsMappingSettings;
        }

        public UnaryCallSettings.Builder<BatchCreateEntitySignalsMappingsRequest, BatchCreateEntitySignalsMappingsResponse> batchCreateEntitySignalsMappingsSettings() {
            return this.batchCreateEntitySignalsMappingsSettings;
        }

        public UnaryCallSettings.Builder<BatchUpdateEntitySignalsMappingsRequest, BatchUpdateEntitySignalsMappingsResponse> batchUpdateEntitySignalsMappingsSettings() {
            return this.batchUpdateEntitySignalsMappingsSettings;
        }

        public EntitySignalsMappingServiceStubSettings build() throws IOException {
            return new EntitySignalsMappingServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

