/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1.stub;

import com.google.ads.admanager.v1.Contact;
import com.google.ads.admanager.v1.ContactServiceClient;
import com.google.ads.admanager.v1.GetContactRequest;
import com.google.ads.admanager.v1.ListContactsRequest;
import com.google.ads.admanager.v1.ListContactsResponse;
import com.google.ads.admanager.v1.stub.ContactServiceStub;
import com.google.ads.admanager.v1.stub.HttpJsonContactServiceStub;
import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class ContactServiceStubSettings
extends StubSettings<ContactServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().build();
    private final UnaryCallSettings<GetContactRequest, Contact> getContactSettings;
    private final PagedCallSettings<ListContactsRequest, ListContactsResponse, ContactServiceClient.ListContactsPagedResponse> listContactsSettings;
    private static final PagedListDescriptor<ListContactsRequest, ListContactsResponse, Contact> LIST_CONTACTS_PAGE_STR_DESC = new PagedListDescriptor<ListContactsRequest, ListContactsResponse, Contact>(){

        public String emptyToken() {
            return "";
        }

        public ListContactsRequest injectToken(ListContactsRequest payload, String token) {
            return ListContactsRequest.newBuilder((ListContactsRequest)payload).setPageToken(token).build();
        }

        public ListContactsRequest injectPageSize(ListContactsRequest payload, int pageSize) {
            return ListContactsRequest.newBuilder((ListContactsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListContactsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListContactsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Contact> extractResources(ListContactsResponse payload) {
            return payload.getContactsList();
        }
    };
    private static final PagedListResponseFactory<ListContactsRequest, ListContactsResponse, ContactServiceClient.ListContactsPagedResponse> LIST_CONTACTS_PAGE_STR_FACT = new PagedListResponseFactory<ListContactsRequest, ListContactsResponse, ContactServiceClient.ListContactsPagedResponse>(){

        public ApiFuture<ContactServiceClient.ListContactsPagedResponse> getFuturePagedResponse(UnaryCallable<ListContactsRequest, ListContactsResponse> callable, ListContactsRequest request, ApiCallContext context, ApiFuture<ListContactsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_CONTACTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ContactServiceClient.ListContactsPagedResponse.createAsync((PageContext<ListContactsRequest, ListContactsResponse, Contact>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<GetContactRequest, Contact> getContactSettings() {
        return this.getContactSettings;
    }

    public PagedCallSettings<ListContactsRequest, ListContactsResponse, ContactServiceClient.ListContactsPagedResponse> listContactsSettings() {
        return this.listContactsSettings;
    }

    public ContactServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonContactServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "admanager";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "admanager.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "admanager.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return ContactServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(ContactServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected ContactServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.getContactSettings = settingsBuilder.getContactSettings().build();
        this.listContactsSettings = settingsBuilder.listContactsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<ContactServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<GetContactRequest, Contact> getContactSettings;
        private final PagedCallSettings.Builder<ListContactsRequest, ListContactsResponse, ContactServiceClient.ListContactsPagedResponse> listContactsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.getContactSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listContactsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_CONTACTS_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getContactSettings, this.listContactsSettings);
            Builder.initDefaults(this);
        }

        protected Builder(ContactServiceStubSettings settings) {
            super((StubSettings)settings);
            this.getContactSettings = settings.getContactSettings.toBuilder();
            this.listContactsSettings = settings.listContactsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getContactSettings, this.listContactsSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(ContactServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)ContactServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)ContactServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(ContactServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.getContactSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listContactsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<GetContactRequest, Contact> getContactSettings() {
            return this.getContactSettings;
        }

        public PagedCallSettings.Builder<ListContactsRequest, ListContactsResponse, ContactServiceClient.ListContactsPagedResponse> listContactsSettings() {
            return this.listContactsSettings;
        }

        public ContactServiceStubSettings build() throws IOException {
            return new ContactServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

