/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1;

import com.google.ads.admanager.v1.AdPartner;
import com.google.ads.admanager.v1.AdPartnerName;
import com.google.ads.admanager.v1.AdPartnerServiceSettings;
import com.google.ads.admanager.v1.GetAdPartnerRequest;
import com.google.ads.admanager.v1.ListAdPartnersRequest;
import com.google.ads.admanager.v1.ListAdPartnersResponse;
import com.google.ads.admanager.v1.NetworkName;
import com.google.ads.admanager.v1.stub.AdPartnerServiceStub;
import com.google.ads.admanager.v1.stub.AdPartnerServiceStubSettings;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class AdPartnerServiceClient
implements BackgroundResource {
    private final AdPartnerServiceSettings settings;
    private final AdPartnerServiceStub stub;

    public static final AdPartnerServiceClient create() throws IOException {
        return AdPartnerServiceClient.create(AdPartnerServiceSettings.newBuilder().build());
    }

    public static final AdPartnerServiceClient create(AdPartnerServiceSettings settings) throws IOException {
        return new AdPartnerServiceClient(settings);
    }

    public static final AdPartnerServiceClient create(AdPartnerServiceStub stub) {
        return new AdPartnerServiceClient(stub);
    }

    protected AdPartnerServiceClient(AdPartnerServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((AdPartnerServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected AdPartnerServiceClient(AdPartnerServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final AdPartnerServiceSettings getSettings() {
        return this.settings;
    }

    public AdPartnerServiceStub getStub() {
        return this.stub;
    }

    public final AdPartner getAdPartner(AdPartnerName name) {
        GetAdPartnerRequest request = GetAdPartnerRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getAdPartner(request);
    }

    public final AdPartner getAdPartner(String name) {
        GetAdPartnerRequest request = GetAdPartnerRequest.newBuilder().setName(name).build();
        return this.getAdPartner(request);
    }

    public final AdPartner getAdPartner(GetAdPartnerRequest request) {
        return (AdPartner)this.getAdPartnerCallable().call((Object)request);
    }

    public final UnaryCallable<GetAdPartnerRequest, AdPartner> getAdPartnerCallable() {
        return this.stub.getAdPartnerCallable();
    }

    public final ListAdPartnersPagedResponse listAdPartners(NetworkName parent) {
        ListAdPartnersRequest request = ListAdPartnersRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listAdPartners(request);
    }

    public final ListAdPartnersPagedResponse listAdPartners(String parent) {
        ListAdPartnersRequest request = ListAdPartnersRequest.newBuilder().setParent(parent).build();
        return this.listAdPartners(request);
    }

    public final ListAdPartnersPagedResponse listAdPartners(ListAdPartnersRequest request) {
        return (ListAdPartnersPagedResponse)((Object)this.listAdPartnersPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListAdPartnersRequest, ListAdPartnersPagedResponse> listAdPartnersPagedCallable() {
        return this.stub.listAdPartnersPagedCallable();
    }

    public final UnaryCallable<ListAdPartnersRequest, ListAdPartnersResponse> listAdPartnersCallable() {
        return this.stub.listAdPartnersCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListAdPartnersFixedSizeCollection
    extends AbstractFixedSizeCollection<ListAdPartnersRequest, ListAdPartnersResponse, AdPartner, ListAdPartnersPage, ListAdPartnersFixedSizeCollection> {
        private ListAdPartnersFixedSizeCollection(List<ListAdPartnersPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListAdPartnersFixedSizeCollection createEmptyCollection() {
            return new ListAdPartnersFixedSizeCollection(null, 0);
        }

        protected ListAdPartnersFixedSizeCollection createCollection(List<ListAdPartnersPage> pages, int collectionSize) {
            return new ListAdPartnersFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListAdPartnersPage
    extends AbstractPage<ListAdPartnersRequest, ListAdPartnersResponse, AdPartner, ListAdPartnersPage> {
        private ListAdPartnersPage(PageContext<ListAdPartnersRequest, ListAdPartnersResponse, AdPartner> context, ListAdPartnersResponse response) {
            super(context, (Object)response);
        }

        private static ListAdPartnersPage createEmptyPage() {
            return new ListAdPartnersPage(null, null);
        }

        protected ListAdPartnersPage createPage(PageContext<ListAdPartnersRequest, ListAdPartnersResponse, AdPartner> context, ListAdPartnersResponse response) {
            return new ListAdPartnersPage(context, response);
        }

        public ApiFuture<ListAdPartnersPage> createPageAsync(PageContext<ListAdPartnersRequest, ListAdPartnersResponse, AdPartner> context, ApiFuture<ListAdPartnersResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListAdPartnersPagedResponse
    extends AbstractPagedListResponse<ListAdPartnersRequest, ListAdPartnersResponse, AdPartner, ListAdPartnersPage, ListAdPartnersFixedSizeCollection> {
        public static ApiFuture<ListAdPartnersPagedResponse> createAsync(PageContext<ListAdPartnersRequest, ListAdPartnersResponse, AdPartner> context, ApiFuture<ListAdPartnersResponse> futureResponse) {
            ApiFuture<ListAdPartnersPage> futurePage = ListAdPartnersPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListAdPartnersPagedResponse((ListAdPartnersPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListAdPartnersPagedResponse(ListAdPartnersPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListAdPartnersFixedSizeCollection.createEmptyCollection());
        }
    }
}

