/*
 * Decompiled with CFR 0.152.
 */
package com.google.androidbrowserhelper.playbilling.provider;

import android.util.Log;
import androidx.annotation.Nullable;
import com.android.billingclient.api.BillingResult;
import com.android.billingclient.api.Purchase;
import java.util.List;

public class Logging {
    private static final String TAG = "TwaBilling.P";

    static void logLaunchPaymentFlow(BillingResult result) {
        Logging.logResult(result, "Payment flow launch:");
    }

    static void logPurchasesUpdate(BillingResult result, @Nullable List<Purchase> list) {
        Logging.logResult(result, "Purchases updated:");
        if (list == null) {
            Log.d((String)TAG, (String)"No items updated.");
        } else {
            Log.d((String)TAG, (String)(list.size() + " item(s) updated."));
        }
    }

    private static void logResult(BillingResult result, String message) {
        int responseCode = result.getResponseCode();
        Log.d((String)TAG, (String)(message + " " + responseCode));
        String debugMessage = result.getDebugMessage();
        if (debugMessage != null && !debugMessage.isEmpty()) {
            Log.d((String)TAG, (String)debugMessage);
        }
    }
}

