/*
 * Decompiled with CFR 0.152.
 */
package com.google.androidbrowserhelper.playbilling.digitalgoods;

import android.os.Bundle;
import com.android.billingclient.api.Purchase;

public class PurchaseDetails {
    private static final String KEY_ITEM_ID = "purchaseDetails.itemId";
    private static final String KEY_PURCHASE_TOKEN = "purchaseDetails.purchaseToken";
    private static final String KEY_ACKNOWLEDGED = "purchaseDetails.acknowledged";
    private static final String KEY_PURCHASE_STATE = "purchaseDetails.purchaseState";
    private static final String KEY_PURCHASE_TIME_MICROSECONDS_PAST_UNIX_EPOCH = "purchaseDetails.purchaseTimeMicrosecondsPastUnixEpoch";
    private static final String KEY_WILL_AUTO_RENEW = "purchaseDetails.willAutoRenew";
    static final int CHROMIUM_PURCHASE_STATE_UNKNOWN = 0;
    static final int CHROMIUM_PURCHASE_STATE_PURCHASED = 1;
    static final int CHROMIUM_PURCHASE_STATE_PENDING = 2;
    public final String id;
    public final String purchaseToken;
    public final boolean acknowledged;
    public final int purchaseState;
    public final long purchaseTimeMicrosecondsPastUnixEpoch;
    public final boolean willAutoRenew;

    private PurchaseDetails(String id, String purchaseToken, boolean acknowledged, int purchaseState, long purchaseTimeMicrosecondsPastUnixEpoch, boolean willAutoRenew) {
        this.id = id;
        this.purchaseToken = purchaseToken;
        this.acknowledged = acknowledged;
        this.purchaseState = purchaseState;
        this.purchaseTimeMicrosecondsPastUnixEpoch = purchaseTimeMicrosecondsPastUnixEpoch;
        this.willAutoRenew = willAutoRenew;
    }

    public static PurchaseDetails create(Purchase purchase) {
        return new PurchaseDetails(purchase.getSku(), purchase.getPurchaseToken(), purchase.isAcknowledged(), PurchaseDetails.toChromiumPurchaseState(purchase.getPurchaseState()), PurchaseDetails.millisecondsToMicroseconds(purchase.getPurchaseTime()), purchase.isAutoRenewing());
    }

    public static PurchaseDetails create(Bundle bundle) {
        String id = bundle.getString(KEY_ITEM_ID);
        String token = bundle.getString(KEY_PURCHASE_TOKEN);
        boolean acknowledged = bundle.getBoolean(KEY_ACKNOWLEDGED);
        int state = bundle.getInt(KEY_PURCHASE_STATE);
        long timeMsPastUnixEpoch = bundle.getLong(KEY_PURCHASE_TIME_MICROSECONDS_PAST_UNIX_EPOCH);
        boolean willAutoRenew = bundle.getBoolean(KEY_WILL_AUTO_RENEW);
        return new PurchaseDetails(id, token, acknowledged, state, timeMsPastUnixEpoch, willAutoRenew);
    }

    public Bundle toBundle() {
        Bundle bundle = new Bundle();
        bundle.putString(KEY_ITEM_ID, this.id);
        bundle.putString(KEY_PURCHASE_TOKEN, this.purchaseToken);
        bundle.putBoolean(KEY_ACKNOWLEDGED, this.acknowledged);
        bundle.putInt(KEY_PURCHASE_STATE, this.purchaseState);
        bundle.putLong(KEY_PURCHASE_TIME_MICROSECONDS_PAST_UNIX_EPOCH, this.purchaseTimeMicrosecondsPastUnixEpoch);
        bundle.putBoolean(KEY_WILL_AUTO_RENEW, this.willAutoRenew);
        return bundle;
    }

    private static long millisecondsToMicroseconds(long milliseconds) {
        return milliseconds * 1000L;
    }

    private static int toChromiumPurchaseState(int purchaseState) {
        switch (purchaseState) {
            case 2: {
                return 2;
            }
            case 1: {
                return 1;
            }
        }
        return 0;
    }
}

