/*
 * Decompiled with CFR 0.152.
 */
package com.google.androidbrowserhelper.playbilling.digitalgoods;

import android.os.Bundle;
import android.os.Parcelable;
import androidx.annotation.Nullable;
import com.android.billingclient.api.BillingResult;
import com.android.billingclient.api.Purchase;
import com.google.androidbrowserhelper.playbilling.digitalgoods.BillingResultMerger;
import com.google.androidbrowserhelper.playbilling.digitalgoods.DigitalGoodsCallback;
import com.google.androidbrowserhelper.playbilling.digitalgoods.DigitalGoodsConverter;
import com.google.androidbrowserhelper.playbilling.digitalgoods.Logging;
import com.google.androidbrowserhelper.playbilling.digitalgoods.PurchaseDetails;
import com.google.androidbrowserhelper.playbilling.provider.BillingWrapper;
import java.util.List;

public class ListPurchasesCall {
    public static final String COMMAND_NAME = "listPurchases";
    static final String RESPONSE_COMMAND = "listPurchases.response";
    static final String KEY_PURCHASES_LIST = "listPurchases.purchasesList";
    static final String KEY_RESPONSE_CODE = "listPurchases.responseCode";
    private final DigitalGoodsCallback mCallback;

    private ListPurchasesCall(DigitalGoodsCallback callback) {
        this.mCallback = callback;
    }

    @Nullable
    public static ListPurchasesCall create(@Nullable DigitalGoodsCallback callback) {
        if (callback == null) {
            return null;
        }
        return new ListPurchasesCall(callback);
    }

    public void call(BillingWrapper billing) {
        Logging.logListPurchasesCall();
        BillingResultMerger merger = new BillingResultMerger(this::respond);
        billing.queryPurchases("inapp", result -> merger.setInAppResult(result.getBillingResult(), result.getPurchasesList()));
        billing.queryPurchases("subs", result -> merger.setSubsResult(result.getBillingResult(), result.getPurchasesList()));
    }

    private void respond(BillingResult result, @Nullable List<Purchase> purchaseList) {
        Logging.logListPurchasesResult(result);
        Parcelable[] parcelables = new Parcelable[]{};
        if (purchaseList != null) {
            parcelables = new Parcelable[purchaseList.size()];
            int index = 0;
            for (Purchase purchase : purchaseList) {
                parcelables[index++] = PurchaseDetails.create(purchase).toBundle();
            }
        }
        Bundle args = new Bundle();
        args.putInt(KEY_RESPONSE_CODE, DigitalGoodsConverter.toChromiumResponseCode(result));
        args.putParcelableArray(KEY_PURCHASES_LIST, parcelables);
        this.mCallback.run(RESPONSE_COMMAND, args);
    }
}

