/*
 * Decompiled with CFR 0.152.
 */
package com.google.androidbrowserhelper.playbilling.digitalgoods;

import android.os.Bundle;
import com.android.billingclient.api.SkuDetails;

public class ItemDetails {
    private static final String KEY_DETAILS_ID = "itemDetails.id";
    private static final String KEY_DETAILS_TITLE = "itemDetails.title";
    private static final String KEY_DETAILS_DESC = "itemDetails.description";
    private static final String KEY_DETAILS_CURRENCY = "itemDetails.currency";
    private static final String KEY_DETAILS_VALUE = "itemDetails.value";
    private static final String KEY_SUBS_PERIOD = "itemDetails.subsPeriod";
    private static final String KEY_FREE_TRIAL_PERIOD = "itemDetails.freeTrialPeriod";
    private static final String KEY_INTRO_PERIOD = "itemDetails.introPricePeriod";
    private static final String KEY_INTRO_CURRENCY = "itemDetails.introPriceCurrency";
    private static final String KEY_INTRO_VALUE = "itemDetails.introPriceValue";
    public final String id;
    public final String title;
    public final String description;
    public final String currency;
    public final String value;
    public final String subscriptionPeriod;
    public final String freeTrialPeriod;
    public final String introductoryPricePeriod;
    public final String introductoryPriceCurrency;
    public final String introductoryPriceValue;

    private ItemDetails(String id, String title, String description, String currency, String value, String subscriptionPeriod, String freeTrialPeriod, String introductoryPricePeriod, String introductoryPriceCurrency, String introductoryPriceValue) {
        this.id = id;
        this.title = title;
        this.description = description;
        this.currency = currency;
        this.value = value;
        this.subscriptionPeriod = subscriptionPeriod;
        this.freeTrialPeriod = freeTrialPeriod;
        this.introductoryPricePeriod = introductoryPricePeriod;
        this.introductoryPriceCurrency = introductoryPriceCurrency;
        this.introductoryPriceValue = introductoryPriceValue;
    }

    public static ItemDetails create(SkuDetails skuDetails) {
        return new ItemDetails(skuDetails.getSku(), skuDetails.getTitle(), skuDetails.getDescription(), skuDetails.getPriceCurrencyCode(), ItemDetails.toPrice(skuDetails.getPriceAmountMicros()), skuDetails.getSubscriptionPeriod(), skuDetails.getFreeTrialPeriod(), skuDetails.getIntroductoryPricePeriod(), skuDetails.getPriceCurrencyCode(), ItemDetails.toPrice(skuDetails.getIntroductoryPriceAmountMicros()));
    }

    public static ItemDetails create(Bundle bundle) {
        String id = bundle.getString(KEY_DETAILS_ID);
        String title = bundle.getString(KEY_DETAILS_TITLE);
        String description = bundle.getString(KEY_DETAILS_DESC);
        String currency = bundle.getString(KEY_DETAILS_CURRENCY);
        String value = bundle.getString(KEY_DETAILS_VALUE);
        String subscriptionPeriod = bundle.getString(KEY_SUBS_PERIOD);
        String freeTrialPeriod = bundle.getString(KEY_FREE_TRIAL_PERIOD);
        String introductoryPricePeriod = bundle.getString(KEY_INTRO_PERIOD);
        String introductoryPriceCurrency = bundle.getString(KEY_INTRO_CURRENCY);
        String introductoryPriceValue = bundle.getString(KEY_INTRO_VALUE);
        return new ItemDetails(id, title, description, currency, value, subscriptionPeriod, freeTrialPeriod, introductoryPricePeriod, introductoryPriceCurrency, introductoryPriceValue);
    }

    public Bundle toBundle() {
        Bundle bundle = new Bundle();
        bundle.putString(KEY_DETAILS_ID, this.id);
        bundle.putString(KEY_DETAILS_TITLE, this.title);
        bundle.putString(KEY_DETAILS_DESC, this.description);
        bundle.putString(KEY_DETAILS_CURRENCY, this.currency);
        bundle.putString(KEY_DETAILS_VALUE, this.value);
        bundle.putString(KEY_SUBS_PERIOD, this.subscriptionPeriod);
        bundle.putString(KEY_FREE_TRIAL_PERIOD, this.freeTrialPeriod);
        bundle.putString(KEY_INTRO_PERIOD, this.introductoryPricePeriod);
        bundle.putString(KEY_INTRO_CURRENCY, this.introductoryPriceCurrency);
        bundle.putString(KEY_INTRO_VALUE, this.introductoryPriceValue);
        return bundle;
    }

    static String toPrice(long priceAmountMicros) {
        int insertionIndex;
        StringBuilder sb = new StringBuilder(String.valueOf(priceAmountMicros));
        int desiredLength = priceAmountMicros >= 0L ? 7 : 8;
        int n = insertionIndex = priceAmountMicros >= 0L ? 0 : 1;
        while (sb.length() < desiredLength) {
            sb.insert(insertionIndex, "0");
        }
        sb.insert(sb.length() - 6, ".");
        return sb.toString();
    }
}

