/*
 * Decompiled with CFR 0.152.
 */
package com.google.androidbrowserhelper.playbilling.digitalgoods;

import android.content.Context;
import android.os.Bundle;
import android.os.RemoteException;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.browser.trusted.TrustedWebActivityCallbackRemote;
import com.google.androidbrowserhelper.playbilling.digitalgoods.AcknowledgeCall;
import com.google.androidbrowserhelper.playbilling.digitalgoods.ConnectedBillingWrapper;
import com.google.androidbrowserhelper.playbilling.digitalgoods.DigitalGoodsCallback;
import com.google.androidbrowserhelper.playbilling.digitalgoods.GetDetailsCall;
import com.google.androidbrowserhelper.playbilling.digitalgoods.ListPurchasesCall;
import com.google.androidbrowserhelper.playbilling.digitalgoods.Logging;
import com.google.androidbrowserhelper.playbilling.provider.BillingWrapper;
import com.google.androidbrowserhelper.playbilling.provider.BillingWrapperFactory;
import com.google.androidbrowserhelper.trusted.ExtraCommandHandler;

public class DigitalGoodsRequestHandler
implements ExtraCommandHandler {
    private final BillingWrapper mWrapper;
    private final BillingWrapper.Listener mListener = (result, token) -> {};

    public DigitalGoodsRequestHandler(Context context) {
        this.mWrapper = new ConnectedBillingWrapper(BillingWrapperFactory.get(context, this.mListener));
    }

    @NonNull
    public Bundle handleExtraCommand(Context context, String commandName, Bundle args, @Nullable TrustedWebActivityCallbackRemote callback) {
        DigitalGoodsCallback wrappedCallback = (callbackName, callbackArgs) -> {
            try {
                callback.runExtraCallback(callbackName, callbackArgs);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        };
        boolean success = this.handle(commandName, args, wrappedCallback);
        Bundle bundle = new Bundle();
        bundle.putBoolean("success", success);
        return bundle;
    }

    public boolean handle(@NonNull String commandName, @NonNull Bundle args, @Nullable DigitalGoodsCallback callback) {
        switch (commandName) {
            case "getDetails": {
                GetDetailsCall getDetailsCall = GetDetailsCall.create(args, callback);
                if (getDetailsCall == null) break;
                getDetailsCall.call(this.mWrapper);
                return true;
            }
            case "acknowledge": {
                AcknowledgeCall acknowledgeCall = AcknowledgeCall.create(args, callback);
                if (acknowledgeCall == null) break;
                acknowledgeCall.call(this.mWrapper);
                return true;
            }
            case "listPurchases": {
                ListPurchasesCall listPurchasesCall = ListPurchasesCall.create(callback);
                if (listPurchasesCall == null) break;
                listPurchasesCall.call(this.mWrapper);
                return true;
            }
        }
        Logging.logUnknownCommand(commandName);
        return false;
    }
}

