/*
 * Decompiled with CFR 0.152.
 */
package com.google.androidbrowserhelper.playbilling.digitalgoods;

import android.app.Activity;
import com.android.billingclient.api.AcknowledgePurchaseResponseListener;
import com.android.billingclient.api.BillingClientStateListener;
import com.android.billingclient.api.BillingResult;
import com.android.billingclient.api.ConsumeResponseListener;
import com.android.billingclient.api.SkuDetails;
import com.android.billingclient.api.SkuDetailsResponseListener;
import com.google.androidbrowserhelper.playbilling.digitalgoods.Logging;
import com.google.androidbrowserhelper.playbilling.provider.BillingWrapper;
import com.google.androidbrowserhelper.playbilling.provider.MethodData;
import java.util.ArrayList;
import java.util.List;

public class ConnectedBillingWrapper
implements BillingWrapper {
    private final BillingWrapper mInner;
    private static final int NOT_CONNECTED = 0;
    private static final int CONNECTING = 1;
    private static final int CONNECTED = 2;
    private int mState = 0;
    private final List<Runnable> mPendingCallbacks = new ArrayList<Runnable>();

    public ConnectedBillingWrapper(BillingWrapper mInner) {
        this.mInner = mInner;
    }

    private void execute(Runnable callback) {
        if (this.mState == 2) {
            callback.run();
            return;
        }
        this.mPendingCallbacks.add(callback);
        if (this.mState == 1) {
            return;
        }
        this.mState = 1;
        this.mInner.connect(new BillingClientStateListener(){

            public void onBillingSetupFinished(BillingResult billingResult) {
                Logging.logConnected();
                ConnectedBillingWrapper.this.mState = 2;
                for (Runnable callback : ConnectedBillingWrapper.this.mPendingCallbacks) {
                    callback.run();
                }
                ConnectedBillingWrapper.this.mPendingCallbacks.clear();
            }

            public void onBillingServiceDisconnected() {
                Logging.logDisconnected();
                ConnectedBillingWrapper.this.mState = 0;
            }
        });
    }

    @Override
    public void connect(BillingClientStateListener callback) {
        this.execute(() -> {});
    }

    @Override
    public void querySkuDetails(String skuType, List<String> skus, SkuDetailsResponseListener callback) {
        this.execute(() -> this.mInner.querySkuDetails(skuType, skus, callback));
    }

    @Override
    public void queryPurchases(String skuType, BillingWrapper.QueryPurchasesListener callback) {
        this.execute(() -> this.mInner.queryPurchases(skuType, callback));
    }

    @Override
    public void acknowledge(String token, AcknowledgePurchaseResponseListener callback) {
        this.execute(() -> this.mInner.acknowledge(token, callback));
    }

    @Override
    public void consume(String token, ConsumeResponseListener callback) {
        this.execute(() -> this.mInner.consume(token, callback));
    }

    @Override
    public boolean launchPaymentFlow(Activity activity, SkuDetails sku, MethodData data) {
        throw new IllegalStateException("EnsuredConnectionBillingWrapper doesn't handle launch Payment flow");
    }
}

