/*
 * Decompiled with CFR 0.152.
 */
package com.google.androidbrowserhelper.playbilling.digitalgoods;

import androidx.annotation.Nullable;
import com.android.billingclient.api.BillingResult;
import java.util.ArrayList;
import java.util.List;

public class BillingResultMerger<T> {
    private final ResultListener<T> mOnCombinedResult;
    @Nullable
    private BillingResult mInAppResult;
    @Nullable
    private List<T> mInAppResultsList;
    @Nullable
    private BillingResult mSubsResult;
    @Nullable
    private List<T> mSubsResultsList;

    public BillingResultMerger(ResultListener<T> onCombinedResult) {
        this.mOnCombinedResult = onCombinedResult;
    }

    public void setInAppResult(BillingResult result, @Nullable List<T> resultsList) {
        this.mInAppResult = result;
        this.mInAppResultsList = resultsList;
        this.triggerIfReady();
    }

    public void setSubsResult(BillingResult result, @Nullable List<T> resultsList) {
        this.mSubsResult = result;
        this.mSubsResultsList = resultsList;
        this.triggerIfReady();
    }

    private void triggerIfReady() {
        List<T> detailsList;
        BillingResult result;
        if (this.mSubsResult == null || this.mInAppResult == null) {
            return;
        }
        if (this.mSubsResultsList == null || this.mSubsResultsList.isEmpty()) {
            result = this.mInAppResult;
            detailsList = this.mInAppResultsList;
        } else if (this.mInAppResultsList == null || this.mInAppResultsList.isEmpty()) {
            result = this.mSubsResult;
            detailsList = this.mSubsResultsList;
        } else {
            result = BillingResultMerger.didSucceed(this.mInAppResult) && !BillingResultMerger.didSucceed(this.mSubsResult) ? this.mSubsResult : this.mInAppResult;
            detailsList = new ArrayList<T>(this.mInAppResultsList);
            detailsList.addAll(this.mSubsResultsList);
        }
        this.mOnCombinedResult.onResult(result, detailsList);
    }

    private static boolean didSucceed(BillingResult result) {
        return result.getResponseCode() == 0;
    }

    public static interface ResultListener<T> {
        public void onResult(BillingResult var1, @Nullable List<T> var2);
    }
}

