/*
 * Decompiled with CFR 0.152.
 */
package com.google.androidbrowserhelper.playbilling.digitalgoods;

import android.os.Bundle;
import androidx.annotation.Nullable;
import com.android.billingclient.api.BillingResult;
import com.google.androidbrowserhelper.playbilling.digitalgoods.DigitalGoodsCallback;
import com.google.androidbrowserhelper.playbilling.digitalgoods.DigitalGoodsConverter;
import com.google.androidbrowserhelper.playbilling.digitalgoods.Logging;
import com.google.androidbrowserhelper.playbilling.provider.BillingWrapper;

public class AcknowledgeCall {
    public static final String COMMAND_NAME = "acknowledge";
    private static final String PARAM_ACKNOWLEDGE_PURCHASE_TOKEN = "acknowledge.purchaseToken";
    private static final String PARAM_ACKNOWLEDGE_MAKE_AVAILABLE_AGAIN = "acknowledge.makeAvailableAgain";
    static final String RESPONSE_ACKNOWLEDGE = "acknowledge.response";
    static final String RESPONSE_ACKNOWLEDGE_RESPONSE_CODE = "acknowledge.responseCode";
    public final String purchaseToken;
    public final boolean makeAvailableAgain;
    private final DigitalGoodsCallback mCallback;

    private AcknowledgeCall(String purchaseToken, boolean makeAvailableAgain, DigitalGoodsCallback mCallback) {
        this.purchaseToken = purchaseToken;
        this.makeAvailableAgain = makeAvailableAgain;
        this.mCallback = mCallback;
    }

    @Nullable
    public static AcknowledgeCall create(@Nullable Bundle args, @Nullable DigitalGoodsCallback callback) {
        if (args == null || callback == null) {
            return null;
        }
        if (!args.containsKey(PARAM_ACKNOWLEDGE_PURCHASE_TOKEN) || !args.containsKey(PARAM_ACKNOWLEDGE_MAKE_AVAILABLE_AGAIN)) {
            return null;
        }
        String token = args.getString(PARAM_ACKNOWLEDGE_PURCHASE_TOKEN);
        boolean makeAvailableAgain = args.getBoolean(PARAM_ACKNOWLEDGE_MAKE_AVAILABLE_AGAIN);
        return new AcknowledgeCall(token, makeAvailableAgain, callback);
    }

    private void respond(BillingResult result) {
        Logging.logAckResponse(result, this.makeAvailableAgain);
        Bundle args = new Bundle();
        args.putInt(RESPONSE_ACKNOWLEDGE_RESPONSE_CODE, DigitalGoodsConverter.toChromiumResponseCode(result));
        this.mCallback.run(RESPONSE_ACKNOWLEDGE, args);
    }

    public void call(BillingWrapper billing) {
        Logging.logAckCall(this.purchaseToken, this.makeAvailableAgain);
        if (this.makeAvailableAgain) {
            billing.consume(this.purchaseToken, (result, token) -> this.respond(result));
        } else {
            billing.acknowledge(this.purchaseToken, this::respond);
        }
    }

    static Bundle createBundleForTesting(String token, boolean makeAvailableAgain) {
        Bundle bundle = new Bundle();
        bundle.putString(PARAM_ACKNOWLEDGE_PURCHASE_TOKEN, token);
        bundle.putBoolean(PARAM_ACKNOWLEDGE_MAKE_AVAILABLE_AGAIN, makeAvailableAgain);
        return bundle;
    }
}

