/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.play.core.splitcompat;

import android.content.Context;
import android.content.pm.PackageManager;
import android.util.Log;
import com.google.android.play.core.splitcompat.zzb;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class zze {
    private final long zza;
    private final Context zzb;
    private File zzc;

    private static File zzq(File file, String string) throws IOException {
        File file2 = new File(file, string);
        if (!file2.getCanonicalPath().startsWith(file.getCanonicalPath())) {
            throw new IllegalArgumentException("split ID cannot be placed in target directory");
        }
        return file2;
    }

    private final File zzr() throws IOException {
        File file = new File(this.zzw(), "native-libraries");
        zze.zzu(file);
        return file;
    }

    private final File zzs(String string) throws IOException {
        File file = zze.zzq(this.zzr(), string);
        zze.zzu(file);
        return file;
    }

    public final File zza(String string) throws IOException {
        File file = new File(this.zzw(), "dex");
        zze.zzu(file);
        File file2 = zze.zzq(file, string);
        zze.zzu(file2);
        return file2;
    }

    public final File zzb() throws IOException {
        File file = new File(this.zzw(), "unverified-splits");
        zze.zzu(file);
        return file;
    }

    private final File zzt() throws IOException {
        File file = new File(this.zzw(), "verified-splits");
        zze.zzu(file);
        return file;
    }

    public final File zzc(String string, String string2) throws IOException {
        return zze.zzq(this.zzs(string), string2);
    }

    public final File zzd() throws IOException {
        return new File(this.zzw(), "lock.tmp");
    }

    public final File zze(String string) throws IOException {
        return zze.zzq(this.zzb(), zze.zzx(string));
    }

    public final File zzf(File file) throws IOException {
        return zze.zzq(this.zzt(), file.getName());
    }

    public final File zzg(String string) throws IOException {
        return zze.zzq(this.zzt(), zze.zzx(string));
    }

    private static File zzu(File object) throws IOException {
        if (!((File)object).exists()) {
            ((File)object).mkdirs();
            if (!((File)object).isDirectory()) {
                object = String.valueOf(((File)object).getAbsolutePath());
                throw new IOException("Unable to create directory: ".concat((String)object));
            }
        } else {
            if (((File)object).isDirectory()) {
                return object;
            }
            throw new IllegalArgumentException("File input must be directory when it exists.");
        }
        return object;
    }

    private final File zzv() throws IOException {
        if (this.zzc == null) {
            Context context = this.zzb;
            if (context == null) {
                throw new IllegalStateException("context must be non-null to populate null filesDir");
            }
            this.zzc = context.getFilesDir();
        }
        File file = new File(this.zzc, "splitcompat");
        zze.zzu(file);
        return file;
    }

    private final File zzw() throws IOException {
        File file = new File(this.zzv(), Long.toString(this.zza));
        zze.zzu(file);
        return file;
    }

    private static String zzx(String string) {
        return String.valueOf(string).concat(".apk");
    }

    final List zzh() throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        File[] fileArray = this.zzr().listFiles();
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                File file = fileArray[i];
                if (!file.isDirectory()) continue;
                arrayList.add(file.getName());
            }
        }
        return arrayList;
    }

    final Set zzi(String fileArray) throws IOException {
        HashSet<File> hashSet = new HashSet<File>();
        if ((fileArray = this.zzs((String)fileArray).listFiles()) != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                File file = fileArray[i];
                if (!file.isFile()) continue;
                hashSet.add(file);
            }
        }
        return hashSet;
    }

    final Set zzj() throws IOException {
        HashSet<zzb> hashSet = new HashSet<zzb>();
        File[] fileArray = this.zzt().listFiles();
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                File file = fileArray[i];
                if (!file.isFile() || !file.getName().endsWith(".apk") || !zze.zzp(file)) continue;
                String string = file.getName();
                String string2 = string.substring(0, string.length() + -4);
                hashSet.add(new zzb(file, string2));
            }
        }
        return hashSet;
    }

    public zze(Context context) throws PackageManager.NameNotFoundException {
        this.zzb = context;
        this.zza = context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).versionCode;
    }

    public final void zzk() throws IOException {
        File file = this.zzv();
        String[] stringArray = file.list();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                StringBuilder stringBuilder;
                String string = stringArray[i];
                if (string.equals(Long.toString(this.zza))) continue;
                File file2 = new File(file, string);
                string = ((Object)file2).toString();
                long l = this.zza;
                StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
                stringBuilder2.append("FileStorage: removing directory for different version code (directory = ");
                stringBuilder2.append(string);
                stringBuilder.append(", current version code = ");
                stringBuilder.append(l);
                stringBuilder.append(")");
                string = stringBuilder.toString();
                Log.d((String)"SplitCompat", (String)string);
                zze.zzl(file2);
            }
        }
    }

    public static void zzl(File file) throws IOException {
        File[] fileArray;
        if (file.isDirectory() && (fileArray = file.listFiles()) != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                zze.zzl(fileArray[i]);
            }
        }
        if (file.exists() && !file.delete()) {
            Object[] objectArray = new Object[]{file.getAbsolutePath()};
            throw new IOException(String.format("Failed to delete '%s'", objectArray));
        }
    }

    public static void zzm(File file) {
        file.setWritable(false, true);
        file.setWritable(false, false);
    }

    final void zzn(String string) throws IOException {
        zze.zzl(this.zzs(string));
    }

    final void zzo(File file) throws IOException {
        if (!file.getParentFile().getParentFile().equals(this.zzr())) {
            throw new IllegalStateException("File to remove is not a native library");
        }
        zze.zzl(file);
    }

    public static boolean zzp(File file) {
        return !file.canWrite();
    }
}

