/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.dependencies;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0006\u0010\u000f\u001a\u00020\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lcom/google/android/gms/dependencies/Artifact;", "", "groupId", "", "artifactId", "(Ljava/lang/String;Ljava/lang/String;)V", "getArtifactId", "()Ljava/lang/String;", "getGroupId", "component1", "component2", "copy", "equals", "", "other", "getGradleRef", "hashCode", "", "toString", "Companion", "strict-version-matcher-plugin"})
public final class Artifact {
    @NotNull
    private final String groupId;
    @NotNull
    private final String artifactId;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final String getGradleRef() {
        return this.groupId + ':' + this.artifactId;
    }

    @NotNull
    public final String getGroupId() {
        return this.groupId;
    }

    @NotNull
    public final String getArtifactId() {
        return this.artifactId;
    }

    public Artifact(@NotNull String groupId, @NotNull String artifactId) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
        this.groupId = groupId;
        this.artifactId = artifactId;
    }

    @NotNull
    public final String component1() {
        return this.groupId;
    }

    @NotNull
    public final String component2() {
        return this.artifactId;
    }

    @NotNull
    public final Artifact copy(@NotNull String groupId, @NotNull String artifactId) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
        return new Artifact(groupId, artifactId);
    }

    public static /* synthetic */ Artifact copy$default(Artifact artifact, String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string = artifact.groupId;
        }
        if ((n & 2) != 0) {
            string2 = artifact.artifactId;
        }
        return artifact.copy(string, string2);
    }

    @NotNull
    public String toString() {
        return "Artifact(groupId=" + this.groupId + ", artifactId=" + this.artifactId + ")";
    }

    public int hashCode() {
        String string = this.groupId;
        String string2 = this.artifactId;
        return (string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof Artifact)) break block3;
                Artifact artifact = (Artifact)object;
                if (!Intrinsics.areEqual((Object)this.groupId, (Object)artifact.groupId) || !Intrinsics.areEqual((Object)this.artifactId, (Object)artifact.artifactId)) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/google/android/gms/dependencies/Artifact$Companion;", "", "()V", "fromGradleRef", "Lcom/google/android/gms/dependencies/Artifact;", "referenceString", "", "strict-version-matcher-plugin"})
    public static final class Companion {
        @NotNull
        public final Artifact fromGradleRef(@NotNull String referenceString) {
            Intrinsics.checkNotNullParameter((Object)referenceString, (String)"referenceString");
            List stringSplit = StringsKt.split$default((CharSequence)referenceString, (String[])new String[]{":"}, (boolean)false, (int)0, (int)6, null);
            if (stringSplit.size() < 2) {
                throw (Throwable)new IllegalArgumentException("Invalid Gradle reference string: " + referenceString);
            }
            return new Artifact((String)stringSplit.get(0), (String)stringSplit.get(1));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

