/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet.fragment;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.RemoteException;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.FrameLayout;
import com.google.android.gms.R;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.dynamic.LifecycleDelegate;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.dynamic.zzf;
import com.google.android.gms.dynamic.zzh;
import com.google.android.gms.internal.zzaeb;
import com.google.android.gms.internal.zzaec;
import com.google.android.gms.internal.zzaej;
import com.google.android.gms.wallet.MaskedWallet;
import com.google.android.gms.wallet.MaskedWalletRequest;
import com.google.android.gms.wallet.fragment.WalletFragmentInitParams;
import com.google.android.gms.wallet.fragment.WalletFragmentOptions;
import com.google.android.gms.wallet.fragment.WalletFragmentStyle;

public final class SupportWalletFragment
extends Fragment {
    private zzb aHH;
    private boolean mCreated = false;
    private final zzh aHI = zzh.zza((Fragment)this);
    private final zzc aHJ = new zzc();
    private zza aHK = new zza(this);
    private final Fragment KF = this;
    private WalletFragmentOptions aHL;
    private WalletFragmentInitParams aHM;
    private MaskedWalletRequest aHN;
    private MaskedWallet aHO;
    private Boolean aHP;

    public static SupportWalletFragment newInstance(WalletFragmentOptions walletFragmentOptions) {
        SupportWalletFragment supportWalletFragment = new SupportWalletFragment();
        Bundle bundle = new Bundle();
        bundle.putParcelable("extraWalletFragmentOptions", (Parcelable)walletFragmentOptions);
        supportWalletFragment.KF.setArguments(bundle);
        return supportWalletFragment;
    }

    public void initialize(WalletFragmentInitParams walletFragmentInitParams) {
        if (this.aHH != null) {
            this.aHH.initialize(walletFragmentInitParams);
            this.aHM = null;
        } else if (this.aHM == null) {
            this.aHM = walletFragmentInitParams;
            if (this.aHN != null) {
                Log.w((String)"SupportWalletFragment", (String)"updateMaskedWalletRequest() was called before initialize()");
            }
            if (this.aHO != null) {
                Log.w((String)"SupportWalletFragment", (String)"updateMaskedWallet() was called before initialize()");
            }
        } else {
            Log.w((String)"SupportWalletFragment", (String)"initialize(WalletFragmentInitParams) was called more than once. Ignoring.");
        }
    }

    public void updateMaskedWalletRequest(MaskedWalletRequest maskedWalletRequest) {
        if (this.aHH != null) {
            this.aHH.updateMaskedWalletRequest(maskedWalletRequest);
            this.aHN = null;
        } else {
            this.aHN = maskedWalletRequest;
        }
    }

    public void updateMaskedWallet(MaskedWallet maskedWallet) {
        if (this.aHH != null) {
            this.aHH.updateMaskedWallet(maskedWallet);
            this.aHO = null;
        } else {
            this.aHO = maskedWallet;
        }
    }

    public void setEnabled(boolean bl) {
        if (this.aHH != null) {
            this.aHH.setEnabled(bl);
            this.aHP = null;
        } else {
            this.aHP = bl;
        }
    }

    public void setOnStateChangedListener(OnStateChangedListener onStateChangedListener) {
        this.aHK.zza(onStateChangedListener);
    }

    public int getState() {
        return this.aHH != null ? this.aHH.getState() : 0;
    }

    public void onInflate(Activity activity, AttributeSet attributeSet, Bundle bundle) {
        super.onInflate(activity, attributeSet, bundle);
        if (this.aHL == null) {
            this.aHL = WalletFragmentOptions.zzc((Context)activity, attributeSet);
        }
        Bundle bundle2 = new Bundle();
        bundle2.putParcelable("attrKeyWalletFragmentOptions", (Parcelable)this.aHL);
        this.aHJ.onInflate(activity, bundle2, bundle);
    }

    public void onCreate(Bundle bundle) {
        WalletFragmentOptions walletFragmentOptions;
        super.onCreate(bundle);
        if (bundle != null) {
            bundle.setClassLoader(WalletFragmentOptions.class.getClassLoader());
            WalletFragmentInitParams walletFragmentInitParams = (WalletFragmentInitParams)bundle.getParcelable("walletFragmentInitParams");
            if (walletFragmentInitParams != null) {
                if (this.aHM != null) {
                    Log.w((String)"SupportWalletFragment", (String)"initialize(WalletFragmentInitParams) was called more than once.Ignoring.");
                }
                this.aHM = walletFragmentInitParams;
            }
            if (this.aHN == null) {
                this.aHN = (MaskedWalletRequest)bundle.getParcelable("maskedWalletRequest");
            }
            if (this.aHO == null) {
                this.aHO = (MaskedWallet)bundle.getParcelable("maskedWallet");
            }
            if (bundle.containsKey("walletFragmentOptions")) {
                this.aHL = (WalletFragmentOptions)bundle.getParcelable("walletFragmentOptions");
            }
            if (bundle.containsKey("enabled")) {
                this.aHP = bundle.getBoolean("enabled");
            }
        } else if (this.KF.getArguments() != null && (walletFragmentOptions = (WalletFragmentOptions)this.KF.getArguments().getParcelable("extraWalletFragmentOptions")) != null) {
            walletFragmentOptions.zzei((Context)this.KF.getActivity());
            this.aHL = walletFragmentOptions;
        }
        this.mCreated = true;
        this.aHJ.onCreate(bundle);
    }

    public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        return this.aHJ.onCreateView(layoutInflater, viewGroup, bundle);
    }

    public void onStart() {
        super.onStart();
        this.aHJ.onStart();
    }

    public void onResume() {
        super.onResume();
        this.aHJ.onResume();
        FragmentManager fragmentManager = this.KF.getActivity().getSupportFragmentManager();
        Fragment fragment = fragmentManager.findFragmentByTag("GooglePlayServicesErrorDialog");
        if (fragment != null) {
            fragmentManager.beginTransaction().remove(fragment).commit();
            int n = GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)this.KF.getActivity());
            GooglePlayServicesUtil.showErrorDialogFragment((int)n, (Activity)this.KF.getActivity(), (int)-1);
        }
    }

    public void onPause() {
        super.onPause();
        this.aHJ.onPause();
    }

    public void onStop() {
        super.onStop();
        this.aHJ.onStop();
    }

    public void onSaveInstanceState(Bundle bundle) {
        super.onSaveInstanceState(bundle);
        bundle.setClassLoader(WalletFragmentOptions.class.getClassLoader());
        this.aHJ.onSaveInstanceState(bundle);
        if (this.aHM != null) {
            bundle.putParcelable("walletFragmentInitParams", (Parcelable)this.aHM);
            this.aHM = null;
        }
        if (this.aHN != null) {
            bundle.putParcelable("maskedWalletRequest", (Parcelable)this.aHN);
            this.aHN = null;
        }
        if (this.aHO != null) {
            bundle.putParcelable("maskedWallet", (Parcelable)this.aHO);
            this.aHO = null;
        }
        if (this.aHL != null) {
            bundle.putParcelable("walletFragmentOptions", (Parcelable)this.aHL);
            this.aHL = null;
        }
        if (this.aHP != null) {
            bundle.putBoolean("enabled", this.aHP.booleanValue());
            this.aHP = null;
        }
    }

    public void onDestroy() {
        super.onDestroy();
        this.mCreated = false;
    }

    public void onActivityResult(int n, int n2, Intent intent) {
        super.onActivityResult(n, n2, intent);
        if (this.aHH != null) {
            this.aHH.onActivityResult(n, n2, intent);
        }
    }

    public static interface OnStateChangedListener {
        public void onStateChanged(SupportWalletFragment var1, int var2, int var3, Bundle var4);
    }

    static class zza
    extends zzaec.zza {
        private OnStateChangedListener aHQ;
        private final SupportWalletFragment aHR;

        zza(SupportWalletFragment supportWalletFragment) {
            this.aHR = supportWalletFragment;
        }

        @Override
        public void zza(int n, int n2, Bundle bundle) {
            if (this.aHQ != null) {
                this.aHQ.onStateChanged(this.aHR, n, n2, bundle);
            }
        }

        public void zza(OnStateChangedListener onStateChangedListener) {
            this.aHQ = onStateChangedListener;
        }
    }

    private static class zzb
    implements LifecycleDelegate {
        private final zzaeb aHS;

        private zzb(zzaeb zzaeb2) {
            this.aHS = zzaeb2;
        }

        private void initialize(WalletFragmentInitParams walletFragmentInitParams) {
            try {
                this.aHS.initialize(walletFragmentInitParams);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private void setEnabled(boolean bl) {
            try {
                this.aHS.setEnabled(bl);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private void updateMaskedWalletRequest(MaskedWalletRequest maskedWalletRequest) {
            try {
                this.aHS.updateMaskedWalletRequest(maskedWalletRequest);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private void updateMaskedWallet(MaskedWallet maskedWallet) {
            try {
                this.aHS.updateMaskedWallet(maskedWallet);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private int getState() {
            try {
                return this.aHS.getState();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onInflate(Activity activity, Bundle bundle, Bundle bundle2) {
            WalletFragmentOptions walletFragmentOptions = (WalletFragmentOptions)bundle.getParcelable("extraWalletFragmentOptions");
            try {
                this.aHS.zza(zze.zzac((Object)activity), walletFragmentOptions, bundle2);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onCreate(Bundle bundle) {
            try {
                this.aHS.onCreate(bundle);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
            try {
                zzd zzd2 = this.aHS.onCreateView(zze.zzac((Object)layoutInflater), zze.zzac((Object)viewGroup), bundle);
                return (View)zze.zzad((zzd)zzd2);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onStart() {
            try {
                this.aHS.onStart();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onResume() {
            try {
                this.aHS.onResume();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onPause() {
            try {
                this.aHS.onPause();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onStop() {
            try {
                this.aHS.onStop();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onDestroyView() {
        }

        public void onDestroy() {
        }

        public void onLowMemory() {
        }

        public void onSaveInstanceState(Bundle bundle) {
            try {
                this.aHS.onSaveInstanceState(bundle);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private void onActivityResult(int n, int n2, Intent intent) {
            try {
                this.aHS.onActivityResult(n, n2, intent);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }
    }

    private class zzc
    extends com.google.android.gms.dynamic.zza<zzb>
    implements View.OnClickListener {
        private zzc() {
        }

        protected void zza(zzf<zzb> zzf2) {
            FragmentActivity fragmentActivity = SupportWalletFragment.this.KF.getActivity();
            if (SupportWalletFragment.this.aHH == null && SupportWalletFragment.this.mCreated && fragmentActivity != null) {
                try {
                    zzaeb zzaeb2 = zzaej.zza((Activity)fragmentActivity, (com.google.android.gms.dynamic.zzc)SupportWalletFragment.this.aHI, SupportWalletFragment.this.aHL, SupportWalletFragment.this.aHK);
                    SupportWalletFragment.this.aHH = new zzb(zzaeb2);
                    SupportWalletFragment.this.aHL = null;
                }
                catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {
                    return;
                }
                zzf2.zza((LifecycleDelegate)SupportWalletFragment.this.aHH);
                if (SupportWalletFragment.this.aHM != null) {
                    SupportWalletFragment.this.aHH.initialize(SupportWalletFragment.this.aHM);
                    SupportWalletFragment.this.aHM = null;
                }
                if (SupportWalletFragment.this.aHN != null) {
                    SupportWalletFragment.this.aHH.updateMaskedWalletRequest(SupportWalletFragment.this.aHN);
                    SupportWalletFragment.this.aHN = null;
                }
                if (SupportWalletFragment.this.aHO != null) {
                    SupportWalletFragment.this.aHH.updateMaskedWallet(SupportWalletFragment.this.aHO);
                    SupportWalletFragment.this.aHO = null;
                }
                if (SupportWalletFragment.this.aHP != null) {
                    SupportWalletFragment.this.aHH.setEnabled(SupportWalletFragment.this.aHP);
                    SupportWalletFragment.this.aHP = null;
                }
            }
        }

        protected void zza(FrameLayout frameLayout) {
            WalletFragmentStyle walletFragmentStyle;
            Button button = new Button((Context)SupportWalletFragment.this.KF.getActivity());
            button.setText(R.string.wallet_buy_button_place_holder);
            int n = -1;
            int n2 = -2;
            if (SupportWalletFragment.this.aHL != null && (walletFragmentStyle = SupportWalletFragment.this.aHL.getFragmentStyle()) != null) {
                DisplayMetrics displayMetrics = SupportWalletFragment.this.KF.getResources().getDisplayMetrics();
                n = walletFragmentStyle.zza("buyButtonWidth", displayMetrics, -1);
                n2 = walletFragmentStyle.zza("buyButtonHeight", displayMetrics, -2);
            }
            button.setLayoutParams(new ViewGroup.LayoutParams(n, n2));
            button.setOnClickListener((View.OnClickListener)this);
            frameLayout.addView((View)button);
        }

        public void onClick(View view) {
            FragmentActivity fragmentActivity = SupportWalletFragment.this.KF.getActivity();
            int n = GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)fragmentActivity);
            GooglePlayServicesUtil.showErrorDialogFragment((int)n, (Activity)fragmentActivity, (int)-1);
        }
    }
}

