/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.wallet.Cart;
import com.google.android.gms.wallet.CountrySpecification;
import com.google.android.gms.wallet.PaymentMethodTokenizationParameters;
import com.google.android.gms.wallet.zzm;
import java.util.ArrayList;
import java.util.Collection;

public final class MaskedWalletRequest
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<MaskedWalletRequest> CREATOR = new zzm();
    private final int mVersionCode;
    String aFQ;
    boolean aGO;
    boolean aGP;
    boolean aGQ;
    String aGR;
    String aFJ;
    String aGS;
    Cart aGa;
    boolean aGT;
    boolean aGU;
    CountrySpecification[] aGV;
    boolean aGW;
    boolean aGX;
    ArrayList<com.google.android.gms.identity.intents.model.CountrySpecification> aGY;
    PaymentMethodTokenizationParameters aGZ;
    ArrayList<Integer> aHa;

    public static Builder newBuilder() {
        MaskedWalletRequest maskedWalletRequest = new MaskedWalletRequest();
        ((Object)((Object)maskedWalletRequest)).getClass();
        return maskedWalletRequest.new Builder();
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzm.zza(this, parcel, n);
    }

    MaskedWalletRequest(int n, String string, boolean bl, boolean bl2, boolean bl3, String string2, String string3, String string4, Cart cart, boolean bl4, boolean bl5, CountrySpecification[] countrySpecificationArray, boolean bl6, boolean bl7, ArrayList<com.google.android.gms.identity.intents.model.CountrySpecification> arrayList, PaymentMethodTokenizationParameters paymentMethodTokenizationParameters, ArrayList<Integer> arrayList2) {
        this.mVersionCode = n;
        this.aFQ = string;
        this.aGO = bl;
        this.aGP = bl2;
        this.aGQ = bl3;
        this.aGR = string2;
        this.aFJ = string3;
        this.aGS = string4;
        this.aGa = cart;
        this.aGT = bl4;
        this.aGU = bl5;
        this.aGV = countrySpecificationArray;
        this.aGW = bl6;
        this.aGX = bl7;
        this.aGY = arrayList;
        this.aGZ = paymentMethodTokenizationParameters;
        this.aHa = arrayList2;
    }

    MaskedWalletRequest() {
        this.mVersionCode = 3;
        this.aGW = true;
        this.aGX = true;
    }

    public String getMerchantTransactionId() {
        return this.aFQ;
    }

    public boolean isPhoneNumberRequired() {
        return this.aGO;
    }

    public boolean isShippingAddressRequired() {
        return this.aGP;
    }

    @Deprecated
    public boolean useMinimalBillingAddress() {
        return this.aGQ;
    }

    public String getEstimatedTotalPrice() {
        return this.aGR;
    }

    public String getCurrencyCode() {
        return this.aFJ;
    }

    public String getMerchantName() {
        return this.aGS;
    }

    public Cart getCart() {
        return this.aGa;
    }

    @Deprecated
    public boolean isBillingAgreement() {
        return this.aGU;
    }

    public CountrySpecification[] getAllowedShippingCountrySpecifications() {
        return this.aGV;
    }

    public boolean allowPrepaidCard() {
        return this.aGW;
    }

    public boolean allowDebitCard() {
        return this.aGX;
    }

    public ArrayList<com.google.android.gms.identity.intents.model.CountrySpecification> getAllowedCountrySpecificationsForShipping() {
        return this.aGY;
    }

    public PaymentMethodTokenizationParameters getPaymentMethodTokenizationParameters() {
        return this.aGZ;
    }

    public ArrayList<Integer> getAllowedCardNetworks() {
        return this.aHa;
    }

    public final class Builder {
        private Builder() {
        }

        public Builder setMerchantTransactionId(String string) {
            MaskedWalletRequest.this.aFQ = string;
            return this;
        }

        public Builder setPhoneNumberRequired(boolean bl) {
            MaskedWalletRequest.this.aGO = bl;
            return this;
        }

        public Builder setShippingAddressRequired(boolean bl) {
            MaskedWalletRequest.this.aGP = bl;
            return this;
        }

        @Deprecated
        public Builder setUseMinimalBillingAddress(boolean bl) {
            MaskedWalletRequest.this.aGQ = bl;
            return this;
        }

        public Builder setEstimatedTotalPrice(String string) {
            MaskedWalletRequest.this.aGR = string;
            return this;
        }

        public Builder setCurrencyCode(String string) {
            MaskedWalletRequest.this.aFJ = string;
            return this;
        }

        public Builder setMerchantName(String string) {
            MaskedWalletRequest.this.aGS = string;
            return this;
        }

        public Builder setCart(Cart cart) {
            MaskedWalletRequest.this.aGa = cart;
            return this;
        }

        @Deprecated
        public Builder setIsBillingAgreement(boolean bl) {
            MaskedWalletRequest.this.aGU = bl;
            return this;
        }

        public Builder setAllowPrepaidCard(boolean bl) {
            MaskedWalletRequest.this.aGW = bl;
            return this;
        }

        public Builder setAllowDebitCard(boolean bl) {
            MaskedWalletRequest.this.aGX = bl;
            return this;
        }

        public Builder addAllowedCountrySpecificationForShipping(com.google.android.gms.identity.intents.model.CountrySpecification countrySpecification) {
            if (MaskedWalletRequest.this.aGY == null) {
                MaskedWalletRequest.this.aGY = new ArrayList();
            }
            MaskedWalletRequest.this.aGY.add(countrySpecification);
            return this;
        }

        public Builder addAllowedCountrySpecificationsForShipping(Collection<com.google.android.gms.identity.intents.model.CountrySpecification> collection) {
            if (collection != null) {
                if (MaskedWalletRequest.this.aGY == null) {
                    MaskedWalletRequest.this.aGY = new ArrayList();
                }
                MaskedWalletRequest.this.aGY.addAll(collection);
            }
            return this;
        }

        public Builder setPaymentMethodTokenizationParameters(PaymentMethodTokenizationParameters paymentMethodTokenizationParameters) {
            MaskedWalletRequest.this.aGZ = paymentMethodTokenizationParameters;
            return this;
        }

        public Builder addAllowedCardNetwork(int n) {
            if (MaskedWalletRequest.this.aHa == null) {
                MaskedWalletRequest.this.aHa = new ArrayList();
            }
            MaskedWalletRequest.this.aHa.add(n);
            return this;
        }

        public Builder addAllowedCardNetworks(Collection<Integer> collection) {
            if (collection != null) {
                if (MaskedWalletRequest.this.aHa == null) {
                    MaskedWalletRequest.this.aHa = new ArrayList();
                }
                MaskedWalletRequest.this.aHa.addAll(collection);
            }
            return this;
        }

        public MaskedWalletRequest build() {
            return MaskedWalletRequest.this;
        }
    }
}

