/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet.fragment;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Fragment;
import android.app.FragmentManager;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.RemoteException;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.FrameLayout;
import com.google.android.gms.R;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.dynamic.LifecycleDelegate;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.dynamic.zzf;
import com.google.android.gms.internal.zzaee;
import com.google.android.gms.internal.zzaef;
import com.google.android.gms.internal.zzaem;
import com.google.android.gms.wallet.MaskedWallet;
import com.google.android.gms.wallet.MaskedWalletRequest;
import com.google.android.gms.wallet.fragment.WalletFragmentInitParams;
import com.google.android.gms.wallet.fragment.WalletFragmentOptions;
import com.google.android.gms.wallet.fragment.WalletFragmentStyle;

@TargetApi(value=12)
public final class WalletFragment
extends Fragment {
    private zzb aIj;
    private boolean mCreated = false;
    private final com.google.android.gms.dynamic.zzb aIk = com.google.android.gms.dynamic.zzb.zza((Fragment)this);
    private final zzc aIl = new zzc();
    private zza aIm = new zza(this);
    private final Fragment Ma = this;
    private WalletFragmentOptions aIa;
    private WalletFragmentInitParams aIb;
    private MaskedWalletRequest aIc;
    private MaskedWallet aId;
    private Boolean aIe;

    public static WalletFragment newInstance(WalletFragmentOptions walletFragmentOptions) {
        WalletFragment walletFragment = new WalletFragment();
        Bundle bundle = new Bundle();
        bundle.putParcelable("extraWalletFragmentOptions", (Parcelable)walletFragmentOptions);
        walletFragment.Ma.setArguments(bundle);
        return walletFragment;
    }

    public void initialize(WalletFragmentInitParams walletFragmentInitParams) {
        if (this.aIj != null) {
            this.aIj.initialize(walletFragmentInitParams);
            this.aIb = null;
        } else if (this.aIb == null) {
            this.aIb = walletFragmentInitParams;
            if (this.aIc != null) {
                Log.w((String)"WalletFragment", (String)"updateMaskedWalletRequest() was called before initialize()");
            }
            if (this.aId != null) {
                Log.w((String)"WalletFragment", (String)"updateMaskedWallet() was called before initialize()");
            }
        } else {
            Log.w((String)"WalletFragment", (String)"initialize(WalletFragmentInitParams) was called more than once. Ignoring.");
        }
    }

    public void updateMaskedWalletRequest(MaskedWalletRequest maskedWalletRequest) {
        if (this.aIj != null) {
            this.aIj.updateMaskedWalletRequest(maskedWalletRequest);
            this.aIc = null;
        } else {
            this.aIc = maskedWalletRequest;
        }
    }

    public void updateMaskedWallet(MaskedWallet maskedWallet) {
        if (this.aIj != null) {
            this.aIj.updateMaskedWallet(maskedWallet);
            this.aId = null;
        } else {
            this.aId = maskedWallet;
        }
    }

    public void setEnabled(boolean bl) {
        if (this.aIj != null) {
            this.aIj.setEnabled(bl);
            this.aIe = null;
        } else {
            this.aIe = bl;
        }
    }

    public void setOnStateChangedListener(OnStateChangedListener onStateChangedListener) {
        this.aIm.zza(onStateChangedListener);
    }

    public int getState() {
        return this.aIj != null ? this.aIj.getState() : 0;
    }

    public void onInflate(Activity activity, AttributeSet attributeSet, Bundle bundle) {
        super.onInflate(activity, attributeSet, bundle);
        if (this.aIa == null) {
            this.aIa = WalletFragmentOptions.zzb((Context)activity, attributeSet);
        }
        Bundle bundle2 = new Bundle();
        bundle2.putParcelable("attrKeyWalletFragmentOptions", (Parcelable)this.aIa);
        this.aIl.onInflate(activity, bundle2, bundle);
    }

    public void onCreate(Bundle bundle) {
        WalletFragmentOptions walletFragmentOptions;
        super.onCreate(bundle);
        if (bundle != null) {
            bundle.setClassLoader(WalletFragmentOptions.class.getClassLoader());
            WalletFragmentInitParams walletFragmentInitParams = (WalletFragmentInitParams)bundle.getParcelable("walletFragmentInitParams");
            if (walletFragmentInitParams != null) {
                if (this.aIb != null) {
                    Log.w((String)"WalletFragment", (String)"initialize(WalletFragmentInitParams) was called more than once.Ignoring.");
                }
                this.aIb = walletFragmentInitParams;
            }
            if (this.aIc == null) {
                this.aIc = (MaskedWalletRequest)bundle.getParcelable("maskedWalletRequest");
            }
            if (this.aId == null) {
                this.aId = (MaskedWallet)bundle.getParcelable("maskedWallet");
            }
            if (bundle.containsKey("walletFragmentOptions")) {
                this.aIa = (WalletFragmentOptions)bundle.getParcelable("walletFragmentOptions");
            }
            if (bundle.containsKey("enabled")) {
                this.aIe = bundle.getBoolean("enabled");
            }
        } else if (this.Ma.getArguments() != null && (walletFragmentOptions = (WalletFragmentOptions)this.Ma.getArguments().getParcelable("extraWalletFragmentOptions")) != null) {
            walletFragmentOptions.zzef((Context)this.Ma.getActivity());
            this.aIa = walletFragmentOptions;
        }
        this.mCreated = true;
        this.aIl.onCreate(bundle);
    }

    public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        return this.aIl.onCreateView(layoutInflater, viewGroup, bundle);
    }

    public void onStart() {
        super.onStart();
        this.aIl.onStart();
    }

    public void onResume() {
        super.onResume();
        this.aIl.onResume();
        FragmentManager fragmentManager = this.Ma.getActivity().getFragmentManager();
        Fragment fragment = fragmentManager.findFragmentByTag("GooglePlayServicesErrorDialog");
        if (fragment != null) {
            fragmentManager.beginTransaction().remove(fragment).commit();
            int n = GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)this.Ma.getActivity());
            GooglePlayServicesUtil.showErrorDialogFragment((int)n, (Activity)this.Ma.getActivity(), (int)-1);
        }
    }

    public void onPause() {
        super.onPause();
        this.aIl.onPause();
    }

    public void onStop() {
        super.onStop();
        this.aIl.onStop();
    }

    public void onSaveInstanceState(Bundle bundle) {
        super.onSaveInstanceState(bundle);
        bundle.setClassLoader(WalletFragmentOptions.class.getClassLoader());
        this.aIl.onSaveInstanceState(bundle);
        if (this.aIb != null) {
            bundle.putParcelable("walletFragmentInitParams", (Parcelable)this.aIb);
            this.aIb = null;
        }
        if (this.aIc != null) {
            bundle.putParcelable("maskedWalletRequest", (Parcelable)this.aIc);
            this.aIc = null;
        }
        if (this.aId != null) {
            bundle.putParcelable("maskedWallet", (Parcelable)this.aId);
            this.aId = null;
        }
        if (this.aIa != null) {
            bundle.putParcelable("walletFragmentOptions", (Parcelable)this.aIa);
            this.aIa = null;
        }
        if (this.aIe != null) {
            bundle.putBoolean("enabled", this.aIe.booleanValue());
            this.aIe = null;
        }
    }

    public void onDestroy() {
        super.onDestroy();
        this.mCreated = false;
    }

    public void onActivityResult(int n, int n2, Intent intent) {
        super.onActivityResult(n, n2, intent);
        if (this.aIj != null) {
            this.aIj.onActivityResult(n, n2, intent);
        }
    }

    public static interface OnStateChangedListener {
        public void onStateChanged(WalletFragment var1, int var2, int var3, Bundle var4);
    }

    static class zza
    extends zzaef.zza {
        private OnStateChangedListener aIn;
        private final WalletFragment aIo;

        zza(WalletFragment walletFragment) {
            this.aIo = walletFragment;
        }

        @Override
        public void zza(int n, int n2, Bundle bundle) {
            if (this.aIn != null) {
                this.aIn.onStateChanged(this.aIo, n, n2, bundle);
            }
        }

        public void zza(OnStateChangedListener onStateChangedListener) {
            this.aIn = onStateChangedListener;
        }
    }

    private static class zzb
    implements LifecycleDelegate {
        private final zzaee aIh;

        private zzb(zzaee zzaee2) {
            this.aIh = zzaee2;
        }

        private void initialize(WalletFragmentInitParams walletFragmentInitParams) {
            try {
                this.aIh.initialize(walletFragmentInitParams);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private void setEnabled(boolean bl) {
            try {
                this.aIh.setEnabled(bl);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private void updateMaskedWalletRequest(MaskedWalletRequest maskedWalletRequest) {
            try {
                this.aIh.updateMaskedWalletRequest(maskedWalletRequest);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private void updateMaskedWallet(MaskedWallet maskedWallet) {
            try {
                this.aIh.updateMaskedWallet(maskedWallet);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private int getState() {
            try {
                return this.aIh.getState();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onInflate(Activity activity, Bundle bundle, Bundle bundle2) {
            WalletFragmentOptions walletFragmentOptions = (WalletFragmentOptions)bundle.getParcelable("extraWalletFragmentOptions");
            try {
                this.aIh.zza(zze.zzae((Object)activity), walletFragmentOptions, bundle2);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onCreate(Bundle bundle) {
            try {
                this.aIh.onCreate(bundle);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
            try {
                zzd zzd2 = this.aIh.onCreateView(zze.zzae((Object)layoutInflater), zze.zzae((Object)viewGroup), bundle);
                return (View)zze.zzad((zzd)zzd2);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onStart() {
            try {
                this.aIh.onStart();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onResume() {
            try {
                this.aIh.onResume();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onPause() {
            try {
                this.aIh.onPause();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onStop() {
            try {
                this.aIh.onStop();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onDestroyView() {
        }

        public void onDestroy() {
        }

        public void onLowMemory() {
        }

        public void onSaveInstanceState(Bundle bundle) {
            try {
                this.aIh.onSaveInstanceState(bundle);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private void onActivityResult(int n, int n2, Intent intent) {
            try {
                this.aIh.onActivityResult(n, n2, intent);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }
    }

    private class zzc
    extends com.google.android.gms.dynamic.zza<zzb>
    implements View.OnClickListener {
        private zzc() {
        }

        protected void zza(zzf<zzb> zzf2) {
            Activity activity = WalletFragment.this.Ma.getActivity();
            if (WalletFragment.this.aIj == null && WalletFragment.this.mCreated && activity != null) {
                try {
                    zzaee zzaee2 = zzaem.zza(activity, (com.google.android.gms.dynamic.zzc)WalletFragment.this.aIk, WalletFragment.this.aIa, WalletFragment.this.aIm);
                    WalletFragment.this.aIj = new zzb(zzaee2);
                    WalletFragment.this.aIa = null;
                }
                catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {
                    return;
                }
                zzf2.zza((LifecycleDelegate)WalletFragment.this.aIj);
                if (WalletFragment.this.aIb != null) {
                    WalletFragment.this.aIj.initialize(WalletFragment.this.aIb);
                    WalletFragment.this.aIb = null;
                }
                if (WalletFragment.this.aIc != null) {
                    WalletFragment.this.aIj.updateMaskedWalletRequest(WalletFragment.this.aIc);
                    WalletFragment.this.aIc = null;
                }
                if (WalletFragment.this.aId != null) {
                    WalletFragment.this.aIj.updateMaskedWallet(WalletFragment.this.aId);
                    WalletFragment.this.aId = null;
                }
                if (WalletFragment.this.aIe != null) {
                    WalletFragment.this.aIj.setEnabled(WalletFragment.this.aIe);
                    WalletFragment.this.aIe = null;
                }
            }
        }

        protected void zza(FrameLayout frameLayout) {
            WalletFragmentStyle walletFragmentStyle;
            Button button = new Button((Context)WalletFragment.this.Ma.getActivity());
            button.setText(R.string.wallet_buy_button_place_holder);
            int n = -1;
            int n2 = -2;
            if (WalletFragment.this.aIa != null && (walletFragmentStyle = WalletFragment.this.aIa.getFragmentStyle()) != null) {
                DisplayMetrics displayMetrics = WalletFragment.this.Ma.getResources().getDisplayMetrics();
                n = walletFragmentStyle.zza("buyButtonWidth", displayMetrics, -1);
                n2 = walletFragmentStyle.zza("buyButtonHeight", displayMetrics, -2);
            }
            button.setLayoutParams(new ViewGroup.LayoutParams(n, n2));
            button.setOnClickListener((View.OnClickListener)this);
            frameLayout.addView((View)button);
        }

        public void onClick(View view) {
            Activity activity = WalletFragment.this.Ma.getActivity();
            int n = GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)activity);
            GooglePlayServicesUtil.showErrorDialogFragment((int)n, (Activity)activity, (int)-1);
        }
    }
}

