/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet.fragment;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.RemoteException;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.FrameLayout;
import com.google.android.gms.R;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.dynamic.LifecycleDelegate;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.dynamic.zzf;
import com.google.android.gms.dynamic.zzh;
import com.google.android.gms.internal.zzaby;
import com.google.android.gms.internal.zzabz;
import com.google.android.gms.internal.zzacg;
import com.google.android.gms.wallet.MaskedWallet;
import com.google.android.gms.wallet.MaskedWalletRequest;
import com.google.android.gms.wallet.fragment.WalletFragmentInitParams;
import com.google.android.gms.wallet.fragment.WalletFragmentOptions;
import com.google.android.gms.wallet.fragment.WalletFragmentStyle;

public final class SupportWalletFragment
extends Fragment {
    private zzb zzbAB;
    private boolean mCreated = false;
    private final zzh zzbAC = zzh.zza((Fragment)this);
    private final zzc zzbAD = new zzc();
    private zza zzbAE = new zza(this);
    private final Fragment zzaCl = this;
    private WalletFragmentOptions zzbAF;
    private WalletFragmentInitParams zzbAG;
    private MaskedWalletRequest zzbAH;
    private MaskedWallet zzbAI;
    private Boolean zzbAJ;

    public static SupportWalletFragment newInstance(WalletFragmentOptions walletFragmentOptions) {
        SupportWalletFragment supportWalletFragment = new SupportWalletFragment();
        Bundle bundle = new Bundle();
        bundle.putParcelable("extraWalletFragmentOptions", (Parcelable)walletFragmentOptions);
        supportWalletFragment.zzaCl.setArguments(bundle);
        return supportWalletFragment;
    }

    public void initialize(WalletFragmentInitParams walletFragmentInitParams) {
        if (this.zzbAB != null) {
            this.zzbAB.initialize(walletFragmentInitParams);
            this.zzbAG = null;
        } else if (this.zzbAG == null) {
            this.zzbAG = walletFragmentInitParams;
            if (this.zzbAH != null) {
                Log.w((String)"SupportWalletFragment", (String)"updateMaskedWalletRequest() was called before initialize()");
            }
            if (this.zzbAI != null) {
                Log.w((String)"SupportWalletFragment", (String)"updateMaskedWallet() was called before initialize()");
            }
        } else {
            Log.w((String)"SupportWalletFragment", (String)"initialize(WalletFragmentInitParams) was called more than once. Ignoring.");
        }
    }

    public void updateMaskedWalletRequest(MaskedWalletRequest maskedWalletRequest) {
        if (this.zzbAB != null) {
            this.zzbAB.updateMaskedWalletRequest(maskedWalletRequest);
            this.zzbAH = null;
        } else {
            this.zzbAH = maskedWalletRequest;
        }
    }

    public void updateMaskedWallet(MaskedWallet maskedWallet) {
        if (this.zzbAB != null) {
            this.zzbAB.updateMaskedWallet(maskedWallet);
            this.zzbAI = null;
        } else {
            this.zzbAI = maskedWallet;
        }
    }

    public void setEnabled(boolean bl) {
        if (this.zzbAB != null) {
            this.zzbAB.setEnabled(bl);
            this.zzbAJ = null;
        } else {
            this.zzbAJ = bl;
        }
    }

    public void setOnStateChangedListener(OnStateChangedListener onStateChangedListener) {
        this.zzbAE.zza(onStateChangedListener);
    }

    public int getState() {
        return this.zzbAB != null ? this.zzbAB.getState() : 0;
    }

    public void onInflate(Activity activity, AttributeSet attributeSet, Bundle bundle) {
        super.onInflate(activity, attributeSet, bundle);
        if (this.zzbAF == null) {
            this.zzbAF = WalletFragmentOptions.zzb((Context)activity, attributeSet);
        }
        Bundle bundle2 = new Bundle();
        bundle2.putParcelable("attrKeyWalletFragmentOptions", (Parcelable)this.zzbAF);
        this.zzbAD.onInflate(activity, bundle2, bundle);
    }

    public void onCreate(Bundle bundle) {
        WalletFragmentOptions walletFragmentOptions;
        super.onCreate(bundle);
        if (bundle != null) {
            bundle.setClassLoader(WalletFragmentOptions.class.getClassLoader());
            WalletFragmentInitParams walletFragmentInitParams = (WalletFragmentInitParams)bundle.getParcelable("walletFragmentInitParams");
            if (walletFragmentInitParams != null) {
                if (this.zzbAG != null) {
                    Log.w((String)"SupportWalletFragment", (String)"initialize(WalletFragmentInitParams) was called more than once.Ignoring.");
                }
                this.zzbAG = walletFragmentInitParams;
            }
            if (this.zzbAH == null) {
                this.zzbAH = (MaskedWalletRequest)bundle.getParcelable("maskedWalletRequest");
            }
            if (this.zzbAI == null) {
                this.zzbAI = (MaskedWallet)bundle.getParcelable("maskedWallet");
            }
            if (bundle.containsKey("walletFragmentOptions")) {
                this.zzbAF = (WalletFragmentOptions)bundle.getParcelable("walletFragmentOptions");
            }
            if (bundle.containsKey("enabled")) {
                this.zzbAJ = bundle.getBoolean("enabled");
            }
        } else if (this.zzaCl.getArguments() != null && (walletFragmentOptions = (WalletFragmentOptions)this.zzaCl.getArguments().getParcelable("extraWalletFragmentOptions")) != null) {
            walletFragmentOptions.zzbt((Context)this.zzaCl.getActivity());
            this.zzbAF = walletFragmentOptions;
        }
        this.mCreated = true;
        this.zzbAD.onCreate(bundle);
    }

    public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        return this.zzbAD.onCreateView(layoutInflater, viewGroup, bundle);
    }

    public void onStart() {
        super.onStart();
        this.zzbAD.onStart();
    }

    public void onResume() {
        super.onResume();
        this.zzbAD.onResume();
        FragmentManager fragmentManager = this.zzaCl.getActivity().getSupportFragmentManager();
        Fragment fragment = fragmentManager.findFragmentByTag("GooglePlayServicesErrorDialog");
        if (fragment != null) {
            fragmentManager.beginTransaction().remove(fragment).commit();
            int n = GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)this.zzaCl.getActivity());
            GooglePlayServicesUtil.showErrorDialogFragment((int)n, (Activity)this.zzaCl.getActivity(), (int)-1);
        }
    }

    public void onPause() {
        super.onPause();
        this.zzbAD.onPause();
    }

    public void onStop() {
        super.onStop();
        this.zzbAD.onStop();
    }

    public void onSaveInstanceState(Bundle bundle) {
        super.onSaveInstanceState(bundle);
        bundle.setClassLoader(WalletFragmentOptions.class.getClassLoader());
        this.zzbAD.onSaveInstanceState(bundle);
        if (this.zzbAG != null) {
            bundle.putParcelable("walletFragmentInitParams", (Parcelable)this.zzbAG);
            this.zzbAG = null;
        }
        if (this.zzbAH != null) {
            bundle.putParcelable("maskedWalletRequest", (Parcelable)this.zzbAH);
            this.zzbAH = null;
        }
        if (this.zzbAI != null) {
            bundle.putParcelable("maskedWallet", (Parcelable)this.zzbAI);
            this.zzbAI = null;
        }
        if (this.zzbAF != null) {
            bundle.putParcelable("walletFragmentOptions", (Parcelable)this.zzbAF);
            this.zzbAF = null;
        }
        if (this.zzbAJ != null) {
            bundle.putBoolean("enabled", this.zzbAJ.booleanValue());
            this.zzbAJ = null;
        }
    }

    public void onDestroy() {
        super.onDestroy();
        this.mCreated = false;
    }

    public void onActivityResult(int n, int n2, Intent intent) {
        super.onActivityResult(n, n2, intent);
        if (this.zzbAB != null) {
            this.zzbAB.onActivityResult(n, n2, intent);
        }
    }

    public static interface OnStateChangedListener {
        public void onStateChanged(SupportWalletFragment var1, int var2, int var3, Bundle var4);
    }

    static class zza
    extends zzabz.zza {
        private OnStateChangedListener zzbAK;
        private final SupportWalletFragment zzbAL;

        zza(SupportWalletFragment supportWalletFragment) {
            this.zzbAL = supportWalletFragment;
        }

        @Override
        public void zza(int n, int n2, Bundle bundle) {
            if (this.zzbAK != null) {
                this.zzbAK.onStateChanged(this.zzbAL, n, n2, bundle);
            }
        }

        public void zza(OnStateChangedListener onStateChangedListener) {
            this.zzbAK = onStateChangedListener;
        }
    }

    private static class zzb
    implements LifecycleDelegate {
        private final zzaby zzbAM;

        private zzb(zzaby zzaby2) {
            this.zzbAM = zzaby2;
        }

        private void initialize(WalletFragmentInitParams walletFragmentInitParams) {
            try {
                this.zzbAM.initialize(walletFragmentInitParams);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private void setEnabled(boolean bl) {
            try {
                this.zzbAM.setEnabled(bl);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private void updateMaskedWalletRequest(MaskedWalletRequest maskedWalletRequest) {
            try {
                this.zzbAM.updateMaskedWalletRequest(maskedWalletRequest);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private void updateMaskedWallet(MaskedWallet maskedWallet) {
            try {
                this.zzbAM.updateMaskedWallet(maskedWallet);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private int getState() {
            try {
                return this.zzbAM.getState();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onInflate(Activity activity, Bundle bundle, Bundle bundle2) {
            WalletFragmentOptions walletFragmentOptions = (WalletFragmentOptions)bundle.getParcelable("extraWalletFragmentOptions");
            try {
                this.zzbAM.zza(zze.zzD((Object)activity), walletFragmentOptions, bundle2);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onCreate(Bundle bundle) {
            try {
                this.zzbAM.onCreate(bundle);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
            try {
                zzd zzd2 = this.zzbAM.onCreateView(zze.zzD((Object)layoutInflater), zze.zzD((Object)viewGroup), bundle);
                return (View)zze.zzx((zzd)zzd2);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onStart() {
            try {
                this.zzbAM.onStart();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onResume() {
            try {
                this.zzbAM.onResume();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onPause() {
            try {
                this.zzbAM.onPause();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onStop() {
            try {
                this.zzbAM.onStop();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onDestroyView() {
        }

        public void onDestroy() {
        }

        public void onLowMemory() {
        }

        public void onSaveInstanceState(Bundle bundle) {
            try {
                this.zzbAM.onSaveInstanceState(bundle);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private void onActivityResult(int n, int n2, Intent intent) {
            try {
                this.zzbAM.onActivityResult(n, n2, intent);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }
    }

    private class zzc
    extends com.google.android.gms.dynamic.zza<zzb>
    implements View.OnClickListener {
        private zzc() {
        }

        protected void zza(zzf<zzb> zzf2) {
            FragmentActivity fragmentActivity = SupportWalletFragment.this.zzaCl.getActivity();
            if (SupportWalletFragment.this.zzbAB == null && SupportWalletFragment.this.mCreated && fragmentActivity != null) {
                try {
                    zzaby zzaby2 = zzacg.zza((Activity)fragmentActivity, (com.google.android.gms.dynamic.zzc)SupportWalletFragment.this.zzbAC, SupportWalletFragment.this.zzbAF, SupportWalletFragment.this.zzbAE);
                    SupportWalletFragment.this.zzbAB = new zzb(zzaby2);
                    SupportWalletFragment.this.zzbAF = null;
                }
                catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {
                    return;
                }
                zzf2.zza((LifecycleDelegate)SupportWalletFragment.this.zzbAB);
                if (SupportWalletFragment.this.zzbAG != null) {
                    SupportWalletFragment.this.zzbAB.initialize(SupportWalletFragment.this.zzbAG);
                    SupportWalletFragment.this.zzbAG = null;
                }
                if (SupportWalletFragment.this.zzbAH != null) {
                    SupportWalletFragment.this.zzbAB.updateMaskedWalletRequest(SupportWalletFragment.this.zzbAH);
                    SupportWalletFragment.this.zzbAH = null;
                }
                if (SupportWalletFragment.this.zzbAI != null) {
                    SupportWalletFragment.this.zzbAB.updateMaskedWallet(SupportWalletFragment.this.zzbAI);
                    SupportWalletFragment.this.zzbAI = null;
                }
                if (SupportWalletFragment.this.zzbAJ != null) {
                    SupportWalletFragment.this.zzbAB.setEnabled(SupportWalletFragment.this.zzbAJ);
                    SupportWalletFragment.this.zzbAJ = null;
                }
            }
        }

        protected void zza(FrameLayout frameLayout) {
            WalletFragmentStyle walletFragmentStyle;
            Button button = new Button((Context)SupportWalletFragment.this.zzaCl.getActivity());
            button.setText(R.string.wallet_buy_button_place_holder);
            int n = -1;
            int n2 = -2;
            if (SupportWalletFragment.this.zzbAF != null && (walletFragmentStyle = SupportWalletFragment.this.zzbAF.getFragmentStyle()) != null) {
                DisplayMetrics displayMetrics = SupportWalletFragment.this.zzaCl.getResources().getDisplayMetrics();
                n = walletFragmentStyle.zza("buyButtonWidth", displayMetrics, -1);
                n2 = walletFragmentStyle.zza("buyButtonHeight", displayMetrics, -2);
            }
            button.setLayoutParams(new ViewGroup.LayoutParams(n, n2));
            button.setOnClickListener((View.OnClickListener)this);
            frameLayout.addView((View)button);
        }

        public void onClick(View view) {
            FragmentActivity fragmentActivity = SupportWalletFragment.this.zzaCl.getActivity();
            int n = GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)fragmentActivity);
            GooglePlayServicesUtil.showErrorDialogFragment((int)n, (Activity)fragmentActivity, (int)-1);
        }
    }
}

