/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet.fragment;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import com.google.android.gms.R;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.wallet.fragment.WalletFragmentStyle;
import com.google.android.gms.wallet.fragment.zzb;

public final class WalletFragmentOptions
implements SafeParcelable {
    public static final Parcelable.Creator<WalletFragmentOptions> CREATOR = new zzb();
    final int mVersionCode;
    private int zzbkD;
    private int mTheme;
    private WalletFragmentStyle zzblj;
    private int zzamE;

    public static Builder newBuilder() {
        WalletFragmentOptions walletFragmentOptions = new WalletFragmentOptions();
        walletFragmentOptions.getClass();
        return walletFragmentOptions.new Builder();
    }

    private WalletFragmentOptions() {
        this.mVersionCode = 1;
        this.zzbkD = 3;
        this.zzblj = new WalletFragmentStyle();
    }

    WalletFragmentOptions(int versionCode, int environment, int theme, WalletFragmentStyle fragmentStyle, int mode) {
        this.mVersionCode = versionCode;
        this.zzbkD = environment;
        this.mTheme = theme;
        this.zzblj = fragmentStyle;
        this.zzamE = mode;
    }

    public int getEnvironment() {
        return this.zzbkD;
    }

    public int getTheme() {
        return this.mTheme;
    }

    public WalletFragmentStyle getFragmentStyle() {
        return this.zzblj;
    }

    public int getMode() {
        return this.zzamE;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zzb.zza(this, dest, flags);
    }

    public void zzbc(Context context) {
        if (this.zzblj != null) {
            this.zzblj.zzbc(context);
        }
    }

    public static WalletFragmentOptions zzb(Context context, AttributeSet attributeSet) {
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.WalletFragmentOptions);
        int n = typedArray.getInt(R.styleable.WalletFragmentOptions_appTheme, 0);
        int n2 = typedArray.getInt(R.styleable.WalletFragmentOptions_environment, 1);
        int n3 = typedArray.getResourceId(R.styleable.WalletFragmentOptions_fragmentStyle, 0);
        int n4 = typedArray.getInt(R.styleable.WalletFragmentOptions_fragmentMode, 1);
        typedArray.recycle();
        WalletFragmentOptions walletFragmentOptions = new WalletFragmentOptions();
        walletFragmentOptions.mTheme = n;
        walletFragmentOptions.zzbkD = n2;
        walletFragmentOptions.zzblj = new WalletFragmentStyle().setStyleResourceId(n3);
        walletFragmentOptions.zzblj.zzbc(context);
        walletFragmentOptions.zzamE = n4;
        return walletFragmentOptions;
    }

    public final class Builder {
        private Builder() {
        }

        public Builder setEnvironment(int environment) {
            WalletFragmentOptions.this.zzbkD = environment;
            return this;
        }

        public Builder setTheme(int theme) {
            WalletFragmentOptions.this.mTheme = theme;
            return this;
        }

        public Builder setFragmentStyle(int styleResourceId) {
            WalletFragmentOptions.this.zzblj = new WalletFragmentStyle().setStyleResourceId(styleResourceId);
            return this;
        }

        public Builder setFragmentStyle(WalletFragmentStyle fragmentStyle) {
            WalletFragmentOptions.this.zzblj = fragmentStyle;
            return this;
        }

        public Builder setMode(int mode) {
            WalletFragmentOptions.this.zzamE = mode;
            return this;
        }

        public WalletFragmentOptions build() {
            return WalletFragmentOptions.this;
        }
    }
}

