/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet.fragment;

import android.app.Activity;
import android.app.Fragment;
import android.app.FragmentManager;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.RemoteException;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.FrameLayout;
import com.google.android.gms.R;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.dynamic.LifecycleDelegate;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.dynamic.zzf;
import com.google.android.gms.internal.zznb;
import com.google.android.gms.internal.zznc;
import com.google.android.gms.internal.zznj;
import com.google.android.gms.wallet.MaskedWallet;
import com.google.android.gms.wallet.MaskedWalletRequest;
import com.google.android.gms.wallet.fragment.WalletFragmentInitParams;
import com.google.android.gms.wallet.fragment.WalletFragmentOptions;
import com.google.android.gms.wallet.fragment.WalletFragmentStyle;

public final class WalletFragment
extends Fragment {
    private zzb zzaJN;
    private boolean mCreated = false;
    private final com.google.android.gms.dynamic.zzb zzaJO = com.google.android.gms.dynamic.zzb.zza((Fragment)this);
    private final zzc zzaJP = new zzc();
    private zza zzaJQ = new zza(this);
    private final Fragment zzacp = this;
    private WalletFragmentOptions zzaJE;
    private WalletFragmentInitParams zzaJF;
    private MaskedWalletRequest zzaJG;
    private MaskedWallet zzaJH;
    private Boolean zzaJI;

    public static WalletFragment newInstance(WalletFragmentOptions options) {
        WalletFragment walletFragment = new WalletFragment();
        Bundle bundle = new Bundle();
        bundle.putParcelable("extraWalletFragmentOptions", (Parcelable)options);
        walletFragment.zzacp.setArguments(bundle);
        return walletFragment;
    }

    public void initialize(WalletFragmentInitParams initParams) {
        if (this.zzaJN != null) {
            this.zzaJN.initialize(initParams);
            this.zzaJF = null;
        } else if (this.zzaJF == null) {
            this.zzaJF = initParams;
            if (this.zzaJG != null) {
                Log.w((String)"WalletFragment", (String)"updateMaskedWalletRequest() was called before initialize()");
            }
            if (this.zzaJH != null) {
                Log.w((String)"WalletFragment", (String)"updateMaskedWallet() was called before initialize()");
            }
        } else {
            Log.w((String)"WalletFragment", (String)"initialize(WalletFragmentInitParams) was called more than once. Ignoring.");
        }
    }

    public void updateMaskedWalletRequest(MaskedWalletRequest request) {
        if (this.zzaJN != null) {
            this.zzaJN.updateMaskedWalletRequest(request);
            this.zzaJG = null;
        } else {
            this.zzaJG = request;
        }
    }

    public void updateMaskedWallet(MaskedWallet maskedWallet) {
        if (this.zzaJN != null) {
            this.zzaJN.updateMaskedWallet(maskedWallet);
            this.zzaJH = null;
        } else {
            this.zzaJH = maskedWallet;
        }
    }

    public void setEnabled(boolean enabled) {
        if (this.zzaJN != null) {
            this.zzaJN.setEnabled(enabled);
            this.zzaJI = null;
        } else {
            this.zzaJI = enabled;
        }
    }

    public void setOnStateChangedListener(OnStateChangedListener listener) {
        this.zzaJQ.zza(listener);
    }

    public int getState() {
        return this.zzaJN != null ? this.zzaJN.getState() : 0;
    }

    public void onInflate(Activity activity, AttributeSet attrs, Bundle savedInstanceState) {
        super.onInflate(activity, attrs, savedInstanceState);
        if (this.zzaJE == null) {
            this.zzaJE = WalletFragmentOptions.zza((Context)activity, attrs);
        }
        Bundle bundle = new Bundle();
        bundle.putParcelable("attrKeyWalletFragmentOptions", (Parcelable)this.zzaJE);
        this.zzaJP.onInflate(activity, bundle, savedInstanceState);
    }

    public void onCreate(Bundle savedInstanceState) {
        WalletFragmentOptions walletFragmentOptions;
        super.onCreate(savedInstanceState);
        if (savedInstanceState != null) {
            savedInstanceState.setClassLoader(WalletFragmentOptions.class.getClassLoader());
            WalletFragmentInitParams walletFragmentInitParams = (WalletFragmentInitParams)savedInstanceState.getParcelable("walletFragmentInitParams");
            if (walletFragmentInitParams != null) {
                if (this.zzaJF != null) {
                    Log.w((String)"WalletFragment", (String)"initialize(WalletFragmentInitParams) was called more than once.Ignoring.");
                }
                this.zzaJF = walletFragmentInitParams;
            }
            if (this.zzaJG == null) {
                this.zzaJG = (MaskedWalletRequest)savedInstanceState.getParcelable("maskedWalletRequest");
            }
            if (this.zzaJH == null) {
                this.zzaJH = (MaskedWallet)savedInstanceState.getParcelable("maskedWallet");
            }
            if (savedInstanceState.containsKey("walletFragmentOptions")) {
                this.zzaJE = (WalletFragmentOptions)savedInstanceState.getParcelable("walletFragmentOptions");
            }
            if (savedInstanceState.containsKey("enabled")) {
                this.zzaJI = savedInstanceState.getBoolean("enabled");
            }
        } else if (this.zzacp.getArguments() != null && (walletFragmentOptions = (WalletFragmentOptions)this.zzacp.getArguments().getParcelable("extraWalletFragmentOptions")) != null) {
            walletFragmentOptions.zzau((Context)this.zzacp.getActivity());
            this.zzaJE = walletFragmentOptions;
        }
        this.mCreated = true;
        this.zzaJP.onCreate(savedInstanceState);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return this.zzaJP.onCreateView(inflater, container, savedInstanceState);
    }

    public void onStart() {
        super.onStart();
        this.zzaJP.onStart();
    }

    public void onResume() {
        super.onResume();
        this.zzaJP.onResume();
        FragmentManager fragmentManager = this.zzacp.getActivity().getFragmentManager();
        Fragment fragment = fragmentManager.findFragmentByTag("GooglePlayServicesErrorDialog");
        if (fragment != null) {
            fragmentManager.beginTransaction().remove(fragment).commit();
            int n = GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)this.zzacp.getActivity());
            GooglePlayServicesUtil.showErrorDialogFragment((int)n, (Activity)this.zzacp.getActivity(), (int)-1);
        }
    }

    public void onPause() {
        super.onPause();
        this.zzaJP.onPause();
    }

    public void onStop() {
        super.onStop();
        this.zzaJP.onStop();
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.setClassLoader(WalletFragmentOptions.class.getClassLoader());
        this.zzaJP.onSaveInstanceState(outState);
        if (this.zzaJF != null) {
            outState.putParcelable("walletFragmentInitParams", (Parcelable)this.zzaJF);
            this.zzaJF = null;
        }
        if (this.zzaJG != null) {
            outState.putParcelable("maskedWalletRequest", (Parcelable)this.zzaJG);
            this.zzaJG = null;
        }
        if (this.zzaJH != null) {
            outState.putParcelable("maskedWallet", (Parcelable)this.zzaJH);
            this.zzaJH = null;
        }
        if (this.zzaJE != null) {
            outState.putParcelable("walletFragmentOptions", (Parcelable)this.zzaJE);
            this.zzaJE = null;
        }
        if (this.zzaJI != null) {
            outState.putBoolean("enabled", this.zzaJI.booleanValue());
            this.zzaJI = null;
        }
    }

    public void onDestroy() {
        super.onDestroy();
        this.mCreated = false;
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (this.zzaJN != null) {
            this.zzaJN.onActivityResult(requestCode, resultCode, data);
        }
    }

    public static interface OnStateChangedListener {
        public void onStateChanged(WalletFragment var1, int var2, int var3, Bundle var4);
    }

    static class zza
    extends zznc.zza {
        private OnStateChangedListener zzaJR;
        private final WalletFragment zzaJS;

        zza(WalletFragment walletFragment) {
            this.zzaJS = walletFragment;
        }

        @Override
        public void zza(int n, int n2, Bundle bundle) {
            if (this.zzaJR != null) {
                this.zzaJR.onStateChanged(this.zzaJS, n, n2, bundle);
            }
        }

        public void zza(OnStateChangedListener onStateChangedListener) {
            this.zzaJR = onStateChangedListener;
        }
    }

    private static class zzb
    implements LifecycleDelegate {
        private final zznb zzaJL;

        private zzb(zznb zznb2) {
            this.zzaJL = zznb2;
        }

        private void initialize(WalletFragmentInitParams startParams) {
            try {
                this.zzaJL.initialize(startParams);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private void setEnabled(boolean enabled) {
            try {
                this.zzaJL.setEnabled(enabled);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private void updateMaskedWalletRequest(MaskedWalletRequest request) {
            try {
                this.zzaJL.updateMaskedWalletRequest(request);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private void updateMaskedWallet(MaskedWallet maskedWallet) {
            try {
                this.zzaJL.updateMaskedWallet(maskedWallet);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private int getState() {
            try {
                return this.zzaJL.getState();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onInflate(Activity activity, Bundle attrs, Bundle savedInstanceState) {
            WalletFragmentOptions walletFragmentOptions = (WalletFragmentOptions)attrs.getParcelable("extraWalletFragmentOptions");
            try {
                this.zzaJL.zza(zze.zzt((Object)activity), walletFragmentOptions, savedInstanceState);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onCreate(Bundle savedInstanceState) {
            try {
                this.zzaJL.onCreate(savedInstanceState);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
            try {
                zzd zzd2 = this.zzaJL.onCreateView(zze.zzt((Object)inflater), zze.zzt((Object)container), savedInstanceState);
                return (View)zze.zzg((zzd)zzd2);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onStart() {
            try {
                this.zzaJL.onStart();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onResume() {
            try {
                this.zzaJL.onResume();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onPause() {
            try {
                this.zzaJL.onPause();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onStop() {
            try {
                this.zzaJL.onStop();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onDestroyView() {
        }

        public void onDestroy() {
        }

        public void onLowMemory() {
        }

        public void onSaveInstanceState(Bundle outState) {
            try {
                this.zzaJL.onSaveInstanceState(outState);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private void onActivityResult(int requestCode, int resultCode, Intent data) {
            try {
                this.zzaJL.onActivityResult(requestCode, resultCode, data);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }
    }

    private class zzc
    extends com.google.android.gms.dynamic.zza<zzb>
    implements View.OnClickListener {
        private zzc() {
        }

        protected void zza(zzf<zzb> zzf2) {
            Activity activity = WalletFragment.this.zzacp.getActivity();
            if (WalletFragment.this.zzaJN == null && WalletFragment.this.mCreated && activity != null) {
                try {
                    zznb zznb2 = zznj.zza(activity, (com.google.android.gms.dynamic.zzc)WalletFragment.this.zzaJO, WalletFragment.this.zzaJE, WalletFragment.this.zzaJQ);
                    WalletFragment.this.zzaJN = new zzb(zznb2);
                    WalletFragment.this.zzaJE = null;
                }
                catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {
                    return;
                }
                zzf2.zza((LifecycleDelegate)WalletFragment.this.zzaJN);
                if (WalletFragment.this.zzaJF != null) {
                    WalletFragment.this.zzaJN.initialize(WalletFragment.this.zzaJF);
                    WalletFragment.this.zzaJF = null;
                }
                if (WalletFragment.this.zzaJG != null) {
                    WalletFragment.this.zzaJN.updateMaskedWalletRequest(WalletFragment.this.zzaJG);
                    WalletFragment.this.zzaJG = null;
                }
                if (WalletFragment.this.zzaJH != null) {
                    WalletFragment.this.zzaJN.updateMaskedWallet(WalletFragment.this.zzaJH);
                    WalletFragment.this.zzaJH = null;
                }
                if (WalletFragment.this.zzaJI != null) {
                    WalletFragment.this.zzaJN.setEnabled(WalletFragment.this.zzaJI);
                    WalletFragment.this.zzaJI = null;
                }
            }
        }

        protected void zza(FrameLayout frameLayout) {
            WalletFragmentStyle walletFragmentStyle;
            Button button = new Button((Context)WalletFragment.this.zzacp.getActivity());
            button.setText(R.string.wallet_buy_button_place_holder);
            int n = -1;
            int n2 = -2;
            if (WalletFragment.this.zzaJE != null && (walletFragmentStyle = WalletFragment.this.zzaJE.getFragmentStyle()) != null) {
                DisplayMetrics displayMetrics = WalletFragment.this.zzacp.getResources().getDisplayMetrics();
                n = walletFragmentStyle.zza("buyButtonWidth", displayMetrics, n);
                n2 = walletFragmentStyle.zza("buyButtonHeight", displayMetrics, n2);
            }
            button.setLayoutParams(new ViewGroup.LayoutParams(n, n2));
            button.setOnClickListener((View.OnClickListener)this);
            frameLayout.addView((View)button);
        }

        public void onClick(View view) {
            Activity activity = WalletFragment.this.zzacp.getActivity();
            int n = GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)activity);
            GooglePlayServicesUtil.showErrorDialogFragment((int)n, (Activity)activity, (int)-1);
        }
    }
}

