/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet.fragment;

import android.app.Activity;
import android.app.Fragment;
import android.app.FragmentManager;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.RemoteException;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.FrameLayout;
import com.google.android.gms.R;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.dynamic.LifecycleDelegate;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.dynamic.zzf;
import com.google.android.gms.internal.zzwb;
import com.google.android.gms.internal.zzwc;
import com.google.android.gms.internal.zzwj;
import com.google.android.gms.wallet.MaskedWallet;
import com.google.android.gms.wallet.MaskedWalletRequest;
import com.google.android.gms.wallet.fragment.WalletFragmentInitParams;
import com.google.android.gms.wallet.fragment.WalletFragmentOptions;
import com.google.android.gms.wallet.fragment.WalletFragmentStyle;

public final class WalletFragment
extends Fragment {
    private zzb zzaEG;
    private boolean mCreated = false;
    private final com.google.android.gms.dynamic.zzb zzaEH = com.google.android.gms.dynamic.zzb.zza((Fragment)this);
    private final zzc zzaEI = new zzc();
    private zza zzaEJ = new zza(this);
    private final Fragment zzXZ = this;
    private WalletFragmentOptions zzaEx;
    private WalletFragmentInitParams zzaEy;
    private MaskedWalletRequest zzaEz;
    private MaskedWallet zzaEA;
    private Boolean zzaEB;

    public static WalletFragment newInstance(WalletFragmentOptions options) {
        WalletFragment walletFragment = new WalletFragment();
        Bundle bundle = new Bundle();
        bundle.putParcelable("extraWalletFragmentOptions", (Parcelable)options);
        walletFragment.zzXZ.setArguments(bundle);
        return walletFragment;
    }

    public void initialize(WalletFragmentInitParams initParams) {
        if (this.zzaEG != null) {
            this.zzaEG.initialize(initParams);
            this.zzaEy = null;
        } else if (this.zzaEy == null) {
            this.zzaEy = initParams;
            if (this.zzaEz != null) {
                Log.w((String)"WalletFragment", (String)"updateMaskedWalletRequest() was called before initialize()");
            }
            if (this.zzaEA != null) {
                Log.w((String)"WalletFragment", (String)"updateMaskedWallet() was called before initialize()");
            }
        } else {
            Log.w((String)"WalletFragment", (String)"initialize(WalletFragmentInitParams) was called more than once. Ignoring.");
        }
    }

    public void updateMaskedWalletRequest(MaskedWalletRequest request) {
        if (this.zzaEG != null) {
            this.zzaEG.updateMaskedWalletRequest(request);
            this.zzaEz = null;
        } else {
            this.zzaEz = request;
        }
    }

    public void updateMaskedWallet(MaskedWallet maskedWallet) {
        if (this.zzaEG != null) {
            this.zzaEG.updateMaskedWallet(maskedWallet);
            this.zzaEA = null;
        } else {
            this.zzaEA = maskedWallet;
        }
    }

    public void setEnabled(boolean enabled) {
        if (this.zzaEG != null) {
            this.zzaEG.setEnabled(enabled);
            this.zzaEB = null;
        } else {
            this.zzaEB = enabled;
        }
    }

    public void setOnStateChangedListener(OnStateChangedListener listener) {
        this.zzaEJ.zza(listener);
    }

    public int getState() {
        return this.zzaEG != null ? this.zzaEG.getState() : 0;
    }

    public void onInflate(Activity activity, AttributeSet attrs, Bundle savedInstanceState) {
        super.onInflate(activity, attrs, savedInstanceState);
        if (this.zzaEx == null) {
            this.zzaEx = WalletFragmentOptions.zza((Context)activity, attrs);
        }
        Bundle bundle = new Bundle();
        bundle.putParcelable("attrKeyWalletFragmentOptions", (Parcelable)this.zzaEx);
        this.zzaEI.onInflate(activity, bundle, savedInstanceState);
    }

    public void onCreate(Bundle savedInstanceState) {
        WalletFragmentOptions walletFragmentOptions;
        super.onCreate(savedInstanceState);
        if (savedInstanceState != null) {
            savedInstanceState.setClassLoader(WalletFragmentOptions.class.getClassLoader());
            WalletFragmentInitParams walletFragmentInitParams = (WalletFragmentInitParams)savedInstanceState.getParcelable("walletFragmentInitParams");
            if (walletFragmentInitParams != null) {
                if (this.zzaEy != null) {
                    Log.w((String)"WalletFragment", (String)"initialize(WalletFragmentInitParams) was called more than once.Ignoring.");
                }
                this.zzaEy = walletFragmentInitParams;
            }
            if (this.zzaEz == null) {
                this.zzaEz = (MaskedWalletRequest)savedInstanceState.getParcelable("maskedWalletRequest");
            }
            if (this.zzaEA == null) {
                this.zzaEA = (MaskedWallet)savedInstanceState.getParcelable("maskedWallet");
            }
            if (savedInstanceState.containsKey("walletFragmentOptions")) {
                this.zzaEx = (WalletFragmentOptions)savedInstanceState.getParcelable("walletFragmentOptions");
            }
            if (savedInstanceState.containsKey("enabled")) {
                this.zzaEB = savedInstanceState.getBoolean("enabled");
            }
        } else if (this.zzXZ.getArguments() != null && (walletFragmentOptions = (WalletFragmentOptions)this.zzXZ.getArguments().getParcelable("extraWalletFragmentOptions")) != null) {
            walletFragmentOptions.zzao((Context)this.zzXZ.getActivity());
            this.zzaEx = walletFragmentOptions;
        }
        this.mCreated = true;
        this.zzaEI.onCreate(savedInstanceState);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return this.zzaEI.onCreateView(inflater, container, savedInstanceState);
    }

    public void onStart() {
        super.onStart();
        this.zzaEI.onStart();
    }

    public void onResume() {
        super.onResume();
        this.zzaEI.onResume();
        FragmentManager fragmentManager = this.zzXZ.getActivity().getFragmentManager();
        Fragment fragment = fragmentManager.findFragmentByTag("GooglePlayServicesErrorDialog");
        if (fragment != null) {
            fragmentManager.beginTransaction().remove(fragment).commit();
            int n = GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)this.zzXZ.getActivity());
            GooglePlayServicesUtil.showErrorDialogFragment((int)n, (Activity)this.zzXZ.getActivity(), (int)-1);
        }
    }

    public void onPause() {
        super.onPause();
        this.zzaEI.onPause();
    }

    public void onStop() {
        super.onStop();
        this.zzaEI.onStop();
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.setClassLoader(WalletFragmentOptions.class.getClassLoader());
        this.zzaEI.onSaveInstanceState(outState);
        if (this.zzaEy != null) {
            outState.putParcelable("walletFragmentInitParams", (Parcelable)this.zzaEy);
            this.zzaEy = null;
        }
        if (this.zzaEz != null) {
            outState.putParcelable("maskedWalletRequest", (Parcelable)this.zzaEz);
            this.zzaEz = null;
        }
        if (this.zzaEA != null) {
            outState.putParcelable("maskedWallet", (Parcelable)this.zzaEA);
            this.zzaEA = null;
        }
        if (this.zzaEx != null) {
            outState.putParcelable("walletFragmentOptions", (Parcelable)this.zzaEx);
            this.zzaEx = null;
        }
        if (this.zzaEB != null) {
            outState.putBoolean("enabled", this.zzaEB.booleanValue());
            this.zzaEB = null;
        }
    }

    public void onDestroy() {
        super.onDestroy();
        this.mCreated = false;
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (this.zzaEG != null) {
            this.zzaEG.onActivityResult(requestCode, resultCode, data);
        }
    }

    public static interface OnStateChangedListener {
        public void onStateChanged(WalletFragment var1, int var2, int var3, Bundle var4);
    }

    static class zza
    extends zzwc.zza {
        private OnStateChangedListener zzaEK;
        private final WalletFragment zzaEL;

        zza(WalletFragment walletFragment) {
            this.zzaEL = walletFragment;
        }

        @Override
        public void zza(int n, int n2, Bundle bundle) {
            if (this.zzaEK != null) {
                this.zzaEK.onStateChanged(this.zzaEL, n, n2, bundle);
            }
        }

        public void zza(OnStateChangedListener onStateChangedListener) {
            this.zzaEK = onStateChangedListener;
        }
    }

    private static class zzb
    implements LifecycleDelegate {
        private final zzwb zzaEE;

        private zzb(zzwb zzwb2) {
            this.zzaEE = zzwb2;
        }

        private void initialize(WalletFragmentInitParams startParams) {
            try {
                this.zzaEE.initialize(startParams);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private void setEnabled(boolean enabled) {
            try {
                this.zzaEE.setEnabled(enabled);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private void updateMaskedWalletRequest(MaskedWalletRequest request) {
            try {
                this.zzaEE.updateMaskedWalletRequest(request);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private void updateMaskedWallet(MaskedWallet maskedWallet) {
            try {
                this.zzaEE.updateMaskedWallet(maskedWallet);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private int getState() {
            try {
                return this.zzaEE.getState();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onInflate(Activity activity, Bundle attrs, Bundle savedInstanceState) {
            WalletFragmentOptions walletFragmentOptions = (WalletFragmentOptions)attrs.getParcelable("extraWalletFragmentOptions");
            try {
                this.zzaEE.zza(zze.zzn((Object)activity), walletFragmentOptions, savedInstanceState);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onCreate(Bundle savedInstanceState) {
            try {
                this.zzaEE.onCreate(savedInstanceState);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
            try {
                zzd zzd2 = this.zzaEE.onCreateView(zze.zzn((Object)inflater), zze.zzn((Object)container), savedInstanceState);
                return (View)zze.zzf((zzd)zzd2);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onStart() {
            try {
                this.zzaEE.onStart();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onResume() {
            try {
                this.zzaEE.onResume();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onPause() {
            try {
                this.zzaEE.onPause();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onStop() {
            try {
                this.zzaEE.onStop();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onDestroyView() {
        }

        public void onDestroy() {
        }

        public void onLowMemory() {
        }

        public void onSaveInstanceState(Bundle outState) {
            try {
                this.zzaEE.onSaveInstanceState(outState);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private void onActivityResult(int requestCode, int resultCode, Intent data) {
            try {
                this.zzaEE.onActivityResult(requestCode, resultCode, data);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }
    }

    private class zzc
    extends com.google.android.gms.dynamic.zza<zzb>
    implements View.OnClickListener {
        private zzc() {
        }

        protected void zza(zzf<zzb> zzf2) {
            Activity activity = WalletFragment.this.zzXZ.getActivity();
            if (WalletFragment.this.zzaEG == null && WalletFragment.this.mCreated && activity != null) {
                try {
                    zzwb zzwb2 = zzwj.zza(activity, (com.google.android.gms.dynamic.zzc)WalletFragment.this.zzaEH, WalletFragment.this.zzaEx, WalletFragment.this.zzaEJ);
                    WalletFragment.this.zzaEG = new zzb(zzwb2);
                    WalletFragment.this.zzaEx = null;
                }
                catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {
                    return;
                }
                zzf2.zza((LifecycleDelegate)WalletFragment.this.zzaEG);
                if (WalletFragment.this.zzaEy != null) {
                    WalletFragment.this.zzaEG.initialize(WalletFragment.this.zzaEy);
                    WalletFragment.this.zzaEy = null;
                }
                if (WalletFragment.this.zzaEz != null) {
                    WalletFragment.this.zzaEG.updateMaskedWalletRequest(WalletFragment.this.zzaEz);
                    WalletFragment.this.zzaEz = null;
                }
                if (WalletFragment.this.zzaEA != null) {
                    WalletFragment.this.zzaEG.updateMaskedWallet(WalletFragment.this.zzaEA);
                    WalletFragment.this.zzaEA = null;
                }
                if (WalletFragment.this.zzaEB != null) {
                    WalletFragment.this.zzaEG.setEnabled(WalletFragment.this.zzaEB);
                    WalletFragment.this.zzaEB = null;
                }
            }
        }

        protected void zza(FrameLayout frameLayout) {
            WalletFragmentStyle walletFragmentStyle;
            Button button = new Button((Context)WalletFragment.this.zzXZ.getActivity());
            button.setText(R.string.wallet_buy_button_place_holder);
            int n = -1;
            int n2 = -2;
            if (WalletFragment.this.zzaEx != null && (walletFragmentStyle = WalletFragment.this.zzaEx.getFragmentStyle()) != null) {
                DisplayMetrics displayMetrics = WalletFragment.this.zzXZ.getResources().getDisplayMetrics();
                n = walletFragmentStyle.zza("buyButtonWidth", displayMetrics, n);
                n2 = walletFragmentStyle.zza("buyButtonHeight", displayMetrics, n2);
            }
            button.setLayoutParams(new ViewGroup.LayoutParams(n, n2));
            button.setOnClickListener((View.OnClickListener)this);
            frameLayout.addView((View)button);
        }

        public void onClick(View view) {
            Activity activity = WalletFragment.this.zzXZ.getActivity();
            int n = GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)activity);
            GooglePlayServicesUtil.showErrorDialogFragment((int)n, (Activity)activity, (int)-1);
        }
    }
}

