/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet.button;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.LayerDrawable;
import android.graphics.drawable.RippleDrawable;
import android.graphics.drawable.StateListDrawable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.view.ContextThemeWrapper;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.PlatformVersion;
import com.google.android.gms.wallet.R;
import com.google.android.gms.wallet.button.ButtonOptions;
import com.google.android.gms.wallet.button.zzf;
import com.google.android.gms.wallet.button.zzg;
import com.google.android.gms.wallet.button.zzh;

public final class PayButton
extends FrameLayout
implements View.OnClickListener {
    @Nullable
    private View.OnClickListener zza;
    private ButtonOptions.Builder zzb;
    @Nullable
    private View zzc;
    private final zzf zzd;

    /*
     * WARNING - void declaration
     */
    public PayButton(@NonNull Context context) {
        this((Context)var1_1, null);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public PayButton(@NonNull Context context, @Nullable AttributeSet attrs) {
        this((Context)var1_1, (AttributeSet)var2_2, 0);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public PayButton(@NonNull Context context, @Nullable AttributeSet attrs, int defStyle) {
        super((Context)typedArray, (AttributeSet)var2_2, (int)var3_4);
        void var3_4;
        void var2_2;
        TypedArray typedArray;
        ButtonOptions.Builder builder = this.zzb = ButtonOptions.newBuilder();
        typedArray = typedArray.obtainStyledAttributes((AttributeSet)var2_2, R.styleable.PayButtonAttributes);
        int n = typedArray.getInt(R.styleable.PayButtonAttributes_buttonTheme, 1);
        int n2 = (int)TypedValue.applyDimension((int)1, (float)100.0f, (DisplayMetrics)Resources.getSystem().getDisplayMetrics());
        ButtonOptions buttonOptions = builder.ButtonOptions.this;
        buttonOptions.zzb = n;
        buttonOptions.zzc = typedArray.getDimensionPixelSize(R.styleable.PayButtonAttributes_cornerRadius, n2);
        if (typedArray.hasValue(R.styleable.PayButtonAttributes_cornerRadius)) {
            builder.ButtonOptions.this.zze = true;
        }
        typedArray.recycle();
        builder.setButtonType(1);
        this.zzd = new zzf();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void initialize(@NonNull ButtonOptions options) {
        View view;
        Object object = this.zzb;
        if (view.getButtonType() != 0) {
            ((ButtonOptions.Builder)object).ButtonOptions.this.zza = view.getButtonType();
        }
        if (view.getButtonTheme() != 0) {
            ((ButtonOptions.Builder)object).ButtonOptions.this.zzb = view.getButtonTheme();
        }
        if (view.zze) {
            ((ButtonOptions.Builder)object).setCornerRadius(view.getCornerRadius());
        }
        if (view.getAllowedPaymentMethods() != null) {
            ((ButtonOptions.Builder)object).ButtonOptions.this.zzd = view.getAllowedPaymentMethods();
        }
        this.removeAllViews();
        object = this.zzb.build();
        if (GoogleApiAvailability.getInstance().isGooglePlayServicesAvailable(this.getContext(), 232100000) != 0) {
            int n = ((ButtonOptions)((Object)object)).getButtonTheme() == 2 ? R.style.PayButtonGenericLightTheme : R.style.PayButtonGenericDarkTheme;
            ContextThemeWrapper contextThemeWrapper = new ContextThemeWrapper(this.getContext(), n);
            zzg zzg2 = new zzg((Context)contextThemeWrapper, null);
            contextThemeWrapper = (LinearLayout)LayoutInflater.from((Context)zzg2.getContext()).inflate(R.layout.paybutton_generic, (ViewGroup)zzg2, true).findViewById(R.id.pay_button_view);
            Context context = zzg2.getContext();
            int n2 = ((ButtonOptions)((Object)object)).getCornerRadius();
            object = (GradientDrawable)zzh.zza(context, R.attr.payButtonGenericBackground).mutate();
            float f = n2;
            object.setCornerRadius(f);
            int n3 = R.attr.payButtonGenericRippleColor;
            TypedArray typedArray = context.obtainStyledAttributes(new TypedValue().data, new int[]{n3});
            int n4 = typedArray.getColor(0, 0);
            typedArray.recycle();
            typedArray = ColorStateList.valueOf((int)n4);
            if (PlatformVersion.isAtLeastLollipop()) {
                context = new RippleDrawable((ColorStateList)typedArray, (Drawable)object, null);
            } else {
                context = (GradientDrawable)zzh.zza(context, R.attr.payButtonGenericRippleMask).mutate();
                context.setCornerRadius(f);
                StateListDrawable stateListDrawable = new StateListDrawable();
                stateListDrawable.addState(new int[]{16842919}, (Drawable)new LayerDrawable(new Drawable[]{object, context}));
                stateListDrawable.addState(new int[0], (Drawable)object);
                context = stateListDrawable;
            }
            contextThemeWrapper.setBackground((Drawable)context);
            zzg zzg3 = zzg2;
            zzg3.setContentDescription(zzg3.getContext().getString(R.string.gpay_logo_description));
            this.zzc = zzg2;
            PayButton payButton = this;
            payButton.addView(payButton.zzc);
            this.zzc.setOnClickListener((View.OnClickListener)this);
            Log.e((String)"PayButton", (String)"Failed to create latest buttonView: Google Play Services version is outdated.");
            return;
        }
        if (TextUtils.isEmpty((CharSequence)((ButtonOptions)((Object)object)).getAllowedPaymentMethods())) {
            Log.e((String)"PayButton", (String)"Failed to create buttonView: allowedPaymentMethods cannot be empty.");
            return;
        }
        this.zzc = zzf.zza((Context)Preconditions.checkNotNull((Object)this.getContext()), (ButtonOptions)((Object)object));
        view = this.zzc;
        if (view == null) {
            Log.e((String)"PayButton", (String)"Failed to create buttonView");
            return;
        }
        this.addView(view);
        this.zzc.setOnClickListener((View.OnClickListener)this);
    }

    /*
     * WARNING - void declaration
     */
    public void onClick(@NonNull View view) {
        void var1_1;
        View.OnClickListener onClickListener = this.zza;
        if (onClickListener != null && var1_1 == this.zzc) {
            onClickListener.onClick((View)this);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setOnClickListener(@Nullable View.OnClickListener listener) {
        void var1_1;
        this.zza = var1_1;
    }
}

