/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.wallet;

import android.accounts.Account;
import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Parcelable;
import android.os.RemoteException;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.Nullable;
import com.google.android.gms.common.Feature;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.ClientSettings;
import com.google.android.gms.common.internal.GmsClient;
import com.google.android.gms.internal.wallet.zzo;
import com.google.android.gms.internal.wallet.zzs;
import com.google.android.gms.internal.wallet.zzt;
import com.google.android.gms.internal.wallet.zzu;
import com.google.android.gms.internal.wallet.zzv;
import com.google.android.gms.internal.wallet.zzw;
import com.google.android.gms.internal.wallet.zzx;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.android.gms.wallet.CreateWalletObjectsRequest;
import com.google.android.gms.wallet.IsReadyToPayRequest;
import com.google.android.gms.wallet.PaymentCardRecognitionIntentRequest;
import com.google.android.gms.wallet.PaymentDataRequest;
import com.google.android.gms.wallet.zzk;

public final class zzy
extends GmsClient {
    private final Context zze;
    private final int zzf;
    @Nullable
    private final String zzg;
    private final int zzh;
    private final boolean zzi;

    public final int getMinApkVersion() {
        return 12600000;
    }

    private final Bundle zzu() {
        int n = this.zzf;
        String string = this.zze.getPackageName();
        String string2 = this.zzg;
        int n2 = this.zzh;
        boolean bl = this.zzi;
        Bundle bundle = new Bundle();
        bundle.putInt("com.google.android.gms.wallet.EXTRA_ENVIRONMENT", n);
        bundle.putBoolean("com.google.android.gms.wallet.EXTRA_USING_ANDROID_PAY_BRAND", bl);
        bundle.putString("androidPackageName", string);
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            String string3 = "com.google";
            Account account = new Account(string2, string3);
            bundle.putParcelable("com.google.android.gms.wallet.EXTRA_BUYER_ACCOUNT", (Parcelable)account);
        }
        bundle.putInt("com.google.android.gms.wallet.EXTRA_THEME", n2);
        return bundle;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final /* synthetic */ IInterface createServiceInterface(IBinder iBinder) {
        void var0_2;
        void var1_6;
        if (var1_6 == null) {
            return var0_2;
        }
        IInterface iInterface = var1_6.queryLocalInterface("com.google.android.gms.wallet.internal.IOwService");
        if (iInterface instanceof zzo) {
            zzo zzo2 = (zzo)iInterface;
            return var0_2;
        }
        zzo zzo3 = new zzo((IBinder)var1_6);
        return var0_2;
    }

    protected final String getServiceDescriptor() {
        return "com.google.android.gms.wallet.internal.IOwService";
    }

    protected final String getStartServiceAction() {
        return "com.google.android.gms.wallet.service.BIND";
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public zzy(Context object, Looper looper, ClientSettings clientSettings, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener, int n, int n2, boolean bl) {
        super(object, (Looper)var2_6, 4, (ClientSettings)var3_7, (GoogleApiClient.ConnectionCallbacks)var4_8, (GoogleApiClient.OnConnectionFailedListener)var5_9);
        void var8_12;
        void var7_11;
        void var1_4;
        void var6_10;
        void var5_9;
        void var4_8;
        void var3_7;
        void var2_6;
        this.zze = object;
        this.zzf = var6_10;
        Account account = var3_7.getAccount();
        if (account != null) {
            String string = account.name;
        } else {
            Object var1_5 = null;
        }
        this.zzg = var1_4;
        this.zzh = var7_11;
        this.zzi = var8_12;
    }

    public final void zzp(CreateWalletObjectsRequest createWalletObjectsRequest, int n) {
        zzs zzs2 = new zzs((Activity)this.zze, n);
        Bundle bundle = this.zzu();
        try {
            ((zzo)this.getService()).zzd(createWalletObjectsRequest, bundle, zzs2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e((String)"WalletClientImpl", (String)"RemoteException creating wallet objects", (Throwable)remoteException);
            ((zzt)zzs2).zzh(8, Bundle.EMPTY);
            return;
        }
    }

    public final void zzq(CreateWalletObjectsRequest createWalletObjectsRequest, TaskCompletionSource taskCompletionSource) {
        Bundle bundle = this.zzu();
        bundle.putBoolean("com.google.android.gms.wallet.EXTRA_USING_AUTO_RESOLVABLE_RESULT", true);
        zzv zzv2 = new zzv(taskCompletionSource);
        try {
            ((zzo)this.getService()).zzd(createWalletObjectsRequest, bundle, zzv2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e((String)"WalletClientImpl", (String)"RemoteException creating wallet objects", (Throwable)remoteException);
            ((zzt)zzv2).zzh(8, Bundle.EMPTY);
            return;
        }
    }

    public final void zzr(PaymentCardRecognitionIntentRequest paymentCardRecognitionIntentRequest, TaskCompletionSource taskCompletionSource) {
        Bundle bundle = this.zzu();
        zzw zzw2 = new zzw(taskCompletionSource);
        try {
            ((zzo)this.getService()).zze(paymentCardRecognitionIntentRequest, bundle, zzw2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e((String)"WalletClientImpl", (String)"RemoteException during getPaymentCardRecognitionIntent", (Throwable)remoteException);
            return;
        }
    }

    public final void zzs(IsReadyToPayRequest isReadyToPayRequest, TaskCompletionSource taskCompletionSource) throws RemoteException {
        zzu zzu2 = new zzu(taskCompletionSource);
        try {
            ((zzo)this.getService()).zzf(isReadyToPayRequest, this.zzu(), zzu2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e((String)"WalletClientImpl", (String)"RemoteException during isReadyToPay", (Throwable)remoteException);
            ((zzt)zzu2).zzc(Status.RESULT_INTERNAL_ERROR, false, Bundle.EMPTY);
            return;
        }
    }

    public final void zzt(PaymentDataRequest paymentDataRequest, TaskCompletionSource taskCompletionSource) {
        Bundle bundle = this.zzu();
        bundle.putBoolean("com.google.android.gms.wallet.EXTRA_USING_AUTO_RESOLVABLE_RESULT", true);
        zzx zzx2 = new zzx(taskCompletionSource);
        try {
            ((zzo)this.getService()).zzg(paymentDataRequest, bundle, zzx2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e((String)"WalletClientImpl", (String)"RemoteException getting payment data", (Throwable)remoteException);
            ((zzt)zzx2).zzf(Status.RESULT_INTERNAL_ERROR, null, Bundle.EMPTY);
            return;
        }
    }

    public final boolean requiresAccount() {
        return true;
    }

    public final boolean usesClientTelemetry() {
        return true;
    }

    public final Feature[] getApiFeatures() {
        return zzk.zzi;
    }
}

