/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet.button;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.view.View;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.wallet.R;
import com.google.android.gms.wallet.button.ButtonOptions;
import com.google.android.gms.wallet.button.zzf;

public final class PayButton
extends FrameLayout {
    private ButtonOptions.Builder zza;
    @Nullable
    private View zzb;
    private final zzf zzc;

    /*
     * WARNING - void declaration
     */
    public PayButton(@NonNull Context context) {
        this((Context)var1_1, null);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public PayButton(@NonNull Context context, @Nullable AttributeSet attrs) {
        this((Context)var1_1, (AttributeSet)var2_2, 0);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public PayButton(@NonNull Context context, @Nullable AttributeSet attrs, int defStyle) {
        super((Context)typedArray, (AttributeSet)var2_2, (int)var3_4);
        void var3_4;
        void var2_2;
        TypedArray typedArray;
        ButtonOptions.Builder builder = this.zza = ButtonOptions.newBuilder();
        typedArray = typedArray.obtainStyledAttributes((AttributeSet)var2_2, R.styleable.PayButtonAttributes);
        int n = typedArray.getInt(R.styleable.PayButtonAttributes_buttonTheme, 1);
        int n2 = (int)TypedValue.applyDimension((int)1, (float)100.0f, (DisplayMetrics)Resources.getSystem().getDisplayMetrics());
        int n3 = typedArray.getDimensionPixelSize(R.styleable.PayButtonAttributes_cornerRadius, n2);
        typedArray.recycle();
        ButtonOptions buttonOptions = builder.ButtonOptions.this;
        buttonOptions.zzb = n;
        buttonOptions.zzc = n3;
        builder.setButtonType(1);
        this.zzc = new zzf();
    }

    public void initialize(@NonNull ButtonOptions options) {
        ButtonOptions buttonOptions;
        ButtonOptions.Builder builder = this.zza;
        if (buttonOptions.getButtonType() != 0) {
            builder.ButtonOptions.this.zza = buttonOptions.getButtonType();
        }
        if (buttonOptions.getButtonTheme() != 0) {
            builder.ButtonOptions.this.zzb = buttonOptions.getButtonTheme();
        }
        if (buttonOptions.getCornerRadius() != 0) {
            builder.ButtonOptions.this.zzc = buttonOptions.getCornerRadius();
        }
        if (buttonOptions.getAllowedPaymentMethods() != null) {
            builder.ButtonOptions.this.zzd = buttonOptions.getAllowedPaymentMethods();
        }
        this.removeAllViews();
        buttonOptions = this.zza.build();
        if (TextUtils.isEmpty((CharSequence)buttonOptions.getAllowedPaymentMethods())) {
            Log.e((String)"PayButton", (String)"Failed to create buttonView: allowedPaymentMethods cannot be empty.");
            return;
        }
        this.zzb = zzf.zza((Context)Preconditions.checkNotNull((Object)this.getContext()), buttonOptions);
        buttonOptions = this.zzb;
        if (buttonOptions == null) {
            Log.e((String)"PayButton", (String)"Failed to create buttonView");
            return;
        }
        this.addView((View)buttonOptions);
    }
}

