/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet;

import android.app.Activity;
import android.app.Fragment;
import android.app.FragmentManager;
import android.app.PendingIntent;
import android.content.Intent;
import android.content.IntentSender;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.SystemClock;
import android.util.Log;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.common.api.ApiException;
import com.google.android.gms.common.api.ResolvableApiException;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.ApiExceptionUtil;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.android.gms.wallet.AutoResolvableResult;
import com.google.android.gms.wallet.zzc;
import com.google.android.gms.wallet.zzd;
import java.util.concurrent.TimeUnit;

public class AutoResolveHelper {
    public static final int RESULT_ERROR = 1;
    private static final long zzb = TimeUnit.MINUTES.toMillis(10L);
    @VisibleForTesting
    static long zza = SystemClock.elapsedRealtime();

    @Nullable
    public static Status getStatusFromIntent(@Nullable Intent data) {
        Intent intent;
        if (data == null) {
            return null;
        }
        return (Status)intent.getParcelableExtra("com.google.android.gms.common.api.AutoResolveHelper.status");
    }

    private AutoResolveHelper() {
    }

    /*
     * WARNING - void declaration
     */
    public static void putStatusIntoIntent(@NonNull Intent data, @Nullable Status status) {
        void var1_1;
        Intent intent;
        if (status == null) {
            intent.removeExtra("com.google.android.gms.common.api.AutoResolveHelper.status");
            return;
        }
        intent.putExtra("com.google.android.gms.common.api.AutoResolveHelper.status", (Parcelable)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @MainThread
    public static <TResult extends AutoResolvableResult> void resolveTask(@NonNull Task<TResult> task, @NonNull Activity activity, int requestCode) {
        void var2_3;
        FragmentManager fragmentManager;
        Object object = zzc.zza(task);
        fragmentManager = fragmentManager.getFragmentManager();
        fragmentManager = fragmentManager.beginTransaction();
        int n = object.zzc;
        Bundle bundle = new Bundle();
        bundle.putInt("resolveCallId", n);
        bundle.putInt("requestCode", (int)var2_3);
        bundle.putLong("initializationElapsedRealtime", zza);
        zzd zzd2 = new zzd();
        zzd2.setArguments(bundle);
        int n2 = object.zzc;
        StringBuilder stringBuilder = new StringBuilder(58);
        stringBuilder.append("com.google.android.gms.wallet.AutoResolveHelper");
        stringBuilder.append(n2);
        fragmentManager.add((Fragment)zzd2, stringBuilder.toString()).commit();
    }

    static /* bridge */ /* synthetic */ long zza() {
        return zzb;
    }

    static /* bridge */ /* synthetic */ void zzb(Activity activity, int n, int n2, Intent intent) {
        AutoResolveHelper.zze(activity, n, 0, intent);
    }

    static /* bridge */ /* synthetic */ void zzc(Activity activity, int n, Task task) {
        AutoResolveHelper.zzf(activity, n, task);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void zze(Activity activity, int n, int n2, Intent intent) {
        if ((activity = activity.createPendingResult(n, intent, 0x40000000)) == null) {
            if (!Log.isLoggable((String)"AutoResolveHelper", (int)5)) return;
            Log.w((String)"AutoResolveHelper", (String)"Null pending result returned when trying to deliver task result!");
            return;
        }
        try {
            activity.send(n2);
            return;
        }
        catch (PendingIntent.CanceledException canceledException) {
            if (!Log.isLoggable((String)"AutoResolveHelper", (int)6)) return;
            Log.e((String)"AutoResolveHelper", (String)"Exception sending pending result", (Throwable)canceledException);
            return;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void zzf(Activity activity, int n, Task task) {
        int n2;
        if (activity.isFinishing()) {
            if (!Log.isLoggable((String)"AutoResolveHelper", (int)3)) return;
            Log.d((String)"AutoResolveHelper", (String)"Ignoring task result for, Activity is finishing.");
            return;
        }
        Exception exception = task.getException();
        if (exception instanceof ResolvableApiException) {
            task = (ResolvableApiException)exception;
            task.startResolutionForResult(activity, n);
            return;
        }
        Intent intent = new Intent();
        if (task.isSuccessful()) {
            ((AutoResolvableResult)task.getResult()).putIntoIntent(intent);
            n2 = -1;
        } else if (exception instanceof ApiException) {
            task = (ApiException)exception;
            exception = new Status(task.getStatusCode(), task.getMessage(), null);
            AutoResolveHelper.putStatusIntoIntent(intent, (Status)exception);
            n2 = 1;
        } else {
            if (Log.isLoggable((String)"AutoResolveHelper", (int)6)) {
                Log.e((String)"AutoResolveHelper", (String)"Unexpected non API exception!", (Throwable)exception);
            }
            task = new Status(8, "Unexpected non API exception when trying to deliver the task result to an activity!");
            AutoResolveHelper.putStatusIntoIntent(intent, (Status)task);
            n2 = 1;
        }
        AutoResolveHelper.zze(activity, n, n2, intent);
        return;
        catch (IntentSender.SendIntentException sendIntentException) {
            if (!Log.isLoggable((String)"AutoResolveHelper", (int)6)) {
                return;
            }
            Log.e((String)"AutoResolveHelper", (String)"Error starting pending intent!", (Throwable)sendIntentException);
            return;
        }
    }

    public static void zzd(@NonNull Status status, @Nullable Object object, @NonNull TaskCompletionSource taskCompletionSource) {
        if (status.isSuccess()) {
            taskCompletionSource.setResult(object);
            return;
        }
        taskCompletionSource.setException((Exception)ApiExceptionUtil.fromStatus((Status)status));
    }
}

