/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.wallet.zzah;
import com.google.android.gms.wallet.zzai;

@SafeParcelable.Class(creator="TransactionInfoCreator")
public final class TransactionInfo
extends AbstractSafeParcelable {
    @NonNull
    public static final Parcelable.Creator<TransactionInfo> CREATOR;
    @SafeParcelable.Field(id=1)
    int zza;
    @SafeParcelable.Field(id=2)
    String zzb;
    @SafeParcelable.Field(id=3)
    String zzc;

    public int getTotalPriceStatus() {
        return this.zza;
    }

    @NonNull
    public static Builder newBuilder() {
        TransactionInfo transactionInfo = new TransactionInfo();
        Builder builder = transactionInfo.new Builder(null);
        return builder;
    }

    @NonNull
    public String getCurrencyCode() {
        return this.zzc;
    }

    @Nullable
    public String getTotalPrice() {
        return this.zzb;
    }

    static {
        zzai zzai2;
        CREATOR = zzai2 = new zzai();
    }

    private TransactionInfo() {
    }

    @SafeParcelable.Constructor
    public TransactionInfo(@SafeParcelable.Param(id=1) int n, @SafeParcelable.Param(id=2) @NonNull String string, @SafeParcelable.Param(id=3) @NonNull String string2) {
        this.zza = n;
        this.zzb = string;
        this.zzc = string2;
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(@NonNull Parcel out, int n) {
        void var1_1;
        n = SafeParcelWriter.beginObjectHeader((Parcel)out);
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)1, (int)this.zza);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)2, (String)this.zzb, (boolean)false);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)3, (String)this.zzc, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)var1_1, (int)n);
    }

    public final class Builder {
        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setCurrencyCode(@NonNull String currencyCode) {
            void var1_1;
            TransactionInfo.this.zzc = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setTotalPrice(@NonNull String totalPrice) {
            void var1_1;
            TransactionInfo.this.zzb = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setTotalPriceStatus(int totalPriceStatus) {
            void var1_1;
            TransactionInfo.this.zza = var1_1;
            return this;
        }

        /*
         * Enabled aggressive block sorting
         */
        @NonNull
        public TransactionInfo build() {
            Preconditions.checkNotEmpty((String)((Builder)this_).TransactionInfo.this.zzc, (Object)"currencyCode must be set!");
            TransactionInfo transactionInfo = ((Builder)this_).TransactionInfo.this;
            int n = transactionInfo.zza;
            if (n != 1) {
                if (n != 2) {
                    if (n != 3) {
                        Object this_ = new IllegalArgumentException("totalPriceStatus must be set to one of WalletConstants.TotalPriceStatus!");
                        throw this_;
                    }
                } else {
                    Preconditions.checkNotEmpty((String)transactionInfo.zzb, (Object)"An estimated total price must be set if totalPriceStatus is set to WalletConstants.TOTAL_PRICE_STATUS_ESTIMATED!");
                }
            }
            transactionInfo = ((Builder)this_).TransactionInfo.this;
            if (transactionInfo.zza == 3) {
                Preconditions.checkNotEmpty((String)transactionInfo.zzb, (Object)"An final total price must be set if totalPriceStatus is set to WalletConstants.TOTAL_PRICE_STATUS_FINAL!");
            }
            return ((Builder)this_).TransactionInfo.this;
        }

        /* synthetic */ Builder(zzah zzah2) {
        }
    }
}

