/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.wallet.CardRequirements;
import com.google.android.gms.wallet.PaymentMethodTokenizationParameters;
import com.google.android.gms.wallet.ShippingAddressRequirements;
import com.google.android.gms.wallet.TransactionInfo;
import com.google.android.gms.wallet.zzw;
import com.google.android.gms.wallet.zzx;
import java.util.ArrayList;
import java.util.Collection;

@SafeParcelable.Class(creator="PaymentDataRequestCreator")
public final class PaymentDataRequest
extends AbstractSafeParcelable {
    @NonNull
    public static final Parcelable.Creator<PaymentDataRequest> CREATOR;
    @SafeParcelable.Field(id=1)
    boolean zza;
    @SafeParcelable.Field(id=2)
    boolean zzb;
    @SafeParcelable.Field(id=3)
    CardRequirements zzc;
    @SafeParcelable.Field(id=4)
    boolean zzd;
    @SafeParcelable.Field(id=5)
    ShippingAddressRequirements zze;
    @SafeParcelable.Field(id=6)
    ArrayList<Integer> zzf;
    @SafeParcelable.Field(id=7)
    PaymentMethodTokenizationParameters zzg;
    @SafeParcelable.Field(id=8)
    TransactionInfo zzh;
    @SafeParcelable.Field(id=9, defaultValue="true")
    boolean zzi;
    @SafeParcelable.Field(id=10)
    String zzj;
    @SafeParcelable.Field(id=11)
    @Nullable
    Bundle zzk;

    @Nullable
    public Bundle getSavedState() {
        return this.zzk;
    }

    @Deprecated
    @Nullable
    public CardRequirements getCardRequirements() {
        return this.zzc;
    }

    @Deprecated
    @NonNull
    public static Builder newBuilder() {
        PaymentDataRequest paymentDataRequest = new PaymentDataRequest();
        Builder builder = paymentDataRequest.new Builder(null);
        return builder;
    }

    @NonNull
    public static PaymentDataRequest fromJson(@NonNull String paymentDataRequestJson) {
        Object object;
        Builder builder = PaymentDataRequest.newBuilder();
        object = Preconditions.checkNotNull((Object)object, (Object)"paymentDataRequestJson cannot be null!");
        builder.PaymentDataRequest.this.zzj = object = (String)object;
        return builder.build();
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public PaymentDataRequest withSavedState(@Nullable Bundle savedState) {
        void var1_1;
        this.zzk = var1_1;
        return this;
    }

    @Deprecated
    @NonNull
    public PaymentMethodTokenizationParameters getPaymentMethodTokenizationParameters() {
        return this.zzg;
    }

    @Deprecated
    @Nullable
    public ShippingAddressRequirements getShippingAddressRequirements() {
        return this.zze;
    }

    @Deprecated
    @NonNull
    public TransactionInfo getTransactionInfo() {
        return this.zzh;
    }

    @NonNull
    public String toJson() {
        return this.zzj;
    }

    @Deprecated
    @NonNull
    public ArrayList<Integer> getAllowedPaymentMethods() {
        return this.zzf;
    }

    static {
        zzx zzx2;
        CREATOR = zzx2 = new zzx();
    }

    private PaymentDataRequest() {
        this.zzi = true;
    }

    @SafeParcelable.Constructor
    PaymentDataRequest(@SafeParcelable.Param(id=1) boolean bl, @SafeParcelable.Param(id=2) boolean bl2, @SafeParcelable.Param(id=3) CardRequirements cardRequirements, @SafeParcelable.Param(id=4) boolean bl3, @SafeParcelable.Param(id=5) ShippingAddressRequirements shippingAddressRequirements, @SafeParcelable.Param(id=6) ArrayList<Integer> arrayList, @SafeParcelable.Param(id=7) PaymentMethodTokenizationParameters paymentMethodTokenizationParameters, @SafeParcelable.Param(id=8) TransactionInfo transactionInfo, @SafeParcelable.Param(id=9) boolean bl4, @SafeParcelable.Param(id=10) String string, @SafeParcelable.Param(id=11) @Nullable Bundle bundle) {
        this.zza = bl;
        this.zzb = bl2;
        this.zzc = cardRequirements;
        this.zzd = bl3;
        this.zze = shippingAddressRequirements;
        this.zzf = arrayList;
        this.zzg = paymentMethodTokenizationParameters;
        this.zzh = transactionInfo;
        this.zzi = bl4;
        this.zzj = string;
        this.zzk = bundle;
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        void var2_2;
        void var1_1;
        int n = SafeParcelWriter.beginObjectHeader((Parcel)dest);
        SafeParcelWriter.writeBoolean((Parcel)var1_1, (int)1, (boolean)this.zza);
        SafeParcelWriter.writeBoolean((Parcel)var1_1, (int)2, (boolean)this.zzb);
        SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)3, (Parcelable)this.zzc, (int)var2_2, (boolean)false);
        SafeParcelWriter.writeBoolean((Parcel)var1_1, (int)4, (boolean)this.zzd);
        SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)5, (Parcelable)this.zze, (int)var2_2, (boolean)false);
        SafeParcelWriter.writeIntegerList((Parcel)var1_1, (int)6, this.zzf, (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)7, (Parcelable)this.zzg, (int)var2_2, (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)8, (Parcelable)this.zzh, (int)var2_2, (boolean)false);
        SafeParcelWriter.writeBoolean((Parcel)var1_1, (int)9, (boolean)this.zzi);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)10, (String)this.zzj, (boolean)false);
        SafeParcelWriter.writeBundle((Parcel)var1_1, (int)11, (Bundle)this.zzk, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)var1_1, (int)n);
    }

    @Deprecated
    public boolean isEmailRequired() {
        return this.zza;
    }

    @Deprecated
    public boolean isPhoneNumberRequired() {
        return this.zzb;
    }

    @Deprecated
    public boolean isShippingAddressRequired() {
        return this.zzd;
    }

    @Deprecated
    public boolean isUiRequired() {
        return this.zzi;
    }

    @Deprecated
    public final class Builder {
        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder addAllowedPaymentMethod(int allowedPaymentMethod) {
            void var1_1;
            PaymentDataRequest paymentDataRequest = PaymentDataRequest.this;
            if (paymentDataRequest.zzf == null) {
                ArrayList arrayList = new ArrayList();
                paymentDataRequest.zzf = arrayList;
            }
            PaymentDataRequest.this.zzf.add((int)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        @NonNull
        public Builder addAllowedPaymentMethods(@NonNull Collection<Integer> allowedPaymentMethods) {
            void var1_1;
            boolean bl = allowedPaymentMethods != null ? !var1_1.isEmpty() : false;
            Preconditions.checkArgument((boolean)bl, (Object)"allowedPaymentMethods can't be null or empty!");
            PaymentDataRequest paymentDataRequest = PaymentDataRequest.this;
            if (paymentDataRequest.zzf == null) {
                ArrayList arrayList = new ArrayList();
                paymentDataRequest.zzf = arrayList;
            }
            PaymentDataRequest.this.zzf.addAll((Collection<Integer>)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setCardRequirements(@NonNull CardRequirements cardRequirements) {
            void var1_1;
            PaymentDataRequest.this.zzc = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setEmailRequired(boolean emailRequired) {
            void var1_1;
            PaymentDataRequest.this.zza = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setPaymentMethodTokenizationParameters(@NonNull PaymentMethodTokenizationParameters paymentMethodTokenizationParameters) {
            void var1_1;
            PaymentDataRequest.this.zzg = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setPhoneNumberRequired(boolean phoneNumberRequired) {
            void var1_1;
            PaymentDataRequest.this.zzb = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setShippingAddressRequired(boolean shippingAddressRequired) {
            void var1_1;
            PaymentDataRequest.this.zzd = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setShippingAddressRequirements(@NonNull ShippingAddressRequirements shippingAddressRequirements) {
            void var1_1;
            PaymentDataRequest.this.zze = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setTransactionInfo(@NonNull TransactionInfo transactionInfo) {
            void var1_1;
            PaymentDataRequest.this.zzh = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setUiRequired(boolean uiRequired) {
            void var1_1;
            PaymentDataRequest.this.zzi = var1_1;
            return this;
        }

        @NonNull
        public PaymentDataRequest build() {
            PaymentDataRequest paymentDataRequest = PaymentDataRequest.this;
            if (paymentDataRequest.zzj == null) {
                Preconditions.checkNotNull(paymentDataRequest.zzf, (Object)"Allowed payment methods must be set! You can set it through addAllowedPaymentMethod() or addAllowedPaymentMethods() in the PaymentDataRequest Builder.");
                Preconditions.checkNotNull((Object)((Object)PaymentDataRequest.this.zzc), (Object)"Card requirements must be set!");
                paymentDataRequest = PaymentDataRequest.this;
                if (paymentDataRequest.zzg != null) {
                    Preconditions.checkNotNull((Object)((Object)paymentDataRequest.zzh), (Object)"Transaction info must be set if paymentMethodTokenizationParameters is set!");
                }
            }
            return PaymentDataRequest.this;
        }

        /* synthetic */ Builder(zzw zzw2) {
        }
    }
}

