/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.wallet;

import android.accounts.Account;
import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.Looper;
import android.os.Parcelable;
import android.os.RemoteException;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.Nullable;
import com.google.android.gms.common.Feature;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.ClientSettings;
import com.google.android.gms.common.internal.GmsClient;
import com.google.android.gms.internal.wallet.zzaa;
import com.google.android.gms.internal.wallet.zzs;
import com.google.android.gms.internal.wallet.zzw;
import com.google.android.gms.internal.wallet.zzx;
import com.google.android.gms.internal.wallet.zzy;
import com.google.android.gms.internal.wallet.zzz;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.android.gms.wallet.AutoResolvableVoidResult;
import com.google.android.gms.wallet.CreateWalletObjectsRequest;
import com.google.android.gms.wallet.IsReadyToPayRequest;
import com.google.android.gms.wallet.PaymentData;
import com.google.android.gms.wallet.PaymentDataRequest;
import com.google.android.gms.wallet.zzj;

public final class zzab
extends GmsClient<zzs> {
    private final Context zze;
    private final int zzf;
    @Nullable
    private final String zzg;
    private final int zzh;
    private final boolean zzi;

    public final int getMinApkVersion() {
        return 12600000;
    }

    private final Bundle zzt() {
        int n = this.zzf;
        Object object = this.zze;
        object = object.getPackageName();
        String string = this.zzg;
        int n2 = this.zzh;
        boolean bl = this.zzi;
        Bundle bundle = new Bundle();
        bundle.putInt("com.google.android.gms.wallet.EXTRA_ENVIRONMENT", n);
        bundle.putBoolean("com.google.android.gms.wallet.EXTRA_USING_ANDROID_PAY_BRAND", bl);
        bundle.putString("androidPackageName", (String)object);
        if (!TextUtils.isEmpty((CharSequence)string)) {
            Account account = new Account(string, "com.google");
            bundle.putParcelable("com.google.android.gms.wallet.EXTRA_BUYER_ACCOUNT", (Parcelable)account);
        }
        bundle.putInt("com.google.android.gms.wallet.EXTRA_THEME", n2);
        return bundle;
    }

    protected final String getServiceDescriptor() {
        return "com.google.android.gms.wallet.internal.IOwService";
    }

    protected final String getStartServiceAction() {
        return "com.google.android.gms.wallet.service.BIND";
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public zzab(Context object, Looper looper, ClientSettings clientSettings, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener, int n, int n2, boolean bl) {
        super(object, (Looper)var2_6, 4, (ClientSettings)var3_7, (GoogleApiClient.ConnectionCallbacks)var4_8, (GoogleApiClient.OnConnectionFailedListener)var5_9);
        void var8_12;
        void var7_11;
        void var1_4;
        void var6_10;
        void var5_9;
        void var4_8;
        void var3_7;
        void var2_6;
        this.zze = object;
        this.zzf = var6_10;
        Account account = var3_7.getAccount();
        if (account != null) {
            String string = account.name;
        } else {
            Object var1_5 = null;
        }
        this.zzg = var1_4;
        this.zzh = var7_11;
        this.zzi = var8_12;
    }

    public final void zzp(CreateWalletObjectsRequest createWalletObjectsRequest, int n) {
        zzw zzw2 = new zzw((Activity)this.zze, n);
        Bundle bundle = this.zzt();
        try {
            ((zzs)this.getService()).zzc(createWalletObjectsRequest, bundle, zzw2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e((String)"WalletClientImpl", (String)"RemoteException creating wallet objects", (Throwable)remoteException);
            ((zzx)zzw2).zzg(8, Bundle.EMPTY);
            return;
        }
    }

    public final void zzq(CreateWalletObjectsRequest createWalletObjectsRequest, TaskCompletionSource<AutoResolvableVoidResult> taskCompletionSource) {
        Bundle bundle = this.zzt();
        bundle.putBoolean("com.google.android.gms.wallet.EXTRA_USING_AUTO_RESOLVABLE_RESULT", true);
        zzz zzz2 = new zzz(taskCompletionSource);
        try {
            ((zzs)this.getService()).zzc(createWalletObjectsRequest, bundle, zzz2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e((String)"WalletClientImpl", (String)"RemoteException creating wallet objects", (Throwable)remoteException);
            ((zzx)zzz2).zzg(8, Bundle.EMPTY);
            return;
        }
    }

    public final void zzr(IsReadyToPayRequest isReadyToPayRequest, TaskCompletionSource<Boolean> taskCompletionSource) throws RemoteException {
        zzy zzy2 = new zzy(taskCompletionSource);
        try {
            ((zzs)this.getService()).zzd(isReadyToPayRequest, this.zzt(), zzy2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e((String)"WalletClientImpl", (String)"RemoteException during isReadyToPay", (Throwable)remoteException);
            ((zzx)zzy2).zzc(Status.RESULT_INTERNAL_ERROR, false, Bundle.EMPTY);
            return;
        }
    }

    public final void zzs(PaymentDataRequest paymentDataRequest, TaskCompletionSource<PaymentData> taskCompletionSource) {
        Bundle bundle = this.zzt();
        bundle.putBoolean("com.google.android.gms.wallet.EXTRA_USING_AUTO_RESOLVABLE_RESULT", true);
        zzaa zzaa2 = new zzaa(taskCompletionSource);
        try {
            ((zzs)this.getService()).zze(paymentDataRequest, bundle, zzaa2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e((String)"WalletClientImpl", (String)"RemoteException getting payment data", (Throwable)remoteException);
            ((zzx)zzaa2).zze(Status.RESULT_INTERNAL_ERROR, null, Bundle.EMPTY);
            return;
        }
    }

    public final boolean requiresAccount() {
        return true;
    }

    public final boolean usesClientTelemetry() {
        return true;
    }

    public final Feature[] getApiFeatures() {
        return zzj.zzg;
    }
}

