/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet;

import android.app.Activity;
import android.app.Fragment;
import android.app.PendingIntent;
import android.content.Intent;
import android.content.IntentSender;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcelable;
import android.os.SystemClock;
import android.util.Log;
import android.util.SparseArray;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.common.api.ApiException;
import com.google.android.gms.common.api.ResolvableApiException;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.ApiExceptionUtil;
import com.google.android.gms.internal.wallet.zzi;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.android.gms.wallet.AutoResolvableResult;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class AutoResolveHelper {
    private static final long zzu = TimeUnit.MINUTES.toMillis(10L);
    @VisibleForTesting
    static long zzv = SystemClock.elapsedRealtime();
    public static final int RESULT_ERROR = 1;

    private AutoResolveHelper() {
    }

    @MainThread
    public static <TResult extends AutoResolvableResult> void resolveTask(@NonNull Task<TResult> task, @NonNull Activity activity, int n) {
        zzb<TResult> zzb2 = zzb.zzb(task);
        int n2 = zzb2.zzag;
        activity.getFragmentManager().beginTransaction().add(zza.zza(zzb2.zzag, n), new StringBuilder(58).append("com.google.android.gms.wallet.AutoResolveHelper").append(n2).toString()).commit();
    }

    @Nullable
    public static Status getStatusFromIntent(@Nullable Intent intent) {
        if (intent == null) {
            return null;
        }
        return (Status)intent.getParcelableExtra("com.google.android.gms.common.api.AutoResolveHelper.status");
    }

    public static void putStatusIntoIntent(@NonNull Intent intent, @Nullable Status status) {
        if (status == null) {
            intent.removeExtra("com.google.android.gms.common.api.AutoResolveHelper.status");
            return;
        }
        intent.putExtra("com.google.android.gms.common.api.AutoResolveHelper.status", (Parcelable)status);
    }

    public static <TResult> void zza(Status status, TResult TResult, TaskCompletionSource<TResult> taskCompletionSource) {
        if (status.isSuccess()) {
            taskCompletionSource.setResult(TResult);
            return;
        }
        taskCompletionSource.setException((Exception)ApiExceptionUtil.fromStatus((Status)status));
    }

    private static void zza(Activity activity, int n, Task<? extends AutoResolvableResult> task) {
        if (activity.isFinishing()) {
            if (Log.isLoggable((String)"AutoResolveHelper", (int)3)) {
                Log.d((String)"AutoResolveHelper", (String)"Ignoring task result for, Activity is finishing.");
                return;
            }
        } else {
            int n2;
            if (task.getException() instanceof ResolvableApiException) {
                ResolvableApiException resolvableApiException = (ResolvableApiException)task.getException();
                try {
                    resolvableApiException.startResolutionForResult(activity, n);
                    return;
                }
                catch (IntentSender.SendIntentException sendIntentException) {
                    if (Log.isLoggable((String)"AutoResolveHelper", (int)6)) {
                        Log.e((String)"AutoResolveHelper", (String)"Error starting pending intent!", (Throwable)sendIntentException);
                    }
                    return;
                }
            }
            Intent intent = new Intent();
            if (task.isSuccessful()) {
                n2 = -1;
                ((AutoResolvableResult)task.getResult()).putIntoIntent(intent);
            } else if (task.getException() instanceof ApiException) {
                ApiException apiException = (ApiException)task.getException();
                n2 = 1;
                AutoResolveHelper.putStatusIntoIntent(intent, new Status(apiException.getStatusCode(), apiException.getMessage(), null));
            } else {
                if (Log.isLoggable((String)"AutoResolveHelper", (int)6)) {
                    Log.e((String)"AutoResolveHelper", (String)"Unexpected non API exception!", (Throwable)task.getException());
                }
                n2 = 1;
                AutoResolveHelper.putStatusIntoIntent(intent, new Status(8, "Unexpected non API exception when trying to deliver the task result to an activity!"));
            }
            AutoResolveHelper.zza(activity, n, n2, intent);
        }
    }

    private static void zza(Activity activity, int n, int n2, Intent intent) {
        block5: {
            PendingIntent pendingIntent = activity.createPendingResult(n, intent, 0x40000000);
            if (pendingIntent == null) {
                if (Log.isLoggable((String)"AutoResolveHelper", (int)5)) {
                    Log.w((String)"AutoResolveHelper", (String)"Null pending result returned when trying to deliver task result!");
                    return;
                }
            } else {
                try {
                    pendingIntent.send(n2);
                    return;
                }
                catch (PendingIntent.CanceledException canceledException) {
                    if (!Log.isLoggable((String)"AutoResolveHelper", (int)6)) break block5;
                    Log.e((String)"AutoResolveHelper", (String)"Exception sending pending result", (Throwable)canceledException);
                }
            }
        }
    }

    @VisibleForTesting
    static final class zzb<TResult extends AutoResolvableResult>
    implements OnCompleteListener<TResult>,
    Runnable {
        @VisibleForTesting
        private static final Handler zzad = new zzi(Looper.getMainLooper());
        @VisibleForTesting
        static final SparseArray<zzb<?>> zzae = new SparseArray(2);
        private static final AtomicInteger zzaf = new AtomicInteger();
        int zzag;
        private zza zzah;
        private Task<TResult> zzai;

        zzb() {
        }

        public static <TResult extends AutoResolvableResult> zzb<TResult> zzb(Task<TResult> task) {
            zzb<TResult> zzb2 = new zzb<TResult>();
            new zzb<TResult>().zzag = zzaf.incrementAndGet();
            zzae.put(zzb2.zzag, zzb2);
            zzad.postDelayed(zzb2, zzu);
            task.addOnCompleteListener(zzb2);
            return zzb2;
        }

        public final void zza(zza zza2) {
            this.zzah = zza2;
            this.zzd();
        }

        public final void zzb(zza zza2) {
            if (this.zzah == zza2) {
                this.zzah = null;
            }
        }

        public final void onComplete(@NonNull Task<TResult> task) {
            this.zzai = task;
            this.zzd();
        }

        @Override
        public final void run() {
            zzae.delete(this.zzag);
        }

        private final void zzd() {
            if (this.zzai != null && this.zzah != null) {
                zzae.delete(this.zzag);
                zzad.removeCallbacks((Runnable)this);
                this.zzah.zza((Task<? extends AutoResolvableResult>)this.zzai);
            }
        }
    }

    public static final class zza
    extends Fragment {
        private static String zzw = "resolveCallId";
        private static String zzx = "requestCode";
        private static String zzy = "initializationElapsedRealtime";
        private static String zzz = "delivered";
        private int zzaa;
        private zzb<?> zzab;
        @VisibleForTesting
        private boolean zzac;

        private static Fragment zza(int n, int n2) {
            Bundle bundle = new Bundle();
            bundle.putInt(zzw, n);
            bundle.putInt(zzx, n2);
            bundle.putLong(zzy, zzv);
            zza zza2 = new zza();
            zza2.setArguments(bundle);
            return zza2;
        }

        public final void onCreate(@Nullable Bundle bundle) {
            super.onCreate(bundle);
            this.zzaa = this.getArguments().getInt(zzx);
            if (zzv != this.getArguments().getLong(zzy)) {
                this.zzab = null;
            } else {
                int n = this.getArguments().getInt(zzw);
                this.zzab = (zzb)zzb.zzae.get(n);
            }
            this.zzac = bundle != null && bundle.getBoolean(zzz);
        }

        public final void onResume() {
            super.onResume();
            zza zza2 = this;
            if (zza2.zzab != null) {
                zza2.zzab.zza(zza2);
                return;
            }
            if (Log.isLoggable((String)"AutoResolveHelper", (int)5)) {
                Log.w((String)"AutoResolveHelper", (String)"Sending canceled result for garbage collected task!");
            }
            zza2.zza(null);
        }

        public final void onSaveInstanceState(Bundle bundle) {
            super.onSaveInstanceState(bundle);
            bundle.putBoolean(zzz, this.zzac);
            this.zzc();
        }

        public final void onPause() {
            super.onPause();
            this.zzc();
        }

        private final void zzc() {
            if (this.zzab != null) {
                this.zzab.zzb(this);
            }
        }

        private final void zza(@Nullable Task<? extends AutoResolvableResult> task) {
            if (!this.zzac) {
                this.zzac = true;
                Activity activity = this.getActivity();
                activity.getFragmentManager().beginTransaction().remove((Fragment)this).commit();
                if (task != null) {
                    AutoResolveHelper.zza(activity, this.zzaa, (Task<? extends AutoResolvableResult>)task);
                    return;
                }
                AutoResolveHelper.zza(activity, this.zzaa, 0, new Intent());
            }
        }
    }
}

