/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet.callback;

import android.content.Intent;
import android.os.IBinder;
import androidx.annotation.CallSuper;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelableSerializer;
import com.google.android.gms.wallet.PaymentData;
import com.google.android.gms.wallet.callback.BasePaymentDataCallbacks;
import com.google.android.gms.wallet.callback.CallbackInput;
import com.google.android.gms.wallet.callback.CallbackOutput;
import com.google.android.gms.wallet.callback.IntermediatePaymentData;
import com.google.android.gms.wallet.callback.OnCompleteListener;
import com.google.android.gms.wallet.callback.PaymentAuthorizationResult;
import com.google.android.gms.wallet.callback.PaymentDataRequestUpdate;

public abstract class BasePaymentDataCallbacksService
extends com.google.android.gms.wallet.callback.zzb {
    @Override
    protected final void onRunTask(String string, CallbackInput callbackInput, OnCompleteListener<CallbackOutput> onCompleteListener) {
        if (callbackInput.getCallbackType() != 0) {
            BasePaymentDataCallbacks basePaymentDataCallbacks = this.createPaymentDataCallbacks();
            if (callbackInput.getCallbackType() == 1) {
                PaymentData paymentData = callbackInput.deserializeRequest(PaymentData.CREATOR);
                basePaymentDataCallbacks.onPaymentAuthorized(paymentData, new zzb(onCompleteListener));
                return;
            }
            if (callbackInput.getCallbackType() == 2) {
                IntermediatePaymentData intermediatePaymentData = callbackInput.deserializeRequest(IntermediatePaymentData.CREATOR);
                basePaymentDataCallbacks.onPaymentDataChanged(intermediatePaymentData, new zza(onCompleteListener));
                return;
            }
            throw new IllegalStateException("Unknown Callback Types");
        }
        throw new IllegalStateException("Callback Types must be set");
    }

    protected abstract BasePaymentDataCallbacks createPaymentDataCallbacks();

    @Override
    @CallSuper
    public IBinder onBind(Intent intent) {
        return super.onBind(intent);
    }

    private static final class zza
    implements OnCompleteListener<PaymentDataRequestUpdate> {
        private final OnCompleteListener<CallbackOutput> zzeq;

        zza(OnCompleteListener<CallbackOutput> onCompleteListener) {
            this.zzeq = onCompleteListener;
        }

        private final synchronized void zza(PaymentDataRequestUpdate paymentDataRequestUpdate) {
            this.zzeq.complete(CallbackOutput.zzd().zza((int)2).zzb((int)1).zza((byte[])SafeParcelableSerializer.serializeToBytes((SafeParcelable)paymentDataRequestUpdate)).zzex);
        }

        @Override
        public final /* synthetic */ void complete(Object object) {
            this.zza((PaymentDataRequestUpdate)((Object)object));
        }
    }

    private static final class zzb
    implements OnCompleteListener<PaymentAuthorizationResult> {
        private final OnCompleteListener<CallbackOutput> zzeq;

        zzb(OnCompleteListener<CallbackOutput> onCompleteListener) {
            this.zzeq = onCompleteListener;
        }

        private final synchronized void zza(PaymentAuthorizationResult paymentAuthorizationResult) {
            this.zzeq.complete(CallbackOutput.zzd().zza((int)1).zzb((int)1).zza((byte[])SafeParcelableSerializer.serializeToBytes((SafeParcelable)paymentAuthorizationResult)).zzex);
        }

        @Override
        public final /* synthetic */ void complete(Object object) {
            this.zza((PaymentAuthorizationResult)((Object)object));
        }
    }
}

