/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet;

import android.accounts.Account;
import android.app.Activity;
import android.content.Context;
import android.os.RemoteException;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.BaseImplementation;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.ShowFirstParty;
import com.google.android.gms.internal.wallet.zzac;
import com.google.android.gms.internal.wallet.zzg;
import com.google.android.gms.internal.wallet.zzt;
import com.google.android.gms.internal.wallet.zzu;
import com.google.android.gms.wallet.PaymentsClient;
import com.google.android.gms.wallet.WalletObjectsClient;
import com.google.android.gms.wallet.wobs.WalletObjects;
import com.google.android.gms.wallet.zzaj;
import com.google.android.gms.wallet.zzz;
import java.util.Locale;

public final class Wallet {
    private static final Api.ClientKey<zzt> CLIENT_KEY = new Api.ClientKey();
    private static final Api.AbstractClientBuilder<zzt, WalletOptions> zzed = new zzaj();
    public static final Api<WalletOptions> API = new Api("Wallet.API", zzed, CLIENT_KEY);
    @Deprecated
    private static final zzz zzee = new zzu();
    private static final WalletObjects zzef = new zzac();
    @ShowFirstParty
    private static final zzg zzeg = new com.google.android.gms.internal.wallet.zzz();

    public static PaymentsClient getPaymentsClient(@NonNull Activity activity, @NonNull WalletOptions walletOptions) {
        return new PaymentsClient(activity, walletOptions);
    }

    public static PaymentsClient getPaymentsClient(@NonNull Context context, @NonNull WalletOptions walletOptions) {
        return new PaymentsClient(context, walletOptions);
    }

    public static WalletObjectsClient getWalletObjectsClient(@NonNull Activity activity, @Nullable WalletOptions walletOptions) {
        return new WalletObjectsClient(activity, walletOptions);
    }

    private Wallet() {
    }

    public static abstract class zzb
    extends zza<Status> {
        public zzb(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        protected /* synthetic */ Result createFailedResult(Status status) {
            return status;
        }
    }

    public static abstract class zza<R extends Result>
    extends BaseImplementation.ApiMethodImpl<R, zzt> {
        public zza(GoogleApiClient googleApiClient) {
            super(API, googleApiClient);
        }

        @VisibleForTesting
        protected abstract void zza(zzt var1) throws RemoteException;

        @VisibleForTesting
        protected /* synthetic */ void doExecute(Api.AnyClient anyClient) throws RemoteException {
            this.zza((zzt)anyClient);
        }
    }

    public static final class WalletOptions
    implements Api.ApiOptions.HasAccountOptions {
        public final int environment;
        public final int theme;
        @ShowFirstParty
        private final Account account;
        @VisibleForTesting
        final boolean zzeh;

        private WalletOptions() {
            this(new Builder());
        }

        private WalletOptions(Builder builder) {
            this.environment = builder.environment;
            this.theme = builder.theme;
            this.zzeh = builder.zzeh;
            this.account = null;
        }

        public final Account getAccount() {
            return null;
        }

        public final boolean equals(Object object) {
            boolean bl = false;
            if (object instanceof WalletOptions) {
                WalletOptions walletOptions = (WalletOptions)object;
                bl = Objects.equal((Object)this.environment, (Object)walletOptions.environment) && Objects.equal((Object)this.theme, (Object)walletOptions.theme) && Objects.equal(null, null) && Objects.equal((Object)this.zzeh, (Object)walletOptions.zzeh);
            }
            return bl;
        }

        public final int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.environment, this.theme, null, this.zzeh});
        }

        /* synthetic */ WalletOptions(Builder builder, zzaj zzaj2) {
            this(builder);
        }

        /* synthetic */ WalletOptions(zzaj zzaj2) {
            this();
        }

        public static final class Builder {
            private int environment = 3;
            private int theme = 1;
            private boolean zzeh = true;

            public final Builder setEnvironment(int n) {
                if (n != 0 && n != 0 && n != 2 && n != 1 && n != 23 && n != 3) {
                    String string = String.format(Locale.US, "Invalid environment value %d", n);
                    throw new IllegalArgumentException(string);
                }
                this.environment = n;
                return this;
            }

            public final Builder setTheme(int n) {
                if (n != 0 && n != 1 && n != 2 && n != 3) {
                    String string = String.format(Locale.US, "Invalid theme value %d", n);
                    throw new IllegalArgumentException(string);
                }
                this.theme = n;
                return this;
            }

            @Deprecated
            public final Builder useGoogleWallet() {
                this.zzeh = false;
                return this;
            }

            public final WalletOptions build() {
                return new WalletOptions(this, null);
            }
        }
    }
}

