/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.wallet.CardRequirements;
import com.google.android.gms.wallet.PaymentMethodTokenizationParameters;
import com.google.android.gms.wallet.ShippingAddressRequirements;
import com.google.android.gms.wallet.TransactionInfo;
import com.google.android.gms.wallet.zzv;
import com.google.android.gms.wallet.zzw;
import java.util.ArrayList;
import java.util.Collection;

@SafeParcelable.Class(creator="PaymentDataRequestCreator")
public final class PaymentDataRequest
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<PaymentDataRequest> CREATOR = new zzw();
    @SafeParcelable.Field(id=1)
    boolean zzde;
    @SafeParcelable.Field(id=2)
    boolean zzdf;
    @SafeParcelable.Field(id=3)
    CardRequirements zzdg;
    @SafeParcelable.Field(id=4)
    boolean zzdh;
    @SafeParcelable.Field(id=5)
    ShippingAddressRequirements zzdi;
    @SafeParcelable.Field(id=6)
    ArrayList<Integer> zzbv;
    @SafeParcelable.Field(id=7)
    PaymentMethodTokenizationParameters zzdj;
    @SafeParcelable.Field(id=8)
    TransactionInfo zzdk;
    @SafeParcelable.Field(id=9, defaultValue="true")
    boolean zzdl;
    @SafeParcelable.Field(id=10)
    String zzbx;
    @SafeParcelable.Field(id=11)
    private Bundle zzdc;

    @SafeParcelable.Constructor
    PaymentDataRequest(@SafeParcelable.Param(id=1) boolean bl, @SafeParcelable.Param(id=2) boolean bl2, @SafeParcelable.Param(id=3) CardRequirements cardRequirements, @SafeParcelable.Param(id=4) boolean bl3, @SafeParcelable.Param(id=5) ShippingAddressRequirements shippingAddressRequirements, @SafeParcelable.Param(id=6) ArrayList<Integer> arrayList, @SafeParcelable.Param(id=7) PaymentMethodTokenizationParameters paymentMethodTokenizationParameters, @SafeParcelable.Param(id=8) TransactionInfo transactionInfo, @SafeParcelable.Param(id=9) boolean bl4, @SafeParcelable.Param(id=10) String string, @SafeParcelable.Param(id=11) Bundle bundle) {
        this.zzde = bl;
        this.zzdf = bl2;
        this.zzdg = cardRequirements;
        this.zzdh = bl3;
        this.zzdi = shippingAddressRequirements;
        this.zzbv = arrayList;
        this.zzdj = paymentMethodTokenizationParameters;
        this.zzdk = transactionInfo;
        this.zzdl = bl4;
        this.zzbx = string;
        this.zzdc = bundle;
    }

    private PaymentDataRequest() {
        this.zzdl = true;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        PaymentDataRequest paymentDataRequest = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)1, (boolean)paymentDataRequest.zzde);
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)2, (boolean)paymentDataRequest.zzdf);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)3, (Parcelable)paymentDataRequest.zzdg, (int)n, (boolean)false);
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)4, (boolean)paymentDataRequest.zzdh);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)5, (Parcelable)paymentDataRequest.zzdi, (int)n, (boolean)false);
        SafeParcelWriter.writeIntegerList((Parcel)parcel2, (int)6, paymentDataRequest.zzbv, (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)7, (Parcelable)paymentDataRequest.zzdj, (int)n, (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)8, (Parcelable)paymentDataRequest.zzdk, (int)n, (boolean)false);
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)9, (boolean)paymentDataRequest.zzdl);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)10, (String)paymentDataRequest.zzbx, (boolean)false);
        SafeParcelWriter.writeBundle((Parcel)parcel2, (int)11, (Bundle)paymentDataRequest.zzdc, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    @Deprecated
    public final boolean isEmailRequired() {
        return this.zzde;
    }

    @Deprecated
    public final boolean isPhoneNumberRequired() {
        return this.zzdf;
    }

    @Deprecated
    @Nullable
    public final CardRequirements getCardRequirements() {
        return this.zzdg;
    }

    @Deprecated
    public final boolean isShippingAddressRequired() {
        return this.zzdh;
    }

    @Deprecated
    @Nullable
    public final ShippingAddressRequirements getShippingAddressRequirements() {
        return this.zzdi;
    }

    @Deprecated
    public final ArrayList<Integer> getAllowedPaymentMethods() {
        return this.zzbv;
    }

    @Deprecated
    public final PaymentMethodTokenizationParameters getPaymentMethodTokenizationParameters() {
        return this.zzdj;
    }

    @Deprecated
    public final TransactionInfo getTransactionInfo() {
        return this.zzdk;
    }

    @Deprecated
    public final boolean isUiRequired() {
        return this.zzdl;
    }

    @Deprecated
    public static Builder newBuilder() {
        return new PaymentDataRequest().new Builder(null);
    }

    public static PaymentDataRequest fromJson(String string) {
        String string2 = (String)Preconditions.checkNotNull((Object)string, (Object)"paymentDataRequestJson cannot be null!");
        Builder builder = PaymentDataRequest.newBuilder();
        PaymentDataRequest.newBuilder().PaymentDataRequest.this.zzbx = string2;
        return builder.build();
    }

    public final String toJson() {
        return this.zzbx;
    }

    public final PaymentDataRequest withSavedState(@Nullable Bundle bundle) {
        this.zzdc = bundle;
        return this;
    }

    @Nullable
    public final Bundle getSavedState() {
        return this.zzdc;
    }

    @Deprecated
    public final class Builder {
        private Builder() {
        }

        public final Builder setEmailRequired(boolean bl) {
            PaymentDataRequest.this.zzde = bl;
            return this;
        }

        public final Builder setPhoneNumberRequired(boolean bl) {
            PaymentDataRequest.this.zzdf = bl;
            return this;
        }

        public final Builder setCardRequirements(@NonNull CardRequirements cardRequirements) {
            PaymentDataRequest.this.zzdg = cardRequirements;
            return this;
        }

        public final Builder setShippingAddressRequired(boolean bl) {
            PaymentDataRequest.this.zzdh = bl;
            return this;
        }

        public final Builder setShippingAddressRequirements(@NonNull ShippingAddressRequirements shippingAddressRequirements) {
            PaymentDataRequest.this.zzdi = shippingAddressRequirements;
            return this;
        }

        public final Builder addAllowedPaymentMethod(int n) {
            if (PaymentDataRequest.this.zzbv == null) {
                PaymentDataRequest.this.zzbv = new ArrayList();
            }
            PaymentDataRequest.this.zzbv.add(n);
            return this;
        }

        public final Builder addAllowedPaymentMethods(@NonNull Collection<Integer> collection) {
            Preconditions.checkArgument((collection != null && !collection.isEmpty() ? 1 : 0) != 0, (Object)"allowedPaymentMethods can't be null or empty!");
            if (PaymentDataRequest.this.zzbv == null) {
                PaymentDataRequest.this.zzbv = new ArrayList();
            }
            PaymentDataRequest.this.zzbv.addAll(collection);
            return this;
        }

        public final Builder setPaymentMethodTokenizationParameters(PaymentMethodTokenizationParameters paymentMethodTokenizationParameters) {
            PaymentDataRequest.this.zzdj = paymentMethodTokenizationParameters;
            return this;
        }

        public final Builder setTransactionInfo(@NonNull TransactionInfo transactionInfo) {
            PaymentDataRequest.this.zzdk = transactionInfo;
            return this;
        }

        public final Builder setUiRequired(boolean bl) {
            PaymentDataRequest.this.zzdl = bl;
            return this;
        }

        public final PaymentDataRequest build() {
            if (PaymentDataRequest.this.zzbx == null) {
                Preconditions.checkNotNull(PaymentDataRequest.this.zzbv, (Object)"Allowed payment methods must be set! You can set it through addAllowedPaymentMethod() or addAllowedPaymentMethods() in the PaymentDataRequest Builder.");
                Preconditions.checkNotNull((Object)((Object)PaymentDataRequest.this.zzdg), (Object)"Card requirements must be set!");
                if (PaymentDataRequest.this.zzdj != null) {
                    Preconditions.checkNotNull((Object)((Object)PaymentDataRequest.this.zzdk), (Object)"Transaction info must be set if paymentMethodTokenizationParameters is set!");
                }
            }
            return PaymentDataRequest.this;
        }

        /* synthetic */ Builder(zzv zzv2) {
            this();
        }
    }
}

