/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet;

import android.app.Activity;
import android.app.Fragment;
import android.app.PendingIntent;
import android.content.Intent;
import android.content.IntentSender;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcelable;
import android.os.SystemClock;
import android.util.Log;
import android.util.SparseArray;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.common.api.ApiException;
import com.google.android.gms.common.api.ResolvableApiException;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.ApiExceptionUtil;
import com.google.android.gms.internal.wallet.zzf;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.android.gms.wallet.AutoResolvableResult;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class AutoResolveHelper {
    private static final long zzv = TimeUnit.MINUTES.toMillis(10L);
    @VisibleForTesting
    static long zzw = SystemClock.elapsedRealtime();
    public static final int RESULT_ERROR = 1;

    private AutoResolveHelper() {
    }

    @MainThread
    public static <TResult extends AutoResolvableResult> void resolveTask(@NonNull Task<TResult> task, @NonNull Activity activity, int n) {
        zza<TResult> zza2 = zza.zza(task);
        int n2 = zza2.zzs;
        activity.getFragmentManager().beginTransaction().add(zzb.zza(zza2.zzs, n), new StringBuilder(58).append("com.google.android.gms.wallet.AutoResolveHelper").append(n2).toString()).commit();
    }

    @Nullable
    public static Status getStatusFromIntent(@Nullable Intent intent) {
        if (intent == null) {
            return null;
        }
        return (Status)intent.getParcelableExtra("com.google.android.gms.common.api.AutoResolveHelper.status");
    }

    public static void putStatusIntoIntent(@NonNull Intent intent, @Nullable Status status) {
        if (status == null) {
            intent.removeExtra("com.google.android.gms.common.api.AutoResolveHelper.status");
            return;
        }
        intent.putExtra("com.google.android.gms.common.api.AutoResolveHelper.status", (Parcelable)status);
    }

    public static <TResult> void zza(Status status, TResult TResult, TaskCompletionSource<TResult> taskCompletionSource) {
        if (status.isSuccess()) {
            taskCompletionSource.setResult(TResult);
            return;
        }
        taskCompletionSource.setException((Exception)ApiExceptionUtil.fromStatus((Status)status));
    }

    private static void zza(Activity activity, int n, Task<? extends AutoResolvableResult> task) {
        if (activity.isFinishing()) {
            if (Log.isLoggable((String)"AutoResolveHelper", (int)3)) {
                Log.d((String)"AutoResolveHelper", (String)"Ignoring task result for, Activity is finishing.");
                return;
            }
        } else {
            int n2;
            if (task.getException() instanceof ResolvableApiException) {
                ResolvableApiException resolvableApiException = (ResolvableApiException)task.getException();
                try {
                    resolvableApiException.startResolutionForResult(activity, n);
                    return;
                }
                catch (IntentSender.SendIntentException sendIntentException) {
                    if (Log.isLoggable((String)"AutoResolveHelper", (int)6)) {
                        Log.e((String)"AutoResolveHelper", (String)"Error starting pending intent!", (Throwable)sendIntentException);
                    }
                    return;
                }
            }
            Intent intent = new Intent();
            if (task.isSuccessful()) {
                n2 = -1;
                ((AutoResolvableResult)task.getResult()).putIntoIntent(intent);
            } else if (task.getException() instanceof ApiException) {
                ApiException apiException = (ApiException)task.getException();
                n2 = 1;
                AutoResolveHelper.putStatusIntoIntent(intent, new Status(apiException.getStatusCode(), apiException.getMessage(), null));
            } else {
                if (Log.isLoggable((String)"AutoResolveHelper", (int)6)) {
                    Log.e((String)"AutoResolveHelper", (String)"Unexpected non API exception!", (Throwable)task.getException());
                }
                n2 = 1;
                AutoResolveHelper.putStatusIntoIntent(intent, new Status(8, "Unexpected non API exception when trying to deliver the task result to an activity!"));
            }
            AutoResolveHelper.zza(activity, n, n2, intent);
        }
    }

    private static void zza(Activity activity, int n, int n2, Intent intent) {
        block5: {
            PendingIntent pendingIntent = activity.createPendingResult(n, intent, 0x40000000);
            if (pendingIntent == null) {
                if (Log.isLoggable((String)"AutoResolveHelper", (int)5)) {
                    Log.w((String)"AutoResolveHelper", (String)"Null pending result returned when trying to deliver task result!");
                    return;
                }
            } else {
                try {
                    pendingIntent.send(n2);
                    return;
                }
                catch (PendingIntent.CanceledException canceledException) {
                    if (!Log.isLoggable((String)"AutoResolveHelper", (int)6)) break block5;
                    Log.e((String)"AutoResolveHelper", (String)"Exception sending pending result", (Throwable)canceledException);
                }
            }
        }
    }

    @VisibleForTesting
    static final class zza<TResult extends AutoResolvableResult>
    implements OnCompleteListener<TResult>,
    Runnable {
        @VisibleForTesting
        private static final Handler zzp = new zzf(Looper.getMainLooper());
        @VisibleForTesting
        static final SparseArray<zza<?>> zzq = new SparseArray(2);
        private static final AtomicInteger zzr = new AtomicInteger();
        int zzs;
        private zzb zzt;
        private Task<TResult> zzu;

        zza() {
        }

        public static <TResult extends AutoResolvableResult> zza<TResult> zza(Task<TResult> task) {
            zza<TResult> zza2 = new zza<TResult>();
            new zza<TResult>().zzs = zzr.incrementAndGet();
            zzq.put(zza2.zzs, zza2);
            zzp.postDelayed(zza2, zzv);
            task.addOnCompleteListener(zza2);
            return zza2;
        }

        public final void zza(zzb zzb2) {
            this.zzt = zzb2;
            this.zza();
        }

        public final void zzb(zzb zzb2) {
            if (this.zzt == zzb2) {
                this.zzt = null;
            }
        }

        public final void onComplete(@NonNull Task<TResult> task) {
            this.zzu = task;
            this.zza();
        }

        @Override
        public final void run() {
            zzq.delete(this.zzs);
        }

        private final void zza() {
            if (this.zzu != null && this.zzt != null) {
                zzq.delete(this.zzs);
                zzp.removeCallbacks((Runnable)this);
                this.zzt.zzb((Task<? extends AutoResolvableResult>)this.zzu);
            }
        }
    }

    public static final class zzb
    extends Fragment {
        private static String zzac = "resolveCallId";
        private static String zzad = "requestCode";
        private static String zzae = "initializationElapsedRealtime";
        private static String zzaf = "delivered";
        private int zzag;
        private zza<?> zzah;
        @VisibleForTesting
        private boolean zzai;

        private static Fragment zza(int n, int n2) {
            Bundle bundle = new Bundle();
            bundle.putInt(zzac, n);
            bundle.putInt(zzad, n2);
            bundle.putLong(zzae, zzw);
            zzb zzb2 = new zzb();
            zzb2.setArguments(bundle);
            return zzb2;
        }

        public final void onCreate(@Nullable Bundle bundle) {
            super.onCreate(bundle);
            this.zzag = this.getArguments().getInt(zzad);
            if (zzw != this.getArguments().getLong(zzae)) {
                this.zzah = null;
            } else {
                int n = this.getArguments().getInt(zzac);
                this.zzah = (zza)zza.zzq.get(n);
            }
            this.zzai = bundle != null && bundle.getBoolean(zzaf);
        }

        public final void onResume() {
            super.onResume();
            zzb zzb2 = this;
            if (zzb2.zzah != null) {
                zzb2.zzah.zza(zzb2);
                return;
            }
            if (Log.isLoggable((String)"AutoResolveHelper", (int)5)) {
                Log.w((String)"AutoResolveHelper", (String)"Sending canceled result for garbage collected task!");
            }
            zzb2.zzb(null);
        }

        public final void onSaveInstanceState(Bundle bundle) {
            super.onSaveInstanceState(bundle);
            bundle.putBoolean(zzaf, this.zzai);
            this.zzc();
        }

        public final void onPause() {
            super.onPause();
            this.zzc();
        }

        private final void zzc() {
            if (this.zzah != null) {
                this.zzah.zzb(this);
            }
        }

        private final void zzb(@Nullable Task<? extends AutoResolvableResult> task) {
            if (!this.zzai) {
                this.zzai = true;
                Activity activity = this.getActivity();
                activity.getFragmentManager().beginTransaction().remove((Fragment)this).commit();
                if (task != null) {
                    AutoResolveHelper.zza(activity, this.zzag, (Task<? extends AutoResolvableResult>)task);
                    return;
                }
                AutoResolveHelper.zza(activity, this.zzag, 0, new Intent());
            }
        }
    }
}

