/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet;

import android.content.Intent;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelableSerializer;
import com.google.android.gms.identity.intents.model.UserAddress;
import com.google.android.gms.wallet.AutoResolvableResult;
import com.google.android.gms.wallet.CardInfo;
import com.google.android.gms.wallet.PaymentMethodToken;
import com.google.android.gms.wallet.zzt;
import com.google.android.gms.wallet.zzu;

@SafeParcelable.Class(creator="PaymentDataCreator")
public final class PaymentData
extends AbstractSafeParcelable
implements AutoResolvableResult {
    public static final Parcelable.Creator<PaymentData> CREATOR = new zzu();
    @SafeParcelable.Field(id=1)
    private String zzaw;
    @SafeParcelable.Field(id=2)
    private CardInfo zzcz;
    @SafeParcelable.Field(id=3)
    private UserAddress zzda;
    @SafeParcelable.Field(id=4)
    private PaymentMethodToken zzbd;
    @SafeParcelable.Field(id=5)
    private String zzat;
    @SafeParcelable.Field(id=6)
    private Bundle zzdb;
    @SafeParcelable.Field(id=7)
    private String zzbx;
    @SafeParcelable.Field(id=8)
    private Bundle zzdc;

    @SafeParcelable.Constructor
    PaymentData(@SafeParcelable.Param(id=1) String string, @SafeParcelable.Param(id=2) CardInfo cardInfo, @SafeParcelable.Param(id=3) UserAddress userAddress, @SafeParcelable.Param(id=4) PaymentMethodToken paymentMethodToken, @SafeParcelable.Param(id=5) String string2, @SafeParcelable.Param(id=6) Bundle bundle, @SafeParcelable.Param(id=7) String string3, @SafeParcelable.Param(id=8) Bundle bundle2) {
        this.zzaw = string;
        this.zzcz = cardInfo;
        this.zzda = userAddress;
        this.zzbd = paymentMethodToken;
        this.zzat = string2;
        this.zzdb = bundle;
        this.zzbx = string3;
        this.zzdc = bundle2;
    }

    private PaymentData() {
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        PaymentData paymentData = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)1, (String)paymentData.zzaw, (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)2, (Parcelable)paymentData.zzcz, (int)n, (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)3, (Parcelable)paymentData.zzda, (int)n, (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)4, (Parcelable)paymentData.zzbd, (int)n, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)5, (String)paymentData.zzat, (boolean)false);
        SafeParcelWriter.writeBundle((Parcel)parcel2, (int)6, (Bundle)paymentData.zzdb, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)7, (String)paymentData.zzbx, (boolean)false);
        SafeParcelWriter.writeBundle((Parcel)parcel2, (int)8, (Bundle)paymentData.zzdc, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    @Deprecated
    @Nullable
    public final String getEmail() {
        return this.zzaw;
    }

    @Deprecated
    public final CardInfo getCardInfo() {
        return this.zzcz;
    }

    @Deprecated
    @Nullable
    public final UserAddress getShippingAddress() {
        return this.zzda;
    }

    @Deprecated
    @Nullable
    public final PaymentMethodToken getPaymentMethodToken() {
        return this.zzbd;
    }

    @Deprecated
    public final String getGoogleTransactionId() {
        return this.zzat;
    }

    @Deprecated
    @Nullable
    public final Bundle getExtraData() {
        return this.zzdb;
    }

    public static PaymentData fromJson(String string) {
        String string2 = (String)Preconditions.checkNotNull((Object)string, (Object)"paymentDataJson cannot be null!");
        zza zza2 = new PaymentData().new zza(null);
        new PaymentData().new zza(null).PaymentData.this.zzbx = string2;
        return zza2.PaymentData.this;
    }

    public final String toJson() {
        return this.zzbx;
    }

    public final PaymentData withLastSavedState(@Nullable Bundle bundle) {
        this.zzdc = bundle;
        return this;
    }

    @Nullable
    public final Bundle getLastSavedState() {
        return this.zzdc;
    }

    @Nullable
    public static PaymentData getFromIntent(@NonNull Intent intent) {
        return (PaymentData)SafeParcelableSerializer.deserializeFromIntentExtra((Intent)intent, (String)"com.google.android.gms.wallet.PaymentData", CREATOR);
    }

    @Override
    public final void putIntoIntent(@NonNull Intent intent) {
        SafeParcelableSerializer.serializeToIntentExtra((SafeParcelable)this, (Intent)intent, (String)"com.google.android.gms.wallet.PaymentData");
    }

    public final class zza {
        private zza() {
        }

        /* synthetic */ zza(zzt zzt2) {
            this();
        }
    }
}

