/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.wallet.wobs.CommonWalletObject;
import com.google.android.gms.wallet.wobs.LabelValueRow;
import com.google.android.gms.wallet.wobs.TextModuleData;
import com.google.android.gms.wallet.wobs.TimeInterval;
import com.google.android.gms.wallet.wobs.UriData;
import com.google.android.gms.wallet.wobs.WalletObjectMessage;
import com.google.android.gms.wallet.zzj;
import com.google.android.gms.wallet.zzk;
import java.util.ArrayList;
import java.util.Collection;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="GiftCardWalletObjectCreator")
public final class GiftCardWalletObject
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<GiftCardWalletObject> CREATOR = new zzk();
    @SafeParcelable.Field(id=2)
    CommonWalletObject zzbi = CommonWalletObject.zzf().zzg();
    @SafeParcelable.Field(id=3)
    String zzbj;
    @SafeParcelable.Field(id=4)
    String pin;
    @Deprecated
    @SafeParcelable.Field(id=5)
    String zzbk;
    @SafeParcelable.Field(id=6)
    long zzbl;
    @SafeParcelable.Field(id=7)
    String zzbm;
    @SafeParcelable.Field(id=8)
    long zzbn;
    @SafeParcelable.Field(id=9)
    String zzbo;

    public static Builder newBuilder() {
        return new GiftCardWalletObject().new Builder(null);
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        GiftCardWalletObject giftCardWalletObject = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)2, (Parcelable)giftCardWalletObject.zzbi, (int)n, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)3, (String)giftCardWalletObject.zzbj, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)4, (String)giftCardWalletObject.pin, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)5, (String)giftCardWalletObject.zzbk, (boolean)false);
        SafeParcelWriter.writeLong((Parcel)parcel2, (int)6, (long)giftCardWalletObject.zzbl);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)7, (String)giftCardWalletObject.zzbm, (boolean)false);
        SafeParcelWriter.writeLong((Parcel)parcel2, (int)8, (long)giftCardWalletObject.zzbn);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)9, (String)giftCardWalletObject.zzbo, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    GiftCardWalletObject() {
    }

    @SafeParcelable.Constructor
    GiftCardWalletObject(@SafeParcelable.Param(id=2) CommonWalletObject commonWalletObject, @SafeParcelable.Param(id=3) String string, @SafeParcelable.Param(id=4) String string2, @SafeParcelable.Param(id=5) String string3, @SafeParcelable.Param(id=6) long l, @SafeParcelable.Param(id=7) String string4, @SafeParcelable.Param(id=8) long l2, @SafeParcelable.Param(id=9) String string5) {
        this.zzbi = commonWalletObject;
        this.zzbj = string;
        this.pin = string2;
        this.zzbl = l;
        this.zzbm = string4;
        this.zzbn = l2;
        this.zzbo = string5;
        this.zzbk = string3;
    }

    public final String getId() {
        return this.zzbi.getId();
    }

    public final String getClassId() {
        return this.zzbi.getClassId();
    }

    public final String getTitle() {
        return this.zzbi.getName();
    }

    public final String getIssuerName() {
        return this.zzbi.getIssuerName();
    }

    public final String getBarcodeAlternateText() {
        return this.zzbi.getBarcodeAlternateText();
    }

    public final String getBarcodeType() {
        return this.zzbi.getBarcodeType();
    }

    public final String getBarcodeValue() {
        return this.zzbi.getBarcodeValue();
    }

    @Deprecated
    public final String getBarcodeLabel() {
        return this.zzbi.getBarcodeLabel();
    }

    public final int getState() {
        return this.zzbi.getState();
    }

    public final ArrayList<WalletObjectMessage> getMessages() {
        return this.zzbi.getMessages();
    }

    public final TimeInterval getValidTimeInterval() {
        return this.zzbi.getValidTimeInterval();
    }

    public final ArrayList<LatLng> getLocations() {
        return this.zzbi.getLocations();
    }

    @Deprecated
    public final String getInfoModuleDataHexFontColor() {
        return this.zzbi.getInfoModuleDataHexFontColor();
    }

    @Deprecated
    public final String getInfoModuleDataHexBackgroundColor() {
        return this.zzbi.getInfoModuleDataHexBackgroundColor();
    }

    public final ArrayList<LabelValueRow> getInfoModuleDataLabelValueRows() {
        return this.zzbi.getInfoModuleDataLabelValueRows();
    }

    public final boolean getInfoModuleDataShowLastUpdateTime() {
        return this.zzbi.getInfoModuleDataShowLastUpdateTime();
    }

    public final ArrayList<UriData> getImageModuleDataMainImageUris() {
        return this.zzbi.getImageModuleDataMainImageUris();
    }

    public final ArrayList<TextModuleData> getTextModulesData() {
        return this.zzbi.getTextModulesData();
    }

    public final ArrayList<UriData> getLinksModuleDataUris() {
        return this.zzbi.getLinksModuleDataUris();
    }

    public final String getCardNumber() {
        return this.zzbj;
    }

    public final String getPin() {
        return this.pin;
    }

    public final long getBalanceMicros() {
        return this.zzbl;
    }

    public final String getBalanceCurrencyCode() {
        return this.zzbm;
    }

    public final long getBalanceUpdateTime() {
        return this.zzbn;
    }

    public final String getEventNumber() {
        return this.zzbo;
    }

    @Deprecated
    public final String getCardIdentifier() {
        return this.zzbk;
    }

    public final class Builder {
        private CommonWalletObject.zza zzbp = CommonWalletObject.zzf();

        private Builder() {
        }

        public final Builder setCardNumber(String string) {
            GiftCardWalletObject.this.zzbj = string;
            return this;
        }

        public final Builder setPin(String string) {
            GiftCardWalletObject.this.pin = string;
            return this;
        }

        public final Builder setBalanceMicros(long l) {
            GiftCardWalletObject.this.zzbl = l;
            return this;
        }

        public final Builder setBalanceCurrencyCode(String string) {
            GiftCardWalletObject.this.zzbm = string;
            return this;
        }

        public final Builder setBalanceUpdateTime(long l) {
            GiftCardWalletObject.this.zzbn = l;
            return this;
        }

        public final Builder setEventNumber(String string) {
            GiftCardWalletObject.this.zzbo = string;
            return this;
        }

        @Deprecated
        public final Builder setCardIdentifier(String string) {
            GiftCardWalletObject.this.zzbk = string;
            return this;
        }

        public final Builder setId(String string) {
            this.zzbp.zza(string);
            return this;
        }

        public final Builder setIssuerName(String string) {
            this.zzbp.zzd(string);
            return this;
        }

        public final Builder setTitle(String string) {
            this.zzbp.zzc(string);
            return this;
        }

        public final Builder setBarcodeAlternateText(String string) {
            this.zzbp.zze(string);
            return this;
        }

        public final Builder setBarcodeType(String string) {
            this.zzbp.zzf(string);
            return this;
        }

        public final Builder setBarcodeValue(String string) {
            this.zzbp.zzg(string);
            return this;
        }

        @Deprecated
        public final Builder setBarcodeLabel(String string) {
            this.zzbp.zzh(string);
            return this;
        }

        public final Builder setClassId(String string) {
            this.zzbp.zzb(string);
            return this;
        }

        public final Builder setState(int n) {
            this.zzbp.zzc(n);
            return this;
        }

        public final Builder addMessages(Collection<WalletObjectMessage> collection) {
            this.zzbp.zza(collection);
            return this;
        }

        public final Builder addMessage(WalletObjectMessage walletObjectMessage) {
            this.zzbp.zza(walletObjectMessage);
            return this;
        }

        public final Builder setValidTimeInterval(TimeInterval timeInterval) {
            this.zzbp.zza(timeInterval);
            return this;
        }

        public final Builder addLocations(Collection<LatLng> collection) {
            this.zzbp.zzb(collection);
            return this;
        }

        public final Builder addLocation(LatLng latLng) {
            this.zzbp.zza(latLng);
            return this;
        }

        @Deprecated
        public final Builder setInfoModuleDataHexFontColor(String string) {
            this.zzbp.zzi(string);
            return this;
        }

        @Deprecated
        public final Builder setInfoModuleDataHexBackgroundColor(String string) {
            this.zzbp.zzj(string);
            return this;
        }

        public final Builder addInfoModuleDataLabelValueRows(Collection<LabelValueRow> collection) {
            this.zzbp.zzc(collection);
            return this;
        }

        public final Builder addInfoModuleDataLabelValueRow(LabelValueRow labelValueRow) {
            this.zzbp.zza(labelValueRow);
            return this;
        }

        public final Builder setInfoModuleDataShowLastUpdateTime(boolean bl) {
            this.zzbp.zza(bl);
            return this;
        }

        public final Builder addImageModuleDataMainImageUris(Collection<UriData> collection) {
            this.zzbp.zzd(collection);
            return this;
        }

        public final Builder addImageModuleDataMainImageUri(UriData uriData) {
            this.zzbp.zza(uriData);
            return this;
        }

        public final Builder addTextModulesData(Collection<TextModuleData> collection) {
            this.zzbp.zze(collection);
            return this;
        }

        public final Builder addTextModuleData(TextModuleData textModuleData) {
            this.zzbp.zza(textModuleData);
            return this;
        }

        public final Builder addLinksModuleDataUris(Collection<UriData> collection) {
            this.zzbp.zzf(collection);
            return this;
        }

        public final Builder addLinksModuleDataUri(UriData uriData) {
            this.zzbp.zzb(uriData);
            return this;
        }

        public final GiftCardWalletObject build() {
            Preconditions.checkArgument((!TextUtils.isEmpty((CharSequence)GiftCardWalletObject.this.zzbj) ? 1 : 0) != 0, (Object)"Card number is required.");
            GiftCardWalletObject.this.zzbi = this.zzbp.zzg();
            Preconditions.checkArgument((!TextUtils.isEmpty((CharSequence)GiftCardWalletObject.this.zzbi.getName()) ? 1 : 0) != 0, (Object)"Card name is required.");
            Preconditions.checkArgument((!TextUtils.isEmpty((CharSequence)GiftCardWalletObject.this.zzbi.getIssuerName()) ? 1 : 0) != 0, (Object)"Card issuer name is required.");
            return GiftCardWalletObject.this;
        }

        /* synthetic */ Builder(zzj zzj2) {
            this();
        }
    }
}

