/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.wallet.wobs.CommonWalletObject;
import com.google.android.gms.wallet.wobs.LabelValueRow;
import com.google.android.gms.wallet.wobs.TextModuleData;
import com.google.android.gms.wallet.wobs.TimeInterval;
import com.google.android.gms.wallet.wobs.UriData;
import com.google.android.gms.wallet.wobs.WalletObjectMessage;
import com.google.android.gms.wallet.zzj;
import com.google.android.gms.wallet.zzk;
import java.util.ArrayList;
import java.util.Collection;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="GiftCardWalletObjectCreator")
public final class GiftCardWalletObject
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<GiftCardWalletObject> CREATOR = new zzk();
    @SafeParcelable.Field(id=2)
    CommonWalletObject zzbh = CommonWalletObject.zze().zzf();
    @SafeParcelable.Field(id=3)
    String zzbi;
    @SafeParcelable.Field(id=4)
    String pin;
    @Deprecated
    @SafeParcelable.Field(id=5)
    String zzbj;
    @SafeParcelable.Field(id=6)
    long zzbk;
    @SafeParcelable.Field(id=7)
    String zzbl;
    @SafeParcelable.Field(id=8)
    long zzbm;
    @SafeParcelable.Field(id=9)
    String zzbn;

    public static Builder newBuilder() {
        return new GiftCardWalletObject().new Builder(null);
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        GiftCardWalletObject giftCardWalletObject = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)2, (Parcelable)giftCardWalletObject.zzbh, (int)n, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)3, (String)giftCardWalletObject.zzbi, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)4, (String)giftCardWalletObject.pin, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)5, (String)giftCardWalletObject.zzbj, (boolean)false);
        SafeParcelWriter.writeLong((Parcel)parcel2, (int)6, (long)giftCardWalletObject.zzbk);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)7, (String)giftCardWalletObject.zzbl, (boolean)false);
        SafeParcelWriter.writeLong((Parcel)parcel2, (int)8, (long)giftCardWalletObject.zzbm);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)9, (String)giftCardWalletObject.zzbn, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    GiftCardWalletObject() {
    }

    @SafeParcelable.Constructor
    GiftCardWalletObject(@SafeParcelable.Param(id=2) CommonWalletObject commonWalletObject, @SafeParcelable.Param(id=3) String string, @SafeParcelable.Param(id=4) String string2, @SafeParcelable.Param(id=5) String string3, @SafeParcelable.Param(id=6) long l, @SafeParcelable.Param(id=7) String string4, @SafeParcelable.Param(id=8) long l2, @SafeParcelable.Param(id=9) String string5) {
        this.zzbh = commonWalletObject;
        this.zzbi = string;
        this.pin = string2;
        this.zzbk = l;
        this.zzbl = string4;
        this.zzbm = l2;
        this.zzbn = string5;
        this.zzbj = string3;
    }

    public final String getId() {
        return this.zzbh.getId();
    }

    public final String getClassId() {
        return this.zzbh.getClassId();
    }

    public final String getTitle() {
        return this.zzbh.getName();
    }

    public final String getIssuerName() {
        return this.zzbh.getIssuerName();
    }

    public final String getBarcodeAlternateText() {
        return this.zzbh.getBarcodeAlternateText();
    }

    public final String getBarcodeType() {
        return this.zzbh.getBarcodeType();
    }

    public final String getBarcodeValue() {
        return this.zzbh.getBarcodeValue();
    }

    @Deprecated
    public final String getBarcodeLabel() {
        return this.zzbh.getBarcodeLabel();
    }

    public final int getState() {
        return this.zzbh.getState();
    }

    public final ArrayList<WalletObjectMessage> getMessages() {
        return this.zzbh.getMessages();
    }

    public final TimeInterval getValidTimeInterval() {
        return this.zzbh.getValidTimeInterval();
    }

    public final ArrayList<LatLng> getLocations() {
        return this.zzbh.getLocations();
    }

    @Deprecated
    public final String getInfoModuleDataHexFontColor() {
        return this.zzbh.getInfoModuleDataHexFontColor();
    }

    @Deprecated
    public final String getInfoModuleDataHexBackgroundColor() {
        return this.zzbh.getInfoModuleDataHexBackgroundColor();
    }

    public final ArrayList<LabelValueRow> getInfoModuleDataLabelValueRows() {
        return this.zzbh.getInfoModuleDataLabelValueRows();
    }

    public final boolean getInfoModuleDataShowLastUpdateTime() {
        return this.zzbh.getInfoModuleDataShowLastUpdateTime();
    }

    public final ArrayList<UriData> getImageModuleDataMainImageUris() {
        return this.zzbh.getImageModuleDataMainImageUris();
    }

    public final ArrayList<TextModuleData> getTextModulesData() {
        return this.zzbh.getTextModulesData();
    }

    public final ArrayList<UriData> getLinksModuleDataUris() {
        return this.zzbh.getLinksModuleDataUris();
    }

    public final String getCardNumber() {
        return this.zzbi;
    }

    public final String getPin() {
        return this.pin;
    }

    public final long getBalanceMicros() {
        return this.zzbk;
    }

    public final String getBalanceCurrencyCode() {
        return this.zzbl;
    }

    public final long getBalanceUpdateTime() {
        return this.zzbm;
    }

    public final String getEventNumber() {
        return this.zzbn;
    }

    @Deprecated
    public final String getCardIdentifier() {
        return this.zzbj;
    }

    public final class Builder {
        private CommonWalletObject.zza zzbo = CommonWalletObject.zze();

        private Builder() {
        }

        public final Builder setCardNumber(String string) {
            GiftCardWalletObject.this.zzbi = string;
            return this;
        }

        public final Builder setPin(String string) {
            GiftCardWalletObject.this.pin = string;
            return this;
        }

        public final Builder setBalanceMicros(long l) {
            GiftCardWalletObject.this.zzbk = l;
            return this;
        }

        public final Builder setBalanceCurrencyCode(String string) {
            GiftCardWalletObject.this.zzbl = string;
            return this;
        }

        public final Builder setBalanceUpdateTime(long l) {
            GiftCardWalletObject.this.zzbm = l;
            return this;
        }

        public final Builder setEventNumber(String string) {
            GiftCardWalletObject.this.zzbn = string;
            return this;
        }

        @Deprecated
        public final Builder setCardIdentifier(String string) {
            GiftCardWalletObject.this.zzbj = string;
            return this;
        }

        public final Builder setId(String string) {
            this.zzbo.zza(string);
            return this;
        }

        public final Builder setIssuerName(String string) {
            this.zzbo.zzd(string);
            return this;
        }

        public final Builder setTitle(String string) {
            this.zzbo.zzc(string);
            return this;
        }

        public final Builder setBarcodeAlternateText(String string) {
            this.zzbo.zze(string);
            return this;
        }

        public final Builder setBarcodeType(String string) {
            this.zzbo.zzf(string);
            return this;
        }

        public final Builder setBarcodeValue(String string) {
            this.zzbo.zzg(string);
            return this;
        }

        @Deprecated
        public final Builder setBarcodeLabel(String string) {
            this.zzbo.zzh(string);
            return this;
        }

        public final Builder setClassId(String string) {
            this.zzbo.zzb(string);
            return this;
        }

        public final Builder setState(int n) {
            this.zzbo.zza(n);
            return this;
        }

        public final Builder addMessages(Collection<WalletObjectMessage> collection) {
            this.zzbo.zza(collection);
            return this;
        }

        public final Builder addMessage(WalletObjectMessage walletObjectMessage) {
            this.zzbo.zza(walletObjectMessage);
            return this;
        }

        public final Builder setValidTimeInterval(TimeInterval timeInterval) {
            this.zzbo.zza(timeInterval);
            return this;
        }

        public final Builder addLocations(Collection<LatLng> collection) {
            this.zzbo.zzb(collection);
            return this;
        }

        public final Builder addLocation(LatLng latLng) {
            this.zzbo.zza(latLng);
            return this;
        }

        @Deprecated
        public final Builder setInfoModuleDataHexFontColor(String string) {
            this.zzbo.zzi(string);
            return this;
        }

        @Deprecated
        public final Builder setInfoModuleDataHexBackgroundColor(String string) {
            this.zzbo.zzj(string);
            return this;
        }

        public final Builder addInfoModuleDataLabelValueRows(Collection<LabelValueRow> collection) {
            this.zzbo.zzc(collection);
            return this;
        }

        public final Builder addInfoModuleDataLabelValueRow(LabelValueRow labelValueRow) {
            this.zzbo.zza(labelValueRow);
            return this;
        }

        public final Builder setInfoModuleDataShowLastUpdateTime(boolean bl) {
            this.zzbo.zza(bl);
            return this;
        }

        public final Builder addImageModuleDataMainImageUris(Collection<UriData> collection) {
            this.zzbo.zzd(collection);
            return this;
        }

        public final Builder addImageModuleDataMainImageUri(UriData uriData) {
            this.zzbo.zza(uriData);
            return this;
        }

        public final Builder addTextModulesData(Collection<TextModuleData> collection) {
            this.zzbo.zze(collection);
            return this;
        }

        public final Builder addTextModuleData(TextModuleData textModuleData) {
            this.zzbo.zza(textModuleData);
            return this;
        }

        public final Builder addLinksModuleDataUris(Collection<UriData> collection) {
            this.zzbo.zzf(collection);
            return this;
        }

        public final Builder addLinksModuleDataUri(UriData uriData) {
            this.zzbo.zzb(uriData);
            return this;
        }

        public final GiftCardWalletObject build() {
            Preconditions.checkArgument((!TextUtils.isEmpty((CharSequence)GiftCardWalletObject.this.zzbi) ? 1 : 0) != 0, (Object)"Card number is required.");
            GiftCardWalletObject.this.zzbh = this.zzbo.zzf();
            Preconditions.checkArgument((!TextUtils.isEmpty((CharSequence)GiftCardWalletObject.this.zzbh.getName()) ? 1 : 0) != 0, (Object)"Card name is required.");
            Preconditions.checkArgument((!TextUtils.isEmpty((CharSequence)GiftCardWalletObject.this.zzbh.getIssuerName()) ? 1 : 0) != 0, (Object)"Card issuer name is required.");
            return GiftCardWalletObject.this;
        }

        /* synthetic */ Builder(zzj zzj2) {
            this();
        }
    }
}

