/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet.fragment;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.wallet.R;
import com.google.android.gms.wallet.fragment.zzg;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="WalletFragmentStyleCreator")
public final class WalletFragmentStyle
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<WalletFragmentStyle> CREATOR = new zzg();
    @SafeParcelable.Field(id=2)
    private Bundle zzgd;
    @SafeParcelable.Field(id=3)
    private int zzge;

    public WalletFragmentStyle() {
        this.zzgd = new Bundle();
        this.zzgd.putInt("buyButtonAppearanceDefault", 4);
        this.zzgd.putInt("maskedWalletDetailsLogoImageTypeDefault", 3);
    }

    @SafeParcelable.Constructor
    WalletFragmentStyle(@SafeParcelable.Param(id=2) Bundle bundle, @SafeParcelable.Param(id=3) int n) {
        this.zzgd = bundle;
        this.zzge = n;
    }

    public final WalletFragmentStyle setStyleResourceId(int n) {
        this.zzge = n;
        return this;
    }

    public final WalletFragmentStyle setBuyButtonText(int n) {
        this.zzgd.putInt("buyButtonText", n);
        return this;
    }

    public final WalletFragmentStyle setBuyButtonHeight(int n) {
        this.zzgd.putLong("buyButtonHeight", WalletFragmentStyle.zza(n));
        return this;
    }

    public final WalletFragmentStyle setBuyButtonHeight(int n, float f) {
        this.zzgd.putLong("buyButtonHeight", WalletFragmentStyle.zza(n, f));
        return this;
    }

    public final WalletFragmentStyle setBuyButtonWidth(int n) {
        this.zzgd.putLong("buyButtonWidth", WalletFragmentStyle.zza(n));
        return this;
    }

    public final WalletFragmentStyle setBuyButtonWidth(int n, float f) {
        this.zzgd.putLong("buyButtonWidth", WalletFragmentStyle.zza(n, f));
        return this;
    }

    public final WalletFragmentStyle setBuyButtonAppearance(int n) {
        this.zzgd.putInt("buyButtonAppearance", n);
        return this;
    }

    public final WalletFragmentStyle setMaskedWalletDetailsTextAppearance(int n) {
        this.zzgd.putInt("maskedWalletDetailsTextAppearance", n);
        return this;
    }

    public final WalletFragmentStyle setMaskedWalletDetailsHeaderTextAppearance(int n) {
        this.zzgd.putInt("maskedWalletDetailsHeaderTextAppearance", n);
        return this;
    }

    public final WalletFragmentStyle setMaskedWalletDetailsBackgroundColor(int n) {
        this.zzgd.remove("maskedWalletDetailsBackgroundResource");
        this.zzgd.putInt("maskedWalletDetailsBackgroundColor", n);
        return this;
    }

    public final WalletFragmentStyle setMaskedWalletDetailsBackgroundResource(int n) {
        this.zzgd.remove("maskedWalletDetailsBackgroundColor");
        this.zzgd.putInt("maskedWalletDetailsBackgroundResource", n);
        return this;
    }

    public final WalletFragmentStyle setMaskedWalletDetailsButtonTextAppearance(int n) {
        this.zzgd.putInt("maskedWalletDetailsButtonTextAppearance", n);
        return this;
    }

    public final WalletFragmentStyle setMaskedWalletDetailsButtonBackgroundColor(int n) {
        this.zzgd.remove("maskedWalletDetailsButtonBackgroundResource");
        this.zzgd.putInt("maskedWalletDetailsButtonBackgroundColor", n);
        return this;
    }

    public final WalletFragmentStyle setMaskedWalletDetailsButtonBackgroundResource(int n) {
        this.zzgd.remove("maskedWalletDetailsButtonBackgroundColor");
        this.zzgd.putInt("maskedWalletDetailsButtonBackgroundResource", n);
        return this;
    }

    public final WalletFragmentStyle setMaskedWalletDetailsLogoImageType(int n) {
        this.zzgd.putInt("maskedWalletDetailsLogoImageType", n);
        return this;
    }

    @Deprecated
    public final WalletFragmentStyle setMaskedWalletDetailsLogoTextColor(int n) {
        this.zzgd.putInt("maskedWalletDetailsLogoTextColor", n);
        return this;
    }

    public final int zza(String string2, DisplayMetrics displayMetrics, int n) {
        if (this.zzgd.containsKey(string2)) {
            int n2;
            DisplayMetrics displayMetrics2 = displayMetrics;
            long l = this.zzgd.getLong(string2);
            int n3 = (int)(l >>> 32);
            int n4 = (int)l;
            switch (n3) {
                case 129: {
                    return n4;
                }
                case 128: {
                    return TypedValue.complexToDimensionPixelSize((int)n4, (DisplayMetrics)displayMetrics2);
                }
                case 0: {
                    n2 = 0;
                    break;
                }
                case 1: {
                    n2 = 1;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
                case 3: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 4;
                    break;
                }
                case 5: {
                    n2 = 5;
                    break;
                }
                default: {
                    throw new IllegalStateException(new StringBuilder(36).append("Unexpected unit or type: ").append(n3).toString());
                }
            }
            return Math.round(TypedValue.applyDimension((int)n2, (float)Float.intBitsToFloat(n4), (DisplayMetrics)displayMetrics2));
        }
        return n;
    }

    private static long zza(int n, float f) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return WalletFragmentStyle.zzc(n, Float.floatToIntBits(f));
            }
        }
        throw new IllegalArgumentException(new StringBuilder(30).append("Unrecognized unit: ").append(n).toString());
    }

    private static long zza(int n) {
        if (n < 0) {
            if (n == -1 || n == -2) {
                return WalletFragmentStyle.zzc(129, n);
            }
            throw new IllegalArgumentException(new StringBuilder(39).append("Unexpected dimension value: ").append(n).toString());
        }
        return WalletFragmentStyle.zza(0, n);
    }

    private static long zzc(int n, int n2) {
        return (long)n << 32 | (long)n2 & 0xFFFFFFFFL;
    }

    public final void zza(Context context) {
        int n = this.zzge <= 0 ? R.style.WalletFragmentDefaultStyle : this.zzge;
        int[] nArray = R.styleable.WalletFragmentStyle;
        TypedArray typedArray = context.obtainStyledAttributes(n, nArray);
        this.zza(typedArray, R.styleable.WalletFragmentStyle_buyButtonWidth, "buyButtonWidth");
        this.zza(typedArray, R.styleable.WalletFragmentStyle_buyButtonHeight, "buyButtonHeight");
        this.zzb(typedArray, R.styleable.WalletFragmentStyle_buyButtonText, "buyButtonText");
        this.zzb(typedArray, R.styleable.WalletFragmentStyle_buyButtonAppearance, "buyButtonAppearance");
        this.zzb(typedArray, R.styleable.WalletFragmentStyle_maskedWalletDetailsTextAppearance, "maskedWalletDetailsTextAppearance");
        this.zzb(typedArray, R.styleable.WalletFragmentStyle_maskedWalletDetailsHeaderTextAppearance, "maskedWalletDetailsHeaderTextAppearance");
        this.zza(typedArray, R.styleable.WalletFragmentStyle_maskedWalletDetailsBackground, "maskedWalletDetailsBackgroundColor", "maskedWalletDetailsBackgroundResource");
        this.zzb(typedArray, R.styleable.WalletFragmentStyle_maskedWalletDetailsButtonTextAppearance, "maskedWalletDetailsButtonTextAppearance");
        this.zza(typedArray, R.styleable.WalletFragmentStyle_maskedWalletDetailsButtonBackground, "maskedWalletDetailsButtonBackgroundColor", "maskedWalletDetailsButtonBackgroundResource");
        this.zzb(typedArray, R.styleable.WalletFragmentStyle_maskedWalletDetailsLogoTextColor, "maskedWalletDetailsLogoTextColor");
        this.zzb(typedArray, R.styleable.WalletFragmentStyle_maskedWalletDetailsLogoImageType, "maskedWalletDetailsLogoImageType");
        typedArray.recycle();
    }

    private final void zza(TypedArray typedArray, int n, String string2) {
        if (this.zzgd.containsKey(string2)) {
            return;
        }
        TypedValue typedValue = typedArray.peekValue(n);
        if (typedValue != null) {
            long l;
            TypedValue typedValue2 = typedValue;
            switch (typedValue2.type) {
                case 16: {
                    l = WalletFragmentStyle.zza(typedValue2.data);
                    break;
                }
                case 5: {
                    l = WalletFragmentStyle.zzc(128, typedValue2.data);
                    break;
                }
                default: {
                    int n2 = typedValue2.type;
                    throw new IllegalArgumentException(new StringBuilder(38).append("Unexpected dimension type: ").append(n2).toString());
                }
            }
            this.zzgd.putLong(string2, l);
        }
    }

    private final void zzb(TypedArray typedArray, int n, String string2) {
        if (this.zzgd.containsKey(string2)) {
            return;
        }
        TypedValue typedValue = typedArray.peekValue(n);
        if (typedValue != null) {
            this.zzgd.putInt(string2, typedValue.data);
        }
    }

    private final void zza(TypedArray typedArray, int n, String string2, String string3) {
        if (this.zzgd.containsKey(string2) || this.zzgd.containsKey(string3)) {
            return;
        }
        TypedValue typedValue = typedArray.peekValue(n);
        if (typedValue != null) {
            if (typedValue.type >= 28 && typedValue.type <= 31) {
                this.zzgd.putInt(string2, typedValue.data);
                return;
            }
            this.zzgd.putInt(string3, typedValue.resourceId);
        }
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        WalletFragmentStyle walletFragmentStyle = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeBundle((Parcel)parcel2, (int)2, (Bundle)walletFragmentStyle.zzgd, (boolean)false);
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)3, (int)walletFragmentStyle.zzge);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Dimension {
        public static final int UNIT_PX = 0;
        public static final int UNIT_DIP = 1;
        public static final int UNIT_SP = 2;
        public static final int UNIT_PT = 3;
        public static final int UNIT_IN = 4;
        public static final int UNIT_MM = 5;
        public static final int MATCH_PARENT = -1;
        public static final int WRAP_CONTENT = -2;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface LogoImageType {
        @Deprecated
        public static final int GOOGLE_WALLET_CLASSIC = 1;
        @Deprecated
        public static final int GOOGLE_WALLET_MONOCHROME = 2;
        public static final int ANDROID_PAY = 3;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface BuyButtonAppearance {
        public static final int ANDROID_PAY_DARK = 4;
        public static final int ANDROID_PAY_LIGHT = 5;
        public static final int ANDROID_PAY_LIGHT_WITH_BORDER = 6;
        @Deprecated
        public static final int GOOGLE_WALLET_CLASSIC = 1;
        @Deprecated
        public static final int GOOGLE_WALLET_GRAYSCALE = 2;
        @Deprecated
        public static final int GOOGLE_WALLET_MONOCHROME = 3;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface BuyButtonText {
        public static final int BUY_WITH = 5;
        public static final int LOGO_ONLY = 6;
        public static final int DONATE_WITH = 7;
    }
}

