/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet;

import android.content.Intent;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelableSerializer;
import com.google.android.gms.identity.intents.model.UserAddress;
import com.google.android.gms.wallet.AutoResolvableResult;
import com.google.android.gms.wallet.CardInfo;
import com.google.android.gms.wallet.PaymentMethodToken;
import com.google.android.gms.wallet.zzac;
import com.google.android.gms.wallet.zzad;

@SafeParcelable.Class(creator="PaymentDataCreator")
public final class PaymentData
extends AbstractSafeParcelable
implements AutoResolvableResult {
    public static final Parcelable.Creator<PaymentData> CREATOR = new zzad();
    @SafeParcelable.Field(id=1)
    private String zzba;
    @SafeParcelable.Field(id=2)
    private CardInfo zzdt;
    @SafeParcelable.Field(id=3)
    private UserAddress zzdu;
    @SafeParcelable.Field(id=4)
    private PaymentMethodToken zzbh;
    @SafeParcelable.Field(id=5)
    private String zzax;
    @SafeParcelable.Field(id=6)
    private Bundle zzdv;
    @SafeParcelable.Field(id=7)
    private String zzbz;

    @SafeParcelable.Constructor
    PaymentData(@SafeParcelable.Param(id=1) String string, @SafeParcelable.Param(id=2) CardInfo cardInfo, @SafeParcelable.Param(id=3) UserAddress userAddress, @SafeParcelable.Param(id=4) PaymentMethodToken paymentMethodToken, @SafeParcelable.Param(id=5) String string2, @SafeParcelable.Param(id=6) Bundle bundle, @SafeParcelable.Param(id=7) String string3) {
        this.zzba = string;
        this.zzdt = cardInfo;
        this.zzdu = userAddress;
        this.zzbh = paymentMethodToken;
        this.zzax = string2;
        this.zzdv = bundle;
        this.zzbz = string3;
    }

    private PaymentData() {
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        PaymentData paymentData = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)1, (String)paymentData.zzba, (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)2, (Parcelable)paymentData.zzdt, (int)n, (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)3, (Parcelable)paymentData.zzdu, (int)n, (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)4, (Parcelable)paymentData.zzbh, (int)n, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)5, (String)paymentData.zzax, (boolean)false);
        SafeParcelWriter.writeBundle((Parcel)parcel2, (int)6, (Bundle)paymentData.zzdv, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)7, (String)paymentData.zzbz, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    @Nullable
    public final String getEmail() {
        return this.zzba;
    }

    public final CardInfo getCardInfo() {
        return this.zzdt;
    }

    @Nullable
    public final UserAddress getShippingAddress() {
        return this.zzdu;
    }

    @Nullable
    public final PaymentMethodToken getPaymentMethodToken() {
        return this.zzbh;
    }

    public final String getGoogleTransactionId() {
        return this.zzax;
    }

    @Nullable
    public final Bundle getExtraData() {
        return this.zzdv;
    }

    public static PaymentData fromJson(String string) {
        String string2 = (String)Preconditions.checkNotNull((Object)string, (Object)"paymentDataJson cannot be null!");
        zza zza2 = new PaymentData().new zza(null);
        new PaymentData().new zza(null).PaymentData.this.zzbz = string2;
        return zza2.PaymentData.this;
    }

    public final String toJson() {
        return this.zzbz;
    }

    @Nullable
    public static PaymentData getFromIntent(@NonNull Intent intent) {
        return (PaymentData)SafeParcelableSerializer.deserializeFromIntentExtra((Intent)intent, (String)"com.google.android.gms.wallet.PaymentData", CREATOR);
    }

    @Override
    public final void putIntoIntent(@NonNull Intent intent) {
        SafeParcelableSerializer.serializeToIntentExtra((SafeParcelable)this, (Intent)intent, (String)"com.google.android.gms.wallet.PaymentData");
    }

    public final class zza {
        private zza() {
        }

        /* synthetic */ zza(zzac zzac2) {
            this();
        }
    }
}

