/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet.fragment;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.wallet.R;
import com.google.android.gms.wallet.fragment.WalletFragmentStyle;
import com.google.android.gms.wallet.fragment.zze;
import com.google.android.gms.wallet.fragment.zzf;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="WalletFragmentOptionsCreator")
public final class WalletFragmentOptions
extends AbstractSafeParcelable
implements ReflectedParcelable {
    public static final Parcelable.Creator<WalletFragmentOptions> CREATOR = new zzf();
    @SafeParcelable.Field(id=2, getter="getEnvironment", defaultValueUnchecked="com.google.android.gms.wallet.WalletConstants.ENVIRONMENT_PRODUCTION")
    private int environment;
    @SafeParcelable.Field(id=3, getter="getTheme", defaultValueUnchecked="com.google.android.gms.wallet.WalletConstants.THEME_DARK")
    private int theme;
    @SafeParcelable.Field(id=4, getter="getFragmentStyle")
    private WalletFragmentStyle zzgb;
    @SafeParcelable.Field(id=5, getter="getMode", defaultValueUnchecked="com.google.android.gms.wallet.fragment.WalletFragmentMode.BUY_BUTTON")
    private int mode;

    public static Builder newBuilder() {
        return new WalletFragmentOptions().new Builder(null);
    }

    private WalletFragmentOptions() {
        this.environment = 3;
        this.zzgb = new WalletFragmentStyle();
    }

    @SafeParcelable.Constructor
    WalletFragmentOptions(@SafeParcelable.Param(id=2) int n, @SafeParcelable.Param(id=3) int n2, @SafeParcelable.Param(id=4) WalletFragmentStyle walletFragmentStyle, @SafeParcelable.Param(id=5) int n3) {
        this.environment = n;
        this.theme = n2;
        this.zzgb = walletFragmentStyle;
        this.mode = n3;
    }

    public final int getEnvironment() {
        return this.environment;
    }

    public final int getTheme() {
        return this.theme;
    }

    public final WalletFragmentStyle getFragmentStyle() {
        return this.zzgb;
    }

    public final int getMode() {
        return this.mode;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        WalletFragmentOptions walletFragmentOptions = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)2, (int)walletFragmentOptions.getEnvironment());
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)3, (int)walletFragmentOptions.getTheme());
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)4, (Parcelable)walletFragmentOptions.getFragmentStyle(), (int)n, (boolean)false);
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)5, (int)walletFragmentOptions.getMode());
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    public final void zza(Context context) {
        if (this.zzgb != null) {
            this.zzgb.zza(context);
        }
    }

    public static WalletFragmentOptions zza(Context context, AttributeSet attributeSet) {
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.WalletFragmentOptions);
        int n = typedArray.getInt(R.styleable.WalletFragmentOptions_appTheme, 0);
        int n2 = typedArray.getInt(R.styleable.WalletFragmentOptions_environment, 1);
        int n3 = typedArray.getResourceId(R.styleable.WalletFragmentOptions_fragmentStyle, 0);
        int n4 = typedArray.getInt(R.styleable.WalletFragmentOptions_fragmentMode, 1);
        typedArray.recycle();
        WalletFragmentOptions walletFragmentOptions = new WalletFragmentOptions();
        new WalletFragmentOptions().theme = n;
        walletFragmentOptions.environment = n2;
        walletFragmentOptions.zzgb = new WalletFragmentStyle().setStyleResourceId(n3);
        walletFragmentOptions.zzgb.zza(context);
        walletFragmentOptions.mode = n4;
        return walletFragmentOptions;
    }

    public final class Builder {
        private Builder() {
        }

        public final Builder setEnvironment(int n) {
            WalletFragmentOptions.this.environment = n;
            return this;
        }

        public final Builder setTheme(int n) {
            WalletFragmentOptions.this.theme = n;
            return this;
        }

        public final Builder setFragmentStyle(int n) {
            WalletFragmentOptions.this.zzgb = new WalletFragmentStyle().setStyleResourceId(n);
            return this;
        }

        public final Builder setFragmentStyle(WalletFragmentStyle walletFragmentStyle) {
            WalletFragmentOptions.this.zzgb = walletFragmentStyle;
            return this;
        }

        public final Builder setMode(int n) {
            WalletFragmentOptions.this.mode = n;
            return this;
        }

        public final WalletFragmentOptions build() {
            return WalletFragmentOptions.this;
        }

        /* synthetic */ Builder(zze zze2) {
            this();
        }
    }
}

