/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.wallet.CardRequirements;
import com.google.android.gms.wallet.PaymentMethodTokenizationParameters;
import com.google.android.gms.wallet.ShippingAddressRequirements;
import com.google.android.gms.wallet.TransactionInfo;
import com.google.android.gms.wallet.zzae;
import com.google.android.gms.wallet.zzaf;
import java.util.ArrayList;
import java.util.Collection;

@SafeParcelable.Class(creator="PaymentDataRequestCreator")
public final class PaymentDataRequest
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<PaymentDataRequest> CREATOR = new zzaf();
    @SafeParcelable.Field(id=1)
    boolean zzdx;
    @SafeParcelable.Field(id=2)
    boolean zzde;
    @SafeParcelable.Field(id=3)
    CardRequirements zzdy;
    @SafeParcelable.Field(id=4)
    boolean zzdf;
    @SafeParcelable.Field(id=5)
    ShippingAddressRequirements zzdz;
    @SafeParcelable.Field(id=6)
    ArrayList<Integer> zzbx;
    @SafeParcelable.Field(id=7)
    PaymentMethodTokenizationParameters zzdp;
    @SafeParcelable.Field(id=8)
    TransactionInfo zzea;
    @SafeParcelable.Field(id=9, defaultValue="true")
    boolean zzeb;
    @SafeParcelable.Field(id=10)
    String zzbz;

    @SafeParcelable.Constructor
    PaymentDataRequest(@SafeParcelable.Param(id=1) boolean bl, @SafeParcelable.Param(id=2) boolean bl2, @SafeParcelable.Param(id=3) CardRequirements cardRequirements, @SafeParcelable.Param(id=4) boolean bl3, @SafeParcelable.Param(id=5) ShippingAddressRequirements shippingAddressRequirements, @SafeParcelable.Param(id=6) ArrayList<Integer> arrayList, @SafeParcelable.Param(id=7) PaymentMethodTokenizationParameters paymentMethodTokenizationParameters, @SafeParcelable.Param(id=8) TransactionInfo transactionInfo, @SafeParcelable.Param(id=9) boolean bl4, @SafeParcelable.Param(id=10) String string) {
        this.zzdx = bl;
        this.zzde = bl2;
        this.zzdy = cardRequirements;
        this.zzdf = bl3;
        this.zzdz = shippingAddressRequirements;
        this.zzbx = arrayList;
        this.zzdp = paymentMethodTokenizationParameters;
        this.zzea = transactionInfo;
        this.zzeb = bl4;
        this.zzbz = string;
    }

    private PaymentDataRequest() {
        this.zzeb = true;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        PaymentDataRequest paymentDataRequest = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)1, (boolean)paymentDataRequest.zzdx);
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)2, (boolean)paymentDataRequest.zzde);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)3, (Parcelable)paymentDataRequest.zzdy, (int)n, (boolean)false);
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)4, (boolean)paymentDataRequest.zzdf);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)5, (Parcelable)paymentDataRequest.zzdz, (int)n, (boolean)false);
        SafeParcelWriter.writeIntegerList((Parcel)parcel2, (int)6, paymentDataRequest.zzbx, (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)7, (Parcelable)paymentDataRequest.zzdp, (int)n, (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)8, (Parcelable)paymentDataRequest.zzea, (int)n, (boolean)false);
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)9, (boolean)paymentDataRequest.zzeb);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)10, (String)paymentDataRequest.zzbz, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    public final boolean isEmailRequired() {
        return this.zzdx;
    }

    public final boolean isPhoneNumberRequired() {
        return this.zzde;
    }

    @Nullable
    public final CardRequirements getCardRequirements() {
        return this.zzdy;
    }

    public final boolean isShippingAddressRequired() {
        return this.zzdf;
    }

    @Nullable
    public final ShippingAddressRequirements getShippingAddressRequirements() {
        return this.zzdz;
    }

    public final ArrayList<Integer> getAllowedPaymentMethods() {
        return this.zzbx;
    }

    public final PaymentMethodTokenizationParameters getPaymentMethodTokenizationParameters() {
        return this.zzdp;
    }

    public final TransactionInfo getTransactionInfo() {
        return this.zzea;
    }

    public final boolean isUiRequired() {
        return this.zzeb;
    }

    public static Builder newBuilder() {
        return new PaymentDataRequest().new Builder(null);
    }

    public static PaymentDataRequest fromJson(String string) {
        String string2 = (String)Preconditions.checkNotNull((Object)string, (Object)"paymentDataRequestJson cannot be null!");
        Builder builder = PaymentDataRequest.newBuilder();
        PaymentDataRequest.newBuilder().PaymentDataRequest.this.zzbz = string2;
        return builder.build();
    }

    public final String toJson() {
        return this.zzbz;
    }

    public final class Builder {
        private Builder() {
        }

        public final Builder setEmailRequired(boolean bl) {
            PaymentDataRequest.this.zzdx = bl;
            return this;
        }

        public final Builder setPhoneNumberRequired(boolean bl) {
            PaymentDataRequest.this.zzde = bl;
            return this;
        }

        public final Builder setCardRequirements(@NonNull CardRequirements cardRequirements) {
            PaymentDataRequest.this.zzdy = cardRequirements;
            return this;
        }

        public final Builder setShippingAddressRequired(boolean bl) {
            PaymentDataRequest.this.zzdf = bl;
            return this;
        }

        public final Builder setShippingAddressRequirements(@NonNull ShippingAddressRequirements shippingAddressRequirements) {
            PaymentDataRequest.this.zzdz = shippingAddressRequirements;
            return this;
        }

        public final Builder addAllowedPaymentMethod(int n) {
            if (PaymentDataRequest.this.zzbx == null) {
                PaymentDataRequest.this.zzbx = new ArrayList();
            }
            PaymentDataRequest.this.zzbx.add(n);
            return this;
        }

        public final Builder addAllowedPaymentMethods(@NonNull Collection<Integer> collection) {
            Preconditions.checkArgument((collection != null && !collection.isEmpty() ? 1 : 0) != 0, (Object)"allowedPaymentMethods can't be null or empty!");
            if (PaymentDataRequest.this.zzbx == null) {
                PaymentDataRequest.this.zzbx = new ArrayList();
            }
            PaymentDataRequest.this.zzbx.addAll(collection);
            return this;
        }

        public final Builder setPaymentMethodTokenizationParameters(PaymentMethodTokenizationParameters paymentMethodTokenizationParameters) {
            PaymentDataRequest.this.zzdp = paymentMethodTokenizationParameters;
            return this;
        }

        public final Builder setTransactionInfo(@NonNull TransactionInfo transactionInfo) {
            PaymentDataRequest.this.zzea = transactionInfo;
            return this;
        }

        public final Builder setUiRequired(boolean bl) {
            PaymentDataRequest.this.zzeb = bl;
            return this;
        }

        public final PaymentDataRequest build() {
            if (PaymentDataRequest.this.zzbz == null) {
                Preconditions.checkNotNull(PaymentDataRequest.this.zzbx, (Object)"Allowed payment methods must be set! You can set it through addAllowedPaymentMethod() or addAllowedPaymentMethods() in the PaymentDataRequest Builder.");
                Preconditions.checkNotNull((Object)((Object)PaymentDataRequest.this.zzdy), (Object)"Card requirements must be set!");
                if (PaymentDataRequest.this.zzdp != null) {
                    Preconditions.checkNotNull((Object)((Object)PaymentDataRequest.this.zzea), (Object)"Transaction info must be set if paymentMethodTokenizationParameters is set!");
                }
            }
            return PaymentDataRequest.this;
        }

        /* synthetic */ Builder(zzae zzae2) {
            this();
        }
    }
}

