/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.wallet.wobs.CommonWalletObject;
import com.google.android.gms.wallet.wobs.LabelValueRow;
import com.google.android.gms.wallet.wobs.TextModuleData;
import com.google.android.gms.wallet.wobs.TimeInterval;
import com.google.android.gms.wallet.wobs.UriData;
import com.google.android.gms.wallet.wobs.WalletObjectMessage;
import com.google.android.gms.wallet.zzaa;
import com.google.android.gms.wallet.zzab;
import java.util.ArrayList;
import java.util.Collection;

@SafeParcelable.Class(creator="OfferWalletObjectCreator")
public final class OfferWalletObject
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<OfferWalletObject> CREATOR = new zzab();
    @SafeParcelable.VersionField(id=1, getter="getVersionCode")
    private final int versionCode;
    @SafeParcelable.Field(id=2)
    String zzcf;
    @SafeParcelable.Field(id=3)
    String zzdr;
    @SafeParcelable.Field(id=4)
    CommonWalletObject zzbk;

    public static Builder newBuilder() {
        return new OfferWalletObject().new Builder(null);
    }

    public final int getVersionCode() {
        return this.versionCode;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        OfferWalletObject offerWalletObject = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)1, (int)offerWalletObject.getVersionCode());
        SafeParcelWriter.writeString((Parcel)parcel2, (int)2, (String)offerWalletObject.zzcf, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)3, (String)offerWalletObject.zzdr, (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)4, (Parcelable)offerWalletObject.zzbk, (int)n, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    @SafeParcelable.Constructor
    OfferWalletObject(@SafeParcelable.Param(id=1) int n, @SafeParcelable.Param(id=2) String string, @SafeParcelable.Param(id=3) String string2, @SafeParcelable.Param(id=4) CommonWalletObject commonWalletObject) {
        this.versionCode = n;
        this.zzdr = string2;
        if (n < 3) {
            this.zzbk = CommonWalletObject.zze().zza(string).zzf();
            return;
        }
        this.zzbk = commonWalletObject;
    }

    OfferWalletObject() {
        this.versionCode = 3;
    }

    public final String getId() {
        return this.zzbk.getId();
    }

    public final String getRedemptionCode() {
        return this.zzdr;
    }

    public final String getClassId() {
        return this.zzbk.getClassId();
    }

    public final String getTitle() {
        return this.zzbk.getName();
    }

    public final String getIssuerName() {
        return this.zzbk.getIssuerName();
    }

    public final String getBarcodeAlternateText() {
        return this.zzbk.getBarcodeAlternateText();
    }

    public final String getBarcodeType() {
        return this.zzbk.getBarcodeType();
    }

    public final String getBarcodeValue() {
        return this.zzbk.getBarcodeValue();
    }

    @Deprecated
    public final String getBarcodeLabel() {
        return this.zzbk.getBarcodeLabel();
    }

    public final int getState() {
        return this.zzbk.getState();
    }

    public final ArrayList<WalletObjectMessage> getMessages() {
        return this.zzbk.getMessages();
    }

    public final TimeInterval getValidTimeInterval() {
        return this.zzbk.getValidTimeInterval();
    }

    public final ArrayList<LatLng> getLocations() {
        return this.zzbk.getLocations();
    }

    @Deprecated
    public final String getInfoModuleDataHexFontColor() {
        return this.zzbk.getInfoModuleDataHexFontColor();
    }

    @Deprecated
    public final String getInfoModuleDataHexBackgroundColor() {
        return this.zzbk.getInfoModuleDataHexBackgroundColor();
    }

    public final ArrayList<LabelValueRow> getInfoModuleDataLabelValueRows() {
        return this.zzbk.getInfoModuleDataLabelValueRows();
    }

    public final boolean getInfoModuleDataShowLastUpdateTime() {
        return this.zzbk.getInfoModuleDataShowLastUpdateTime();
    }

    public final ArrayList<UriData> getImageModuleDataMainImageUris() {
        return this.zzbk.getImageModuleDataMainImageUris();
    }

    public final ArrayList<TextModuleData> getTextModulesData() {
        return this.zzbk.getTextModulesData();
    }

    public final ArrayList<UriData> getLinksModuleDataUris() {
        return this.zzbk.getLinksModuleDataUris();
    }

    public final class Builder {
        private CommonWalletObject.zza zzbr = CommonWalletObject.zze();

        private Builder() {
        }

        public final Builder setId(String string) {
            this.zzbr.zza(string);
            OfferWalletObject.this.zzcf = string;
            return this;
        }

        public final Builder setRedemptionCode(String string) {
            OfferWalletObject.this.zzdr = string;
            return this;
        }

        public final Builder setIssuerName(String string) {
            this.zzbr.zzd(string);
            return this;
        }

        public final Builder setTitle(String string) {
            this.zzbr.zzc(string);
            return this;
        }

        public final Builder setBarcodeAlternateText(String string) {
            this.zzbr.zze(string);
            return this;
        }

        public final Builder setBarcodeType(String string) {
            this.zzbr.zzf(string);
            return this;
        }

        public final Builder setBarcodeValue(String string) {
            this.zzbr.zzg(string);
            return this;
        }

        @Deprecated
        public final Builder setBarcodeLabel(String string) {
            this.zzbr.zzh(string);
            return this;
        }

        public final Builder setClassId(String string) {
            this.zzbr.zzb(string);
            return this;
        }

        public final Builder setState(int n) {
            this.zzbr.zzc(n);
            return this;
        }

        public final Builder addMessages(Collection<WalletObjectMessage> collection) {
            this.zzbr.zza(collection);
            return this;
        }

        public final Builder addMessage(WalletObjectMessage walletObjectMessage) {
            this.zzbr.zza(walletObjectMessage);
            return this;
        }

        public final Builder setValidTimeInterval(TimeInterval timeInterval) {
            this.zzbr.zza(timeInterval);
            return this;
        }

        public final Builder addLocations(Collection<LatLng> collection) {
            this.zzbr.zzb(collection);
            return this;
        }

        public final Builder addLocation(LatLng latLng) {
            this.zzbr.zza(latLng);
            return this;
        }

        @Deprecated
        public final Builder setInfoModuleDataHexFontColor(String string) {
            this.zzbr.zzi(string);
            return this;
        }

        @Deprecated
        public final Builder setInfoModuleDataHexBackgroundColor(String string) {
            this.zzbr.zzj(string);
            return this;
        }

        public final Builder addInfoModuleDataLabelValueRows(Collection<LabelValueRow> collection) {
            this.zzbr.zzc(collection);
            return this;
        }

        public final Builder addInfoModuleDataLabelValueRow(LabelValueRow labelValueRow) {
            this.zzbr.zza(labelValueRow);
            return this;
        }

        public final Builder setInfoModuleDataShowLastUpdateTime(boolean bl) {
            this.zzbr.zza(bl);
            return this;
        }

        public final Builder addImageModuleDataMainImageUris(Collection<UriData> collection) {
            this.zzbr.zzd(collection);
            return this;
        }

        public final Builder addImageModuleDataMainImageUri(UriData uriData) {
            this.zzbr.zza(uriData);
            return this;
        }

        public final Builder addTextModulesData(Collection<TextModuleData> collection) {
            this.zzbr.zze(collection);
            return this;
        }

        public final Builder addTextModuleData(TextModuleData textModuleData) {
            this.zzbr.zza(textModuleData);
            return this;
        }

        public final Builder addLinksModuleDataUris(Collection<UriData> collection) {
            this.zzbr.zzf(collection);
            return this;
        }

        public final Builder addLinksModuleDataUri(UriData uriData) {
            this.zzbr.zzb(uriData);
            return this;
        }

        public final OfferWalletObject build() {
            OfferWalletObject.this.zzbk = this.zzbr.zzf();
            return OfferWalletObject.this;
        }

        /* synthetic */ Builder(zzaa zzaa2) {
            this();
        }
    }
}

