/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.util.ArrayUtils;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.wallet.wobs.LabelValueRow;
import com.google.android.gms.wallet.wobs.LoyaltyPoints;
import com.google.android.gms.wallet.wobs.TextModuleData;
import com.google.android.gms.wallet.wobs.TimeInterval;
import com.google.android.gms.wallet.wobs.UriData;
import com.google.android.gms.wallet.wobs.WalletObjectMessage;
import com.google.android.gms.wallet.zzu;
import com.google.android.gms.wallet.zzv;
import java.util.ArrayList;
import java.util.Collection;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="LoyaltyWalletObjectCreator")
public final class LoyaltyWalletObject
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<LoyaltyWalletObject> CREATOR = new zzv();
    @SafeParcelable.Field(id=2)
    String zzcf;
    @SafeParcelable.Field(id=3)
    String zzcg;
    @SafeParcelable.Field(id=4)
    String zzch;
    @SafeParcelable.Field(id=5)
    String zzci;
    @SafeParcelable.Field(id=6)
    String zzcj;
    @SafeParcelable.Field(id=7)
    String zzck;
    @SafeParcelable.Field(id=8)
    String zzcl;
    @SafeParcelable.Field(id=9)
    String zzcm;
    @Deprecated
    @SafeParcelable.Field(id=10)
    String zzcn;
    @SafeParcelable.Field(id=11)
    String zzco;
    @SafeParcelable.Field(id=12)
    int state;
    @SafeParcelable.Field(id=13, defaultValueUnchecked="com.google.android.gms.common.util.ArrayUtils.newArrayList()")
    ArrayList<WalletObjectMessage> zzcp;
    @SafeParcelable.Field(id=14)
    TimeInterval zzcq;
    @SafeParcelable.Field(id=15, defaultValueUnchecked="com.google.android.gms.common.util.ArrayUtils.newArrayList()")
    ArrayList<LatLng> zzcr;
    @Deprecated
    @SafeParcelable.Field(id=16)
    String zzcs;
    @Deprecated
    @SafeParcelable.Field(id=17)
    String zzct;
    @SafeParcelable.Field(id=18, defaultValueUnchecked="com.google.android.gms.common.util.ArrayUtils.newArrayList()")
    ArrayList<LabelValueRow> zzcu;
    @SafeParcelable.Field(id=19)
    boolean zzcv;
    @SafeParcelable.Field(id=20, defaultValueUnchecked="com.google.android.gms.common.util.ArrayUtils.newArrayList()")
    ArrayList<UriData> zzcw;
    @SafeParcelable.Field(id=21, defaultValueUnchecked="com.google.android.gms.common.util.ArrayUtils.newArrayList()")
    ArrayList<TextModuleData> zzcx;
    @SafeParcelable.Field(id=22, defaultValueUnchecked="com.google.android.gms.common.util.ArrayUtils.newArrayList()")
    ArrayList<UriData> zzcy;
    @SafeParcelable.Field(id=23)
    LoyaltyPoints zzcz;

    public static Builder newBuilder() {
        return new LoyaltyWalletObject().new Builder(null);
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        LoyaltyWalletObject loyaltyWalletObject = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)2, (String)loyaltyWalletObject.zzcf, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)3, (String)loyaltyWalletObject.zzcg, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)4, (String)loyaltyWalletObject.zzch, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)5, (String)loyaltyWalletObject.zzci, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)6, (String)loyaltyWalletObject.zzcj, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)7, (String)loyaltyWalletObject.zzck, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)8, (String)loyaltyWalletObject.zzcl, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)9, (String)loyaltyWalletObject.zzcm, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)10, (String)loyaltyWalletObject.zzcn, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)11, (String)loyaltyWalletObject.zzco, (boolean)false);
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)12, (int)loyaltyWalletObject.state);
        SafeParcelWriter.writeTypedList((Parcel)parcel2, (int)13, loyaltyWalletObject.zzcp, (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)14, (Parcelable)loyaltyWalletObject.zzcq, (int)n, (boolean)false);
        SafeParcelWriter.writeTypedList((Parcel)parcel2, (int)15, loyaltyWalletObject.zzcr, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)16, (String)loyaltyWalletObject.zzcs, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)17, (String)loyaltyWalletObject.zzct, (boolean)false);
        SafeParcelWriter.writeTypedList((Parcel)parcel2, (int)18, loyaltyWalletObject.zzcu, (boolean)false);
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)19, (boolean)loyaltyWalletObject.zzcv);
        SafeParcelWriter.writeTypedList((Parcel)parcel2, (int)20, loyaltyWalletObject.zzcw, (boolean)false);
        SafeParcelWriter.writeTypedList((Parcel)parcel2, (int)21, loyaltyWalletObject.zzcx, (boolean)false);
        SafeParcelWriter.writeTypedList((Parcel)parcel2, (int)22, loyaltyWalletObject.zzcy, (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)23, (Parcelable)loyaltyWalletObject.zzcz, (int)n, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    @SafeParcelable.Constructor
    LoyaltyWalletObject(@SafeParcelable.Param(id=2) String string, @SafeParcelable.Param(id=3) String string2, @SafeParcelable.Param(id=4) String string3, @SafeParcelable.Param(id=5) String string4, @SafeParcelable.Param(id=6) String string5, @SafeParcelable.Param(id=7) String string6, @SafeParcelable.Param(id=8) String string7, @SafeParcelable.Param(id=9) String string8, @SafeParcelable.Param(id=10) String string9, @SafeParcelable.Param(id=11) String string10, @SafeParcelable.Param(id=12) int n, @SafeParcelable.Param(id=13) ArrayList<WalletObjectMessage> arrayList, @SafeParcelable.Param(id=14) TimeInterval timeInterval, @SafeParcelable.Param(id=15) ArrayList<LatLng> arrayList2, @SafeParcelable.Param(id=16) String string11, @SafeParcelable.Param(id=17) String string12, @SafeParcelable.Param(id=18) ArrayList<LabelValueRow> arrayList3, @SafeParcelable.Param(id=19) boolean bl, @SafeParcelable.Param(id=20) ArrayList<UriData> arrayList4, @SafeParcelable.Param(id=21) ArrayList<TextModuleData> arrayList5, @SafeParcelable.Param(id=22) ArrayList<UriData> arrayList6, @SafeParcelable.Param(id=23) LoyaltyPoints loyaltyPoints) {
        this.zzcf = string;
        this.zzcg = string2;
        this.zzch = string3;
        this.zzci = string4;
        this.zzcj = string5;
        this.zzck = string6;
        this.zzcl = string7;
        this.zzcm = string8;
        this.zzcn = string9;
        this.zzco = string10;
        this.state = n;
        this.zzcp = arrayList;
        this.zzcq = timeInterval;
        this.zzcr = arrayList2;
        this.zzcs = string11;
        this.zzct = string12;
        this.zzcu = arrayList3;
        this.zzcv = bl;
        this.zzcw = arrayList4;
        this.zzcx = arrayList5;
        this.zzcy = arrayList6;
        this.zzcz = loyaltyPoints;
    }

    LoyaltyWalletObject() {
        this.zzcp = ArrayUtils.newArrayList();
        this.zzcr = ArrayUtils.newArrayList();
        this.zzcu = ArrayUtils.newArrayList();
        this.zzcw = ArrayUtils.newArrayList();
        this.zzcx = ArrayUtils.newArrayList();
        this.zzcy = ArrayUtils.newArrayList();
    }

    public final String getId() {
        return this.zzcf;
    }

    public final String getAccountId() {
        return this.zzcg;
    }

    public final String getIssuerName() {
        return this.zzch;
    }

    public final String getProgramName() {
        return this.zzci;
    }

    public final String getAccountName() {
        return this.zzcj;
    }

    public final String getBarcodeAlternateText() {
        return this.zzck;
    }

    public final String getBarcodeType() {
        return this.zzcl;
    }

    public final String getBarcodeValue() {
        return this.zzcm;
    }

    @Deprecated
    public final String getBarcodeLabel() {
        return this.zzcn;
    }

    public final String getClassId() {
        return this.zzco;
    }

    public final int getState() {
        return this.state;
    }

    public final ArrayList<WalletObjectMessage> getMessages() {
        return this.zzcp;
    }

    public final TimeInterval getValidTimeInterval() {
        return this.zzcq;
    }

    public final ArrayList<LatLng> getLocations() {
        return this.zzcr;
    }

    @Deprecated
    public final String getInfoModuleDataHexFontColor() {
        return this.zzcs;
    }

    @Deprecated
    public final String getInfoModuleDataHexBackgroundColor() {
        return this.zzct;
    }

    public final ArrayList<LabelValueRow> getInfoModuleDataLabelValueRows() {
        return this.zzcu;
    }

    public final boolean getInfoModuleDataShowLastUpdateTime() {
        return this.zzcv;
    }

    public final ArrayList<UriData> getImageModuleDataMainImageUris() {
        return this.zzcw;
    }

    public final ArrayList<TextModuleData> getTextModulesData() {
        return this.zzcx;
    }

    public final ArrayList<UriData> getLinksModuleDataUris() {
        return this.zzcy;
    }

    public final LoyaltyPoints getLoyaltyPoints() {
        return this.zzcz;
    }

    public final class Builder {
        private Builder() {
        }

        public final Builder setId(String string) {
            LoyaltyWalletObject.this.zzcf = string;
            return this;
        }

        public final Builder setAccountId(String string) {
            LoyaltyWalletObject.this.zzcg = string;
            return this;
        }

        public final Builder setIssuerName(String string) {
            LoyaltyWalletObject.this.zzch = string;
            return this;
        }

        public final Builder setProgramName(String string) {
            LoyaltyWalletObject.this.zzci = string;
            return this;
        }

        public final Builder setAccountName(String string) {
            LoyaltyWalletObject.this.zzcj = string;
            return this;
        }

        public final Builder setBarcodeAlternateText(String string) {
            LoyaltyWalletObject.this.zzck = string;
            return this;
        }

        public final Builder setBarcodeType(String string) {
            LoyaltyWalletObject.this.zzcl = string;
            return this;
        }

        public final Builder setBarcodeValue(String string) {
            LoyaltyWalletObject.this.zzcm = string;
            return this;
        }

        @Deprecated
        public final Builder setBarcodeLabel(String string) {
            LoyaltyWalletObject.this.zzcn = string;
            return this;
        }

        public final Builder setClassId(String string) {
            LoyaltyWalletObject.this.zzco = string;
            return this;
        }

        public final Builder setState(int n) {
            LoyaltyWalletObject.this.state = n;
            return this;
        }

        public final Builder addMessages(Collection<WalletObjectMessage> collection) {
            LoyaltyWalletObject.this.zzcp.addAll(collection);
            return this;
        }

        public final Builder addMessage(WalletObjectMessage walletObjectMessage) {
            LoyaltyWalletObject.this.zzcp.add(walletObjectMessage);
            return this;
        }

        public final Builder setValidTimeInterval(TimeInterval timeInterval) {
            LoyaltyWalletObject.this.zzcq = timeInterval;
            return this;
        }

        public final Builder addLocations(Collection<LatLng> collection) {
            LoyaltyWalletObject.this.zzcr.addAll(collection);
            return this;
        }

        public final Builder addLocation(LatLng latLng) {
            LoyaltyWalletObject.this.zzcr.add(latLng);
            return this;
        }

        @Deprecated
        public final Builder setInfoModuleDataHexFontColor(String string) {
            LoyaltyWalletObject.this.zzcs = string;
            return this;
        }

        @Deprecated
        public final Builder setInfoModuleDataHexBackgroundColor(String string) {
            LoyaltyWalletObject.this.zzct = string;
            return this;
        }

        public final Builder addInfoModuleDataLabelValueRows(Collection<LabelValueRow> collection) {
            LoyaltyWalletObject.this.zzcu.addAll(collection);
            return this;
        }

        public final Builder addInfoModuleDataLabeValueRow(LabelValueRow labelValueRow) {
            LoyaltyWalletObject.this.zzcu.add(labelValueRow);
            return this;
        }

        public final Builder setInfoModuleDataShowLastUpdateTime(boolean bl) {
            LoyaltyWalletObject.this.zzcv = bl;
            return this;
        }

        public final Builder addImageModuleDataMainImageUris(Collection<UriData> collection) {
            LoyaltyWalletObject.this.zzcw.addAll(collection);
            return this;
        }

        public final Builder addImageModuleDataMainImageUri(UriData uriData) {
            LoyaltyWalletObject.this.zzcw.add(uriData);
            return this;
        }

        public final Builder addTextModulesData(Collection<TextModuleData> collection) {
            LoyaltyWalletObject.this.zzcx.addAll(collection);
            return this;
        }

        public final Builder addTextModuleData(TextModuleData textModuleData) {
            LoyaltyWalletObject.this.zzcx.add(textModuleData);
            return this;
        }

        public final Builder addLinksModuleDataUris(Collection<UriData> collection) {
            LoyaltyWalletObject.this.zzcy.addAll(collection);
            return this;
        }

        public final Builder addLinksModuleDataUri(UriData uriData) {
            LoyaltyWalletObject.this.zzcy.add(uriData);
            return this;
        }

        public final Builder setLoyaltyPoints(LoyaltyPoints loyaltyPoints) {
            LoyaltyWalletObject.this.zzcz = loyaltyPoints;
            return this;
        }

        public final LoyaltyWalletObject build() {
            return LoyaltyWalletObject.this;
        }

        /* synthetic */ Builder(zzu zzu2) {
            this();
        }
    }
}

