/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.wallet.CardRequirements;
import com.google.android.gms.wallet.PaymentMethodTokenizationParameters;
import com.google.android.gms.wallet.ShippingAddressRequirements;
import com.google.android.gms.wallet.TransactionInfo;
import com.google.android.gms.wallet.zzad;
import com.google.android.gms.wallet.zzae;
import java.util.ArrayList;
import java.util.Collection;

@SafeParcelable.Class(creator="PaymentDataRequestCreator")
public final class PaymentDataRequest
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<PaymentDataRequest> CREATOR = new zzae();
    @SafeParcelable.Field(id=1)
    boolean zzdv;
    @SafeParcelable.Field(id=2)
    boolean zzdd;
    @SafeParcelable.Field(id=3)
    CardRequirements zzdw;
    @SafeParcelable.Field(id=4)
    boolean zzde;
    @SafeParcelable.Field(id=5)
    ShippingAddressRequirements zzdx;
    @SafeParcelable.Field(id=6)
    ArrayList<Integer> zzbw;
    @SafeParcelable.Field(id=7)
    PaymentMethodTokenizationParameters zzdo;
    @SafeParcelable.Field(id=8)
    TransactionInfo zzdy;
    @SafeParcelable.Field(id=9, defaultValue="true")
    boolean zzdz;
    @SafeParcelable.Field(id=10)
    String zzby;

    @SafeParcelable.Constructor
    PaymentDataRequest(@SafeParcelable.Param(id=1) boolean bl, @SafeParcelable.Param(id=2) boolean bl2, @SafeParcelable.Param(id=3) CardRequirements cardRequirements, @SafeParcelable.Param(id=4) boolean bl3, @SafeParcelable.Param(id=5) ShippingAddressRequirements shippingAddressRequirements, @SafeParcelable.Param(id=6) ArrayList<Integer> arrayList, @SafeParcelable.Param(id=7) PaymentMethodTokenizationParameters paymentMethodTokenizationParameters, @SafeParcelable.Param(id=8) TransactionInfo transactionInfo, @SafeParcelable.Param(id=9) boolean bl4, @SafeParcelable.Param(id=10) String string) {
        this.zzdv = bl;
        this.zzdd = bl2;
        this.zzdw = cardRequirements;
        this.zzde = bl3;
        this.zzdx = shippingAddressRequirements;
        this.zzbw = arrayList;
        this.zzdo = paymentMethodTokenizationParameters;
        this.zzdy = transactionInfo;
        this.zzdz = bl4;
        this.zzby = string;
    }

    private PaymentDataRequest() {
        this.zzdz = true;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        PaymentDataRequest paymentDataRequest = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)1, (boolean)paymentDataRequest.zzdv);
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)2, (boolean)paymentDataRequest.zzdd);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)3, (Parcelable)paymentDataRequest.zzdw, (int)n, (boolean)false);
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)4, (boolean)paymentDataRequest.zzde);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)5, (Parcelable)paymentDataRequest.zzdx, (int)n, (boolean)false);
        SafeParcelWriter.writeIntegerList((Parcel)parcel2, (int)6, paymentDataRequest.zzbw, (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)7, (Parcelable)paymentDataRequest.zzdo, (int)n, (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)8, (Parcelable)paymentDataRequest.zzdy, (int)n, (boolean)false);
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)9, (boolean)paymentDataRequest.zzdz);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)10, (String)paymentDataRequest.zzby, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    public final boolean isEmailRequired() {
        return this.zzdv;
    }

    public final boolean isPhoneNumberRequired() {
        return this.zzdd;
    }

    @Nullable
    public final CardRequirements getCardRequirements() {
        return this.zzdw;
    }

    public final boolean isShippingAddressRequired() {
        return this.zzde;
    }

    @Nullable
    public final ShippingAddressRequirements getShippingAddressRequirements() {
        return this.zzdx;
    }

    public final ArrayList<Integer> getAllowedPaymentMethods() {
        return this.zzbw;
    }

    public final PaymentMethodTokenizationParameters getPaymentMethodTokenizationParameters() {
        return this.zzdo;
    }

    public final TransactionInfo getTransactionInfo() {
        return this.zzdy;
    }

    public final boolean isUiRequired() {
        return this.zzdz;
    }

    public static Builder newBuilder() {
        return new PaymentDataRequest().new Builder(null);
    }

    public final class Builder {
        private Builder() {
        }

        public final Builder setEmailRequired(boolean bl) {
            PaymentDataRequest.this.zzdv = bl;
            return this;
        }

        public final Builder setPhoneNumberRequired(boolean bl) {
            PaymentDataRequest.this.zzdd = bl;
            return this;
        }

        public final Builder setCardRequirements(@NonNull CardRequirements cardRequirements) {
            PaymentDataRequest.this.zzdw = cardRequirements;
            return this;
        }

        public final Builder setShippingAddressRequired(boolean bl) {
            PaymentDataRequest.this.zzde = bl;
            return this;
        }

        public final Builder setShippingAddressRequirements(@NonNull ShippingAddressRequirements shippingAddressRequirements) {
            PaymentDataRequest.this.zzdx = shippingAddressRequirements;
            return this;
        }

        public final Builder addAllowedPaymentMethod(int n) {
            if (PaymentDataRequest.this.zzbw == null) {
                PaymentDataRequest.this.zzbw = new ArrayList();
            }
            PaymentDataRequest.this.zzbw.add(n);
            return this;
        }

        public final Builder addAllowedPaymentMethods(@NonNull Collection<Integer> collection) {
            Preconditions.checkArgument((collection != null && !collection.isEmpty() ? 1 : 0) != 0, (Object)"allowedPaymentMethods can't be null or empty!");
            if (PaymentDataRequest.this.zzbw == null) {
                PaymentDataRequest.this.zzbw = new ArrayList();
            }
            PaymentDataRequest.this.zzbw.addAll(collection);
            return this;
        }

        public final Builder setPaymentMethodTokenizationParameters(PaymentMethodTokenizationParameters paymentMethodTokenizationParameters) {
            PaymentDataRequest.this.zzdo = paymentMethodTokenizationParameters;
            return this;
        }

        public final Builder setTransactionInfo(@NonNull TransactionInfo transactionInfo) {
            PaymentDataRequest.this.zzdy = transactionInfo;
            return this;
        }

        public final Builder setUiRequired(boolean bl) {
            PaymentDataRequest.this.zzdz = bl;
            return this;
        }

        public final PaymentDataRequest build() {
            if (PaymentDataRequest.this.zzby == null) {
                Preconditions.checkNotNull(PaymentDataRequest.this.zzbw, (Object)"Allowed payment methods must be set! You can set it through addAllowedPaymentMethod() or addAllowedPaymentMethods() in the PaymentDataRequest Builder.");
                Preconditions.checkNotNull((Object)((Object)PaymentDataRequest.this.zzdw), (Object)"Card requirements must be set!");
                if (PaymentDataRequest.this.zzdo != null) {
                    Preconditions.checkNotNull((Object)((Object)PaymentDataRequest.this.zzdy), (Object)"Transaction info must be set if paymentMethodTokenizationParameters is set!");
                }
            }
            return PaymentDataRequest.this;
        }

        /* synthetic */ Builder(zzad zzad2) {
            this();
        }
    }
}

