/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet.fragment;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Fragment;
import android.app.FragmentManager;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.RemoteException;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.FrameLayout;
import com.google.android.gms.R;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.LifecycleDelegate;
import com.google.android.gms.dynamic.zzj;
import com.google.android.gms.dynamic.zzk;
import com.google.android.gms.dynamic.zzn;
import com.google.android.gms.dynamic.zzo;
import com.google.android.gms.internal.zzdmd;
import com.google.android.gms.internal.zzdmh;
import com.google.android.gms.internal.zzdnc;
import com.google.android.gms.wallet.MaskedWallet;
import com.google.android.gms.wallet.MaskedWalletRequest;
import com.google.android.gms.wallet.fragment.WalletFragmentInitParams;
import com.google.android.gms.wallet.fragment.WalletFragmentOptions;
import com.google.android.gms.wallet.fragment.WalletFragmentStyle;

@TargetApi(value=12)
public final class WalletFragment
extends Fragment {
    private zzb zzlpb;
    private boolean mCreated = false;
    private final zzj zzlpc = zzj.zza((Fragment)this);
    private final zzc zzlpd = new zzc(this, null);
    private zza zzlpe = new zza(this);
    private final Fragment zzhcy = this;
    private WalletFragmentOptions zzlos;
    private WalletFragmentInitParams zzlot;
    private MaskedWalletRequest zzlou;
    private MaskedWallet zzlov;
    private Boolean zzlow;

    public WalletFragment() {
    }

    public static WalletFragment newInstance(WalletFragmentOptions walletFragmentOptions) {
        WalletFragment walletFragment = new WalletFragment();
        Bundle bundle = new Bundle();
        bundle.putParcelable("extraWalletFragmentOptions", (Parcelable)walletFragmentOptions);
        walletFragment.zzhcy.setArguments(bundle);
        return walletFragment;
    }

    public final void initialize(WalletFragmentInitParams walletFragmentInitParams) {
        if (this.zzlpb != null) {
            this.zzlpb.initialize(walletFragmentInitParams);
            this.zzlot = null;
            return;
        }
        if (this.zzlot == null) {
            this.zzlot = walletFragmentInitParams;
            if (this.zzlou != null) {
                Log.w((String)"WalletFragment", (String)"updateMaskedWalletRequest() was called before initialize()");
            }
            if (this.zzlov != null) {
                Log.w((String)"WalletFragment", (String)"updateMaskedWallet() was called before initialize()");
                return;
            }
        } else {
            Log.w((String)"WalletFragment", (String)"initialize(WalletFragmentInitParams) was called more than once. Ignoring.");
        }
    }

    public final void updateMaskedWalletRequest(MaskedWalletRequest maskedWalletRequest) {
        if (this.zzlpb != null) {
            this.zzlpb.updateMaskedWalletRequest(maskedWalletRequest);
            this.zzlou = null;
            return;
        }
        this.zzlou = maskedWalletRequest;
    }

    public final void updateMaskedWallet(MaskedWallet maskedWallet) {
        if (this.zzlpb != null) {
            this.zzlpb.updateMaskedWallet(maskedWallet);
            this.zzlov = null;
            return;
        }
        this.zzlov = maskedWallet;
    }

    public final void setEnabled(boolean bl) {
        if (this.zzlpb != null) {
            this.zzlpb.setEnabled(bl);
            this.zzlow = null;
            return;
        }
        this.zzlow = bl;
    }

    public final void setOnStateChangedListener(OnStateChangedListener onStateChangedListener) {
        this.zzlpe.zza(onStateChangedListener);
    }

    public final int getState() {
        if (this.zzlpb != null) {
            return this.zzlpb.getState();
        }
        return 0;
    }

    public final void onInflate(Activity activity, AttributeSet attributeSet, Bundle bundle) {
        super.onInflate(activity, attributeSet, bundle);
        if (this.zzlos == null) {
            this.zzlos = WalletFragmentOptions.zza((Context)activity, attributeSet);
        }
        Bundle bundle2 = new Bundle();
        bundle2.putParcelable("attrKeyWalletFragmentOptions", (Parcelable)this.zzlos);
        this.zzlpd.onInflate(activity, bundle2, bundle);
    }

    public final void onCreate(Bundle bundle) {
        WalletFragmentOptions walletFragmentOptions;
        super.onCreate(bundle);
        if (bundle != null) {
            bundle.setClassLoader(WalletFragmentOptions.class.getClassLoader());
            WalletFragmentInitParams walletFragmentInitParams = (WalletFragmentInitParams)bundle.getParcelable("walletFragmentInitParams");
            if (walletFragmentInitParams != null) {
                if (this.zzlot != null) {
                    Log.w((String)"WalletFragment", (String)"initialize(WalletFragmentInitParams) was called more than once.Ignoring.");
                }
                this.zzlot = walletFragmentInitParams;
            }
            if (this.zzlou == null) {
                this.zzlou = (MaskedWalletRequest)bundle.getParcelable("maskedWalletRequest");
            }
            if (this.zzlov == null) {
                this.zzlov = (MaskedWallet)bundle.getParcelable("maskedWallet");
            }
            if (bundle.containsKey("walletFragmentOptions")) {
                this.zzlos = (WalletFragmentOptions)bundle.getParcelable("walletFragmentOptions");
            }
            if (bundle.containsKey("enabled")) {
                this.zzlow = bundle.getBoolean("enabled");
            }
        } else if (this.zzhcy.getArguments() != null && (walletFragmentOptions = (WalletFragmentOptions)this.zzhcy.getArguments().getParcelable("extraWalletFragmentOptions")) != null) {
            walletFragmentOptions.zzet((Context)this.zzhcy.getActivity());
            this.zzlos = walletFragmentOptions;
        }
        this.mCreated = true;
        this.zzlpd.onCreate(bundle);
    }

    public final View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        return this.zzlpd.onCreateView(layoutInflater, viewGroup, bundle);
    }

    public final void onStart() {
        super.onStart();
        this.zzlpd.onStart();
    }

    public final void onResume() {
        super.onResume();
        this.zzlpd.onResume();
        FragmentManager fragmentManager = this.zzhcy.getActivity().getFragmentManager();
        Fragment fragment = fragmentManager.findFragmentByTag("GooglePlayServicesErrorDialog");
        if (fragment != null) {
            fragmentManager.beginTransaction().remove(fragment).commit();
            GooglePlayServicesUtil.showErrorDialogFragment((int)GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)this.zzhcy.getActivity()), (Activity)this.zzhcy.getActivity(), (int)-1);
        }
    }

    public final void onPause() {
        super.onPause();
        this.zzlpd.onPause();
    }

    public final void onStop() {
        super.onStop();
        this.zzlpd.onStop();
    }

    public final void onSaveInstanceState(Bundle bundle) {
        super.onSaveInstanceState(bundle);
        bundle.setClassLoader(WalletFragmentOptions.class.getClassLoader());
        this.zzlpd.onSaveInstanceState(bundle);
        if (this.zzlot != null) {
            bundle.putParcelable("walletFragmentInitParams", (Parcelable)this.zzlot);
            this.zzlot = null;
        }
        if (this.zzlou != null) {
            bundle.putParcelable("maskedWalletRequest", (Parcelable)this.zzlou);
            this.zzlou = null;
        }
        if (this.zzlov != null) {
            bundle.putParcelable("maskedWallet", (Parcelable)this.zzlov);
            this.zzlov = null;
        }
        if (this.zzlos != null) {
            bundle.putParcelable("walletFragmentOptions", (Parcelable)this.zzlos);
            this.zzlos = null;
        }
        if (this.zzlow != null) {
            bundle.putBoolean("enabled", this.zzlow.booleanValue());
            this.zzlow = null;
        }
    }

    public final void onDestroy() {
        super.onDestroy();
        this.mCreated = false;
    }

    public final void onActivityResult(int n, int n2, Intent intent) {
        super.onActivityResult(n, n2, intent);
        if (this.zzlpb != null) {
            this.zzlpb.onActivityResult(n, n2, intent);
        }
    }

    static /* synthetic */ WalletFragmentOptions zza(WalletFragment walletFragment, WalletFragmentOptions walletFragmentOptions) {
        walletFragment.zzlos = null;
        return null;
    }

    static /* synthetic */ WalletFragmentInitParams zza(WalletFragment walletFragment, WalletFragmentInitParams walletFragmentInitParams) {
        walletFragment.zzlot = null;
        return null;
    }

    static /* synthetic */ MaskedWalletRequest zza(WalletFragment walletFragment, MaskedWalletRequest maskedWalletRequest) {
        walletFragment.zzlou = null;
        return null;
    }

    static /* synthetic */ MaskedWallet zza(WalletFragment walletFragment, MaskedWallet maskedWallet) {
        walletFragment.zzlov = null;
        return null;
    }

    static /* synthetic */ Boolean zza(WalletFragment walletFragment, Boolean bl) {
        walletFragment.zzlow = null;
        return null;
    }

    public static interface OnStateChangedListener {
        public void onStateChanged(WalletFragment var1, int var2, int var3, Bundle var4);
    }

    @Hide
    static final class zza
    extends zzdmh {
        private OnStateChangedListener zzlpf;
        private final WalletFragment zzlpg;

        zza(WalletFragment walletFragment) {
            this.zzlpg = walletFragment;
        }

        @Override
        public final void zza(int n, int n2, Bundle bundle) {
            if (this.zzlpf != null) {
                this.zzlpf.onStateChanged(this.zzlpg, n, n2, bundle);
            }
        }

        public final void zza(OnStateChangedListener onStateChangedListener) {
            this.zzlpf = onStateChangedListener;
        }
    }

    static final class zzb
    implements LifecycleDelegate {
        private final zzdmd zzloz;

        private zzb(zzdmd zzdmd2) {
            this.zzloz = zzdmd2;
        }

        private final void initialize(WalletFragmentInitParams walletFragmentInitParams) {
            try {
                this.zzloz.initialize(walletFragmentInitParams);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private final void setEnabled(boolean bl) {
            try {
                this.zzloz.setEnabled(bl);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private final void updateMaskedWalletRequest(MaskedWalletRequest maskedWalletRequest) {
            try {
                this.zzloz.updateMaskedWalletRequest(maskedWalletRequest);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private final void updateMaskedWallet(MaskedWallet maskedWallet) {
            try {
                this.zzloz.updateMaskedWallet(maskedWallet);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private final int getState() {
            try {
                return this.zzloz.getState();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public final void onInflate(Activity activity, Bundle bundle, Bundle bundle2) {
            WalletFragmentOptions walletFragmentOptions = (WalletFragmentOptions)bundle.getParcelable("extraWalletFragmentOptions");
            try {
                this.zzloz.zza(zzn.zzz((Object)activity), walletFragmentOptions, bundle2);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public final void onCreate(Bundle bundle) {
            try {
                this.zzloz.onCreate(bundle);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public final View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
            try {
                return (View)zzn.zzy((IObjectWrapper)this.zzloz.onCreateView(zzn.zzz((Object)layoutInflater), zzn.zzz((Object)viewGroup), bundle));
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public final void onStart() {
            try {
                this.zzloz.onStart();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public final void onResume() {
            try {
                this.zzloz.onResume();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public final void onPause() {
            try {
                this.zzloz.onPause();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public final void onStop() {
            try {
                this.zzloz.onStop();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public final void onDestroyView() {
        }

        public final void onDestroy() {
        }

        public final void onLowMemory() {
        }

        public final void onSaveInstanceState(Bundle bundle) {
            try {
                this.zzloz.onSaveInstanceState(bundle);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private final void onActivityResult(int n, int n2, Intent intent) {
            try {
                this.zzloz.onActivityResult(n, n2, intent);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        /* synthetic */ zzb(zzdmd zzdmd2, com.google.android.gms.wallet.fragment.zzb zzb2) {
            this(zzdmd2);
        }
    }

    final class zzc
    extends com.google.android.gms.dynamic.zza<zzb>
    implements View.OnClickListener {
        private /* synthetic */ WalletFragment zzlph;

        private zzc(WalletFragment walletFragment) {
            this.zzlph = walletFragment;
        }

        protected final void zza(zzo<zzb> zzo2) {
            Activity activity = this.zzlph.zzhcy.getActivity();
            if (this.zzlph.zzlpb == null && this.zzlph.mCreated && activity != null) {
                try {
                    zzdmd zzdmd2 = zzdnc.zza(activity, (zzk)this.zzlph.zzlpc, this.zzlph.zzlos, this.zzlph.zzlpe);
                    this.zzlph.zzlpb = new zzb(zzdmd2, null);
                    WalletFragment.zza(this.zzlph, null);
                }
                catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {
                    return;
                }
                zzo2.zza((LifecycleDelegate)this.zzlph.zzlpb);
                if (this.zzlph.zzlot != null) {
                    this.zzlph.zzlpb.initialize(this.zzlph.zzlot);
                    WalletFragment.zza(this.zzlph, null);
                }
                if (this.zzlph.zzlou != null) {
                    this.zzlph.zzlpb.updateMaskedWalletRequest(this.zzlph.zzlou);
                    WalletFragment.zza(this.zzlph, null);
                }
                if (this.zzlph.zzlov != null) {
                    this.zzlph.zzlpb.updateMaskedWallet(this.zzlph.zzlov);
                    WalletFragment.zza(this.zzlph, null);
                }
                if (this.zzlph.zzlow != null) {
                    this.zzlph.zzlpb.setEnabled(this.zzlph.zzlow);
                    WalletFragment.zza(this.zzlph, null);
                }
            }
        }

        protected final void zza(FrameLayout frameLayout) {
            WalletFragmentStyle walletFragmentStyle;
            Button button = new Button((Context)this.zzlph.zzhcy.getActivity());
            button.setText(R.string.wallet_buy_button_place_holder);
            int n = -1;
            int n2 = -2;
            if (this.zzlph.zzlos != null && (walletFragmentStyle = this.zzlph.zzlos.getFragmentStyle()) != null) {
                DisplayMetrics displayMetrics = this.zzlph.zzhcy.getResources().getDisplayMetrics();
                n = walletFragmentStyle.zza("buyButtonWidth", displayMetrics, -1);
                n2 = walletFragmentStyle.zza("buyButtonHeight", displayMetrics, -2);
            }
            button.setLayoutParams(new ViewGroup.LayoutParams(n, n2));
            button.setOnClickListener((View.OnClickListener)this);
            frameLayout.addView((View)button);
        }

        public final void onClick(View view) {
            Activity activity = this.zzlph.zzhcy.getActivity();
            GooglePlayServicesUtil.showErrorDialogFragment((int)GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)activity), (Activity)activity, (int)-1);
        }

        /* synthetic */ zzc(WalletFragment walletFragment, com.google.android.gms.wallet.fragment.zzb zzb2) {
            this(walletFragment);
        }
    }
}

