/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet;

import android.accounts.Account;
import android.app.Activity;
import android.content.Context;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.zzm;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.internal.zzdlw;
import com.google.android.gms.internal.zzdmo;
import com.google.android.gms.internal.zzdmv;
import com.google.android.gms.internal.zzdnd;
import com.google.android.gms.internal.zzdne;
import com.google.android.gms.wallet.Payments;
import com.google.android.gms.wallet.PaymentsClient;
import com.google.android.gms.wallet.WalletObjectsClient;
import com.google.android.gms.wallet.wobs.WalletObjects;
import com.google.android.gms.wallet.zzap;
import java.util.Arrays;
import java.util.Locale;

public final class Wallet {
    private static final Api.zzf<zzdmv> zzegu = new Api.zzf();
    private static final Api.zza<zzdmv, WalletOptions> zzegv = new zzap();
    public static final Api<WalletOptions> API = new Api("Wallet.API", zzegv, zzegu);
    @Deprecated
    public static final Payments Payments = new zzdmo();
    @Hide
    private static WalletObjects zzloa = new zzdne();
    @Hide
    private static zzdlw zzlob = new zzdnd();

    public static PaymentsClient getPaymentsClient(@NonNull Activity activity, @NonNull WalletOptions walletOptions) {
        return new PaymentsClient(activity, walletOptions);
    }

    public static PaymentsClient getPaymentsClient(@NonNull Context context, @NonNull WalletOptions walletOptions) {
        return new PaymentsClient(context, walletOptions);
    }

    public static WalletObjectsClient getWalletObjectsClient(@NonNull Activity activity, @Nullable WalletOptions walletOptions) {
        return new WalletObjectsClient(activity, walletOptions);
    }

    private Wallet() {
    }

    @Hide
    public static abstract class zzb
    extends zza<Status> {
        public zzb(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        protected final /* synthetic */ Result zzb(Status status) {
            return status;
        }
    }

    @Hide
    public static abstract class zza<R extends Result>
    extends zzm<R, zzdmv> {
        public zza(GoogleApiClient googleApiClient) {
            super(API, googleApiClient);
        }

        @VisibleForTesting
        protected abstract void zza(zzdmv var1) throws RemoteException;
    }

    public static final class WalletOptions
    implements Api.ApiOptions.HasAccountOptions {
        public final int environment;
        public final int theme;
        @Hide
        private Account account;
        @VisibleForTesting
        final boolean zzloc;

        private WalletOptions() {
            this(new Builder());
        }

        private WalletOptions(Builder builder) {
            this.environment = builder.zzlod;
            this.theme = builder.mTheme;
            this.zzloc = builder.zzloe;
            this.account = null;
        }

        public final Account getAccount() {
            return null;
        }

        public final boolean equals(Object object) {
            boolean bl = false;
            if (object instanceof WalletOptions) {
                WalletOptions walletOptions = (WalletOptions)object;
                bl = zzbg.equal((Object)this.environment, (Object)walletOptions.environment) && zzbg.equal((Object)this.theme, (Object)walletOptions.theme) && zzbg.equal(null, null) && zzbg.equal((Object)this.zzloc, (Object)walletOptions.zzloc);
            }
            return bl;
        }

        public final int hashCode() {
            return Arrays.hashCode(new Object[]{this.environment, this.theme, null, this.zzloc});
        }

        /* synthetic */ WalletOptions(Builder builder, zzap zzap2) {
            this(builder);
        }

        /* synthetic */ WalletOptions(zzap zzap2) {
            this();
        }

        public static final class Builder {
            private int zzlod = 3;
            private int mTheme = 0;
            private boolean zzloe = true;

            public Builder() {
            }

            public final Builder setEnvironment(int n) {
                if (n != 0 && n != 0 && n != 2 && n != 1 && n != 3) {
                    String string = String.format(Locale.US, "Invalid environment value %d", n);
                    throw new IllegalArgumentException(string);
                }
                this.zzlod = n;
                return this;
            }

            public final Builder setTheme(int n) {
                if (n != 0 && n != 1) {
                    String string = String.format(Locale.US, "Invalid theme value %d", n);
                    throw new IllegalArgumentException(string);
                }
                this.mTheme = n;
                return this;
            }

            @Deprecated
            public final Builder useGoogleWallet() {
                this.zzloe = false;
                return this;
            }

            public final WalletOptions build() {
                return new WalletOptions(this, null);
            }
        }
    }
}

