/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet;

import android.accounts.Account;
import android.app.Activity;
import android.content.Context;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.zzm;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.internal.zzdjn;
import com.google.android.gms.internal.zzdkf;
import com.google.android.gms.internal.zzdkm;
import com.google.android.gms.internal.zzdku;
import com.google.android.gms.internal.zzdkv;
import com.google.android.gms.wallet.Payments;
import com.google.android.gms.wallet.PaymentsClient;
import com.google.android.gms.wallet.WalletObjectsClient;
import com.google.android.gms.wallet.wobs.WalletObjects;
import com.google.android.gms.wallet.zzap;
import java.util.Arrays;
import java.util.Locale;

public final class Wallet {
    private static final Api.zzf<zzdkm> zzdyh = new Api.zzf();
    private static final Api.zza<zzdkm, WalletOptions> zzdyi = new zzap();
    public static final Api<WalletOptions> API = new Api("Wallet.API", zzdyi, zzdyh);
    @Deprecated
    public static final Payments Payments = new zzdkf();
    private static WalletObjects zzlbb = new zzdkv();
    private static zzdjn zzlbc = new zzdku();

    public static PaymentsClient getPaymentsClient(@NonNull Activity activity, @NonNull WalletOptions walletOptions) {
        return new PaymentsClient(activity, walletOptions);
    }

    public static PaymentsClient getPaymentsClient(@NonNull Context context, @NonNull WalletOptions walletOptions) {
        return new PaymentsClient(context, walletOptions);
    }

    public static WalletObjectsClient getWalletObjectsClient(@NonNull Activity activity, @Nullable WalletOptions walletOptions) {
        return new WalletObjectsClient(activity, walletOptions);
    }

    private Wallet() {
    }

    public static abstract class zzb
    extends zza<Status> {
        public zzb(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        protected final /* synthetic */ Result zzb(Status status) {
            return status;
        }
    }

    public static abstract class zza<R extends Result>
    extends zzm<R, zzdkm> {
        public zza(GoogleApiClient googleApiClient) {
            super(API, googleApiClient);
        }

        @VisibleForTesting
        protected abstract void zza(zzdkm var1) throws RemoteException;
    }

    public static final class WalletOptions
    implements Api.ApiOptions.HasAccountOptions {
        public final int environment;
        public final int theme;
        private Account account;
        @VisibleForTesting
        final boolean zzlbd;

        private WalletOptions() {
            this(new Builder());
        }

        private WalletOptions(Builder builder) {
            this.environment = builder.zzlbe;
            this.theme = builder.mTheme;
            this.zzlbd = builder.zzlbf;
            this.account = null;
        }

        public final Account getAccount() {
            return null;
        }

        public final boolean equals(Object object) {
            boolean bl = false;
            if (object instanceof WalletOptions) {
                WalletOptions walletOptions = (WalletOptions)object;
                bl = zzbg.equal((Object)this.environment, (Object)walletOptions.environment) && zzbg.equal((Object)this.theme, (Object)walletOptions.theme) && zzbg.equal(null, null) && zzbg.equal((Object)this.zzlbd, (Object)walletOptions.zzlbd);
            }
            return bl;
        }

        public final int hashCode() {
            return Arrays.hashCode(new Object[]{this.environment, this.theme, null, this.zzlbd});
        }

        /* synthetic */ WalletOptions(Builder builder, zzap zzap2) {
            this(builder);
        }

        /* synthetic */ WalletOptions(zzap zzap2) {
            this();
        }

        public static final class Builder {
            private int zzlbe = 3;
            private int mTheme = 0;
            private boolean zzlbf = true;

            public Builder() {
            }

            public final Builder setEnvironment(int n) {
                if (n != 0 && n != 0 && n != 2 && n != 1 && n != 3) {
                    String string = String.format(Locale.US, "Invalid environment value %d", n);
                    throw new IllegalArgumentException(string);
                }
                this.zzlbe = n;
                return this;
            }

            public final Builder setTheme(int n) {
                if (n != 0 && n != 1) {
                    String string = String.format(Locale.US, "Invalid theme value %d", n);
                    throw new IllegalArgumentException(string);
                }
                this.mTheme = n;
                return this;
            }

            @Deprecated
            public final Builder useGoogleWallet() {
                this.zzlbf = false;
                return this;
            }

            public final WalletOptions build() {
                return new WalletOptions(this, null);
            }
        }
    }
}

