/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.accounts.Account;
import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Parcelable;
import android.os.RemoteException;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.api.BooleanResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.zzn;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.common.internal.zzr;
import com.google.android.gms.internal.zzdjz;
import com.google.android.gms.internal.zzdka;
import com.google.android.gms.internal.zzdkd;
import com.google.android.gms.internal.zzdkn;
import com.google.android.gms.internal.zzdko;
import com.google.android.gms.internal.zzdkp;
import com.google.android.gms.internal.zzdkq;
import com.google.android.gms.internal.zzdkr;
import com.google.android.gms.internal.zzdks;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.android.gms.wallet.AutoResolvableVoidResult;
import com.google.android.gms.wallet.CreateWalletObjectsRequest;
import com.google.android.gms.wallet.FullWallet;
import com.google.android.gms.wallet.FullWalletRequest;
import com.google.android.gms.wallet.IsReadyToPayRequest;
import com.google.android.gms.wallet.MaskedWallet;
import com.google.android.gms.wallet.MaskedWalletRequest;
import com.google.android.gms.wallet.PaymentData;
import com.google.android.gms.wallet.PaymentDataRequest;

public final class zzdkm
extends zzab<zzdjz> {
    private final Context mContext;
    private final int zzlbe;
    private final String zzdyx;
    private final int mTheme;
    private final boolean zzlbf;

    public zzdkm(Context context, Looper looper, zzr zzr2, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener, int n, int n2, boolean bl) {
        super(context, looper, 4, zzr2, connectionCallbacks, onConnectionFailedListener);
        this.mContext = context;
        this.zzlbe = n;
        this.zzdyx = zzr2.getAccountName();
        this.mTheme = n2;
        this.zzlbf = bl;
    }

    public final boolean zzakc() {
        return true;
    }

    protected final String zzhf() {
        return "com.google.android.gms.wallet.service.BIND";
    }

    protected final String zzhg() {
        return "com.google.android.gms.wallet.internal.IOwService";
    }

    public final void zzfb(int n) {
        Bundle bundle = this.zzbjo();
        zzdkn zzdkn2 = new zzdkn((Activity)this.mContext, n);
        try {
            ((zzdjz)this.zzakb()).zza(bundle, zzdkn2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e((String)"WalletClientImpl", (String)"RemoteException during checkForPreAuthorization", (Throwable)remoteException);
            ((zzdko)zzdkn2).zza(8, false, Bundle.EMPTY);
            return;
        }
    }

    public final void zzc(String string, String string2, int n) {
        int n2 = n;
        String string3 = string2;
        String string4 = string;
        Activity activity = (Activity)this.mContext;
        zzdkm zzdkm2 = this;
        Bundle bundle = zzdkm2.zzbjo();
        zzdkn zzdkn2 = new zzdkn(activity, n2);
        try {
            ((zzdjz)zzdkm2.zzakb()).zza(string4, string3, bundle, zzdkn2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e((String)"WalletClientImpl", (String)"RemoteException changing masked wallet", (Throwable)remoteException);
            ((zzdko)zzdkn2).zza(8, (MaskedWallet)null, Bundle.EMPTY);
            return;
        }
    }

    public final void zza(MaskedWalletRequest maskedWalletRequest, int n) {
        int n2 = n;
        MaskedWalletRequest maskedWalletRequest2 = maskedWalletRequest;
        Activity activity = (Activity)this.mContext;
        zzdkm zzdkm2 = this;
        Bundle bundle = zzdkm2.zzbjo();
        zzdkn zzdkn2 = new zzdkn(activity, n2);
        try {
            ((zzdjz)zzdkm2.zzakb()).zza(maskedWalletRequest2, bundle, (zzdkd)zzdkn2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e((String)"WalletClientImpl", (String)"RemoteException getting masked wallet", (Throwable)remoteException);
            ((zzdko)zzdkn2).zza(8, (MaskedWallet)null, Bundle.EMPTY);
            return;
        }
    }

    public final void zza(FullWalletRequest fullWalletRequest, int n) {
        int n2 = n;
        FullWalletRequest fullWalletRequest2 = fullWalletRequest;
        Activity activity = (Activity)this.mContext;
        zzdkm zzdkm2 = this;
        zzdkn zzdkn2 = new zzdkn(activity, n2);
        Bundle bundle = zzdkm2.zzbjo();
        try {
            ((zzdjz)zzdkm2.zzakb()).zza(fullWalletRequest2, bundle, (zzdkd)zzdkn2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e((String)"WalletClientImpl", (String)"RemoteException getting full wallet", (Throwable)remoteException);
            ((zzdko)zzdkn2).zza(8, (FullWallet)null, Bundle.EMPTY);
            return;
        }
    }

    public final void zza(CreateWalletObjectsRequest createWalletObjectsRequest, int n) {
        zzdkn zzdkn2 = new zzdkn((Activity)this.mContext, n);
        Bundle bundle = this.zzbjo();
        try {
            ((zzdjz)this.zzakb()).zza(createWalletObjectsRequest, bundle, (zzdkd)zzdkn2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e((String)"WalletClientImpl", (String)"RemoteException creating wallet objects", (Throwable)remoteException);
            ((zzdko)zzdkn2).zzg(8, Bundle.EMPTY);
            return;
        }
    }

    public final void zza(CreateWalletObjectsRequest createWalletObjectsRequest, TaskCompletionSource<AutoResolvableVoidResult> taskCompletionSource) {
        Bundle bundle = this.zzbjo();
        bundle.putBoolean("com.google.android.gms.wallet.EXTRA_USING_AUTO_RESOLVABLE_RESULT", true);
        zzdkq zzdkq2 = new zzdkq(taskCompletionSource);
        try {
            ((zzdjz)this.zzakb()).zza(createWalletObjectsRequest, bundle, (zzdkd)zzdkq2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e((String)"WalletClientImpl", (String)"RemoteException creating wallet objects", (Throwable)remoteException);
            ((zzdko)zzdkq2).zzg(8, Bundle.EMPTY);
            return;
        }
    }

    public final void zza(IsReadyToPayRequest isReadyToPayRequest, zzn<BooleanResult> zzn2) {
        zzdkr zzdkr2 = new zzdkr(zzn2);
        Bundle bundle = this.zzbjo();
        try {
            ((zzdjz)this.zzakb()).zza(isReadyToPayRequest, bundle, (zzdkd)zzdkr2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e((String)"WalletClientImpl", (String)"RemoteException during isReadyToPay", (Throwable)remoteException);
            ((zzdko)zzdkr2).zza(Status.zzfkq, false, Bundle.EMPTY);
            return;
        }
    }

    public final void zza(PaymentDataRequest paymentDataRequest, TaskCompletionSource<PaymentData> taskCompletionSource) {
        Bundle bundle = this.zzbjo();
        bundle.putBoolean("com.google.android.gms.wallet.EXTRA_USING_AUTO_RESOLVABLE_RESULT", true);
        zzdks zzdks2 = new zzdks(taskCompletionSource);
        try {
            ((zzdjz)this.zzakb()).zza(paymentDataRequest, bundle, (zzdkd)zzdks2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e((String)"WalletClientImpl", (String)"RemoteException getting payment data", (Throwable)remoteException);
            ((zzdko)zzdks2).zza(Status.zzfkq, null, Bundle.EMPTY);
            return;
        }
    }

    public final void zza(IsReadyToPayRequest isReadyToPayRequest, TaskCompletionSource<Boolean> taskCompletionSource) throws RemoteException {
        zzdkp zzdkp2 = new zzdkp(taskCompletionSource);
        try {
            ((zzdjz)this.zzakb()).zza(isReadyToPayRequest, this.zzbjo(), (zzdkd)zzdkp2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e((String)"WalletClientImpl", (String)"RemoteException during isReadyToPay", (Throwable)remoteException);
            ((zzdko)zzdkp2).zza(Status.zzfkq, false, Bundle.EMPTY);
            return;
        }
    }

    private final Bundle zzbjo() {
        boolean bl = this.zzlbf;
        int n = this.mTheme;
        String string = this.zzdyx;
        String string2 = this.mContext.getPackageName();
        int n2 = this.zzlbe;
        Bundle bundle = new Bundle();
        bundle.putInt("com.google.android.gms.wallet.EXTRA_ENVIRONMENT", n2);
        bundle.putBoolean("com.google.android.gms.wallet.EXTRA_USING_ANDROID_PAY_BRAND", bl);
        bundle.putString("androidPackageName", string2);
        if (!TextUtils.isEmpty((CharSequence)string)) {
            bundle.putParcelable("com.google.android.gms.wallet.EXTRA_BUYER_ACCOUNT", (Parcelable)new Account(string, "com.google"));
        }
        bundle.putInt("com.google.android.gms.wallet.EXTRA_THEME", n);
        return bundle;
    }

    protected final /* synthetic */ IInterface zzd(IBinder iBinder) {
        IBinder iBinder2 = iBinder;
        if (iBinder2 == null) {
            return null;
        }
        IInterface iInterface = iBinder2.queryLocalInterface("com.google.android.gms.wallet.internal.IOwService");
        if (iInterface instanceof zzdjz) {
            return (zzdjz)iInterface;
        }
        return new zzdka(iBinder2);
    }
}

