/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet.fragment;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.RemoteException;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.FrameLayout;
import com.google.android.gms.R;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.LifecycleDelegate;
import com.google.android.gms.dynamic.zzk;
import com.google.android.gms.dynamic.zzn;
import com.google.android.gms.dynamic.zzo;
import com.google.android.gms.dynamic.zzr;
import com.google.android.gms.internal.zzdju;
import com.google.android.gms.internal.zzdjy;
import com.google.android.gms.internal.zzdkt;
import com.google.android.gms.wallet.MaskedWallet;
import com.google.android.gms.wallet.MaskedWalletRequest;
import com.google.android.gms.wallet.fragment.WalletFragmentInitParams;
import com.google.android.gms.wallet.fragment.WalletFragmentOptions;
import com.google.android.gms.wallet.fragment.WalletFragmentStyle;

public final class SupportWalletFragment
extends Fragment {
    private zzb zzlbz;
    private boolean mCreated = false;
    private final zzr zzlca = zzr.zza((Fragment)this);
    private final zzc zzlcb = new zzc(this, null);
    private zza zzlcc = new zza(this);
    private final Fragment zzguf = this;
    private WalletFragmentOptions zzlcd;
    private WalletFragmentInitParams zzlce;
    private MaskedWalletRequest zzlcf;
    private MaskedWallet zzlcg;
    private Boolean zzlch;

    public SupportWalletFragment() {
    }

    public static SupportWalletFragment newInstance(WalletFragmentOptions walletFragmentOptions) {
        SupportWalletFragment supportWalletFragment = new SupportWalletFragment();
        Bundle bundle = new Bundle();
        bundle.putParcelable("extraWalletFragmentOptions", (Parcelable)walletFragmentOptions);
        supportWalletFragment.zzguf.setArguments(bundle);
        return supportWalletFragment;
    }

    public final void initialize(WalletFragmentInitParams walletFragmentInitParams) {
        if (this.zzlbz != null) {
            this.zzlbz.initialize(walletFragmentInitParams);
            this.zzlce = null;
            return;
        }
        if (this.zzlce == null) {
            this.zzlce = walletFragmentInitParams;
            if (this.zzlcf != null) {
                Log.w((String)"SupportWalletFragment", (String)"updateMaskedWalletRequest() was called before initialize()");
            }
            if (this.zzlcg != null) {
                Log.w((String)"SupportWalletFragment", (String)"updateMaskedWallet() was called before initialize()");
                return;
            }
        } else {
            Log.w((String)"SupportWalletFragment", (String)"initialize(WalletFragmentInitParams) was called more than once. Ignoring.");
        }
    }

    public final void updateMaskedWalletRequest(MaskedWalletRequest maskedWalletRequest) {
        if (this.zzlbz != null) {
            this.zzlbz.updateMaskedWalletRequest(maskedWalletRequest);
            this.zzlcf = null;
            return;
        }
        this.zzlcf = maskedWalletRequest;
    }

    public final void updateMaskedWallet(MaskedWallet maskedWallet) {
        if (this.zzlbz != null) {
            this.zzlbz.updateMaskedWallet(maskedWallet);
            this.zzlcg = null;
            return;
        }
        this.zzlcg = maskedWallet;
    }

    public final void setEnabled(boolean bl) {
        if (this.zzlbz != null) {
            this.zzlbz.setEnabled(bl);
            this.zzlch = null;
            return;
        }
        this.zzlch = bl;
    }

    public final void setOnStateChangedListener(OnStateChangedListener onStateChangedListener) {
        this.zzlcc.zza(onStateChangedListener);
    }

    public final int getState() {
        if (this.zzlbz != null) {
            return this.zzlbz.getState();
        }
        return 0;
    }

    public final void onInflate(Activity activity, AttributeSet attributeSet, Bundle bundle) {
        super.onInflate(activity, attributeSet, bundle);
        if (this.zzlcd == null) {
            this.zzlcd = WalletFragmentOptions.zza((Context)activity, attributeSet);
        }
        Bundle bundle2 = new Bundle();
        bundle2.putParcelable("attrKeyWalletFragmentOptions", (Parcelable)this.zzlcd);
        this.zzlcb.onInflate(activity, bundle2, bundle);
    }

    public final void onCreate(Bundle bundle) {
        WalletFragmentOptions walletFragmentOptions;
        super.onCreate(bundle);
        if (bundle != null) {
            bundle.setClassLoader(WalletFragmentOptions.class.getClassLoader());
            WalletFragmentInitParams walletFragmentInitParams = (WalletFragmentInitParams)bundle.getParcelable("walletFragmentInitParams");
            if (walletFragmentInitParams != null) {
                if (this.zzlce != null) {
                    Log.w((String)"SupportWalletFragment", (String)"initialize(WalletFragmentInitParams) was called more than once.Ignoring.");
                }
                this.zzlce = walletFragmentInitParams;
            }
            if (this.zzlcf == null) {
                this.zzlcf = (MaskedWalletRequest)bundle.getParcelable("maskedWalletRequest");
            }
            if (this.zzlcg == null) {
                this.zzlcg = (MaskedWallet)bundle.getParcelable("maskedWallet");
            }
            if (bundle.containsKey("walletFragmentOptions")) {
                this.zzlcd = (WalletFragmentOptions)bundle.getParcelable("walletFragmentOptions");
            }
            if (bundle.containsKey("enabled")) {
                this.zzlch = bundle.getBoolean("enabled");
            }
        } else if (this.zzguf.getArguments() != null && (walletFragmentOptions = (WalletFragmentOptions)this.zzguf.getArguments().getParcelable("extraWalletFragmentOptions")) != null) {
            walletFragmentOptions.zzel((Context)this.zzguf.getActivity());
            this.zzlcd = walletFragmentOptions;
        }
        this.mCreated = true;
        this.zzlcb.onCreate(bundle);
    }

    public final View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        return this.zzlcb.onCreateView(layoutInflater, viewGroup, bundle);
    }

    public final void onStart() {
        super.onStart();
        this.zzlcb.onStart();
    }

    public final void onResume() {
        super.onResume();
        this.zzlcb.onResume();
        FragmentManager fragmentManager = this.zzguf.getActivity().getSupportFragmentManager();
        Fragment fragment = fragmentManager.findFragmentByTag("GooglePlayServicesErrorDialog");
        if (fragment != null) {
            fragmentManager.beginTransaction().remove(fragment).commit();
            GooglePlayServicesUtil.showErrorDialogFragment((int)GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)this.zzguf.getActivity()), (Activity)this.zzguf.getActivity(), (int)-1);
        }
    }

    public final void onPause() {
        super.onPause();
        this.zzlcb.onPause();
    }

    public final void onStop() {
        super.onStop();
        this.zzlcb.onStop();
    }

    public final void onSaveInstanceState(Bundle bundle) {
        super.onSaveInstanceState(bundle);
        bundle.setClassLoader(WalletFragmentOptions.class.getClassLoader());
        this.zzlcb.onSaveInstanceState(bundle);
        if (this.zzlce != null) {
            bundle.putParcelable("walletFragmentInitParams", (Parcelable)this.zzlce);
            this.zzlce = null;
        }
        if (this.zzlcf != null) {
            bundle.putParcelable("maskedWalletRequest", (Parcelable)this.zzlcf);
            this.zzlcf = null;
        }
        if (this.zzlcg != null) {
            bundle.putParcelable("maskedWallet", (Parcelable)this.zzlcg);
            this.zzlcg = null;
        }
        if (this.zzlcd != null) {
            bundle.putParcelable("walletFragmentOptions", (Parcelable)this.zzlcd);
            this.zzlcd = null;
        }
        if (this.zzlch != null) {
            bundle.putBoolean("enabled", this.zzlch.booleanValue());
            this.zzlch = null;
        }
    }

    public final void onDestroy() {
        super.onDestroy();
        this.mCreated = false;
    }

    public final void onActivityResult(int n, int n2, Intent intent) {
        super.onActivityResult(n, n2, intent);
        if (this.zzlbz != null) {
            this.zzlbz.onActivityResult(n, n2, intent);
        }
    }

    static /* synthetic */ WalletFragmentOptions zza(SupportWalletFragment supportWalletFragment, WalletFragmentOptions walletFragmentOptions) {
        supportWalletFragment.zzlcd = null;
        return null;
    }

    static /* synthetic */ WalletFragmentInitParams zza(SupportWalletFragment supportWalletFragment, WalletFragmentInitParams walletFragmentInitParams) {
        supportWalletFragment.zzlce = null;
        return null;
    }

    static /* synthetic */ MaskedWalletRequest zza(SupportWalletFragment supportWalletFragment, MaskedWalletRequest maskedWalletRequest) {
        supportWalletFragment.zzlcf = null;
        return null;
    }

    static /* synthetic */ MaskedWallet zza(SupportWalletFragment supportWalletFragment, MaskedWallet maskedWallet) {
        supportWalletFragment.zzlcg = null;
        return null;
    }

    static /* synthetic */ Boolean zza(SupportWalletFragment supportWalletFragment, Boolean bl) {
        supportWalletFragment.zzlch = null;
        return null;
    }

    public static interface OnStateChangedListener {
        public void onStateChanged(SupportWalletFragment var1, int var2, int var3, Bundle var4);
    }

    static final class zza
    extends zzdjy {
        private OnStateChangedListener zzlci;
        private final SupportWalletFragment zzlcj;

        zza(SupportWalletFragment supportWalletFragment) {
            this.zzlcj = supportWalletFragment;
        }

        @Override
        public final void zza(int n, int n2, Bundle bundle) {
            if (this.zzlci != null) {
                this.zzlci.onStateChanged(this.zzlcj, n, n2, bundle);
            }
        }

        public final void zza(OnStateChangedListener onStateChangedListener) {
            this.zzlci = onStateChangedListener;
        }
    }

    static final class zzb
    implements LifecycleDelegate {
        private final zzdju zzlck;

        private zzb(zzdju zzdju2) {
            this.zzlck = zzdju2;
        }

        private final void initialize(WalletFragmentInitParams walletFragmentInitParams) {
            try {
                this.zzlck.initialize(walletFragmentInitParams);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private final void setEnabled(boolean bl) {
            try {
                this.zzlck.setEnabled(bl);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private final void updateMaskedWalletRequest(MaskedWalletRequest maskedWalletRequest) {
            try {
                this.zzlck.updateMaskedWalletRequest(maskedWalletRequest);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private final void updateMaskedWallet(MaskedWallet maskedWallet) {
            try {
                this.zzlck.updateMaskedWallet(maskedWallet);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private final int getState() {
            try {
                return this.zzlck.getState();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public final void onInflate(Activity activity, Bundle bundle, Bundle bundle2) {
            WalletFragmentOptions walletFragmentOptions = (WalletFragmentOptions)bundle.getParcelable("extraWalletFragmentOptions");
            try {
                this.zzlck.zza(zzn.zzy((Object)activity), walletFragmentOptions, bundle2);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public final void onCreate(Bundle bundle) {
            try {
                this.zzlck.onCreate(bundle);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public final View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
            try {
                return (View)zzn.zzx((IObjectWrapper)this.zzlck.onCreateView(zzn.zzy((Object)layoutInflater), zzn.zzy((Object)viewGroup), bundle));
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public final void onStart() {
            try {
                this.zzlck.onStart();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public final void onResume() {
            try {
                this.zzlck.onResume();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public final void onPause() {
            try {
                this.zzlck.onPause();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public final void onStop() {
            try {
                this.zzlck.onStop();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public final void onDestroyView() {
        }

        public final void onDestroy() {
        }

        public final void onLowMemory() {
        }

        public final void onSaveInstanceState(Bundle bundle) {
            try {
                this.zzlck.onSaveInstanceState(bundle);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private final void onActivityResult(int n, int n2, Intent intent) {
            try {
                this.zzlck.onActivityResult(n, n2, intent);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        /* synthetic */ zzb(zzdju zzdju2, com.google.android.gms.wallet.fragment.zza zza2) {
            this(zzdju2);
        }
    }

    final class zzc
    extends com.google.android.gms.dynamic.zza<zzb>
    implements View.OnClickListener {
        private /* synthetic */ SupportWalletFragment zzlcl;

        private zzc(SupportWalletFragment supportWalletFragment) {
            this.zzlcl = supportWalletFragment;
        }

        protected final void zza(zzo<zzb> zzo2) {
            FragmentActivity fragmentActivity = this.zzlcl.zzguf.getActivity();
            if (this.zzlcl.zzlbz == null && this.zzlcl.mCreated && fragmentActivity != null) {
                try {
                    zzdju zzdju2 = zzdkt.zza((Activity)fragmentActivity, (zzk)this.zzlcl.zzlca, this.zzlcl.zzlcd, this.zzlcl.zzlcc);
                    this.zzlcl.zzlbz = new zzb(zzdju2, null);
                    SupportWalletFragment.zza(this.zzlcl, null);
                }
                catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {
                    return;
                }
                zzo2.zza((LifecycleDelegate)this.zzlcl.zzlbz);
                if (this.zzlcl.zzlce != null) {
                    this.zzlcl.zzlbz.initialize(this.zzlcl.zzlce);
                    SupportWalletFragment.zza(this.zzlcl, null);
                }
                if (this.zzlcl.zzlcf != null) {
                    this.zzlcl.zzlbz.updateMaskedWalletRequest(this.zzlcl.zzlcf);
                    SupportWalletFragment.zza(this.zzlcl, null);
                }
                if (this.zzlcl.zzlcg != null) {
                    this.zzlcl.zzlbz.updateMaskedWallet(this.zzlcl.zzlcg);
                    SupportWalletFragment.zza(this.zzlcl, null);
                }
                if (this.zzlcl.zzlch != null) {
                    this.zzlcl.zzlbz.setEnabled(this.zzlcl.zzlch);
                    SupportWalletFragment.zza(this.zzlcl, null);
                }
            }
        }

        protected final void zza(FrameLayout frameLayout) {
            WalletFragmentStyle walletFragmentStyle;
            Button button = new Button((Context)this.zzlcl.zzguf.getActivity());
            button.setText(R.string.wallet_buy_button_place_holder);
            int n = -1;
            int n2 = -2;
            if (this.zzlcl.zzlcd != null && (walletFragmentStyle = this.zzlcl.zzlcd.getFragmentStyle()) != null) {
                DisplayMetrics displayMetrics = this.zzlcl.zzguf.getResources().getDisplayMetrics();
                n = walletFragmentStyle.zza("buyButtonWidth", displayMetrics, -1);
                n2 = walletFragmentStyle.zza("buyButtonHeight", displayMetrics, -2);
            }
            button.setLayoutParams(new ViewGroup.LayoutParams(n, n2));
            button.setOnClickListener((View.OnClickListener)this);
            frameLayout.addView((View)button);
        }

        public final void onClick(View view) {
            FragmentActivity fragmentActivity = this.zzlcl.zzguf.getActivity();
            GooglePlayServicesUtil.showErrorDialogFragment((int)GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)fragmentActivity), (Activity)fragmentActivity, (int)-1);
        }

        /* synthetic */ zzc(SupportWalletFragment supportWalletFragment, com.google.android.gms.wallet.fragment.zza zza2) {
            this(supportWalletFragment);
        }
    }
}

