/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzbej;
import com.google.android.gms.internal.zzbem;
import com.google.android.gms.wallet.CardRequirements;
import com.google.android.gms.wallet.PaymentMethodTokenizationParameters;
import com.google.android.gms.wallet.ShippingAddressRequirements;
import com.google.android.gms.wallet.TransactionInfo;
import com.google.android.gms.wallet.zzad;
import com.google.android.gms.wallet.zzae;
import java.util.ArrayList;
import java.util.Collection;

public final class PaymentDataRequest
extends zzbej {
    public static final Parcelable.Creator<PaymentDataRequest> CREATOR = new zzae();
    boolean zzlan;
    boolean zzlao;
    CardRequirements zzlap;
    boolean zzlaq;
    ShippingAddressRequirements zzlar;
    ArrayList<Integer> zzkyr;
    PaymentMethodTokenizationParameters zzlas;
    TransactionInfo zzlat;
    boolean zzlau;

    PaymentDataRequest(boolean bl, boolean bl2, CardRequirements cardRequirements, boolean bl3, ShippingAddressRequirements shippingAddressRequirements, ArrayList<Integer> arrayList, PaymentMethodTokenizationParameters paymentMethodTokenizationParameters, TransactionInfo transactionInfo, boolean bl4) {
        this.zzlan = bl;
        this.zzlao = bl2;
        this.zzlap = cardRequirements;
        this.zzlaq = bl3;
        this.zzlar = shippingAddressRequirements;
        this.zzkyr = arrayList;
        this.zzlas = paymentMethodTokenizationParameters;
        this.zzlat = transactionInfo;
        this.zzlau = bl4;
    }

    private PaymentDataRequest() {
        this.zzlau = true;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        PaymentDataRequest paymentDataRequest = this;
        int n2 = zzbem.zze((Parcel)parcel2);
        zzbem.zza((Parcel)parcel2, (int)1, (boolean)paymentDataRequest.zzlan);
        zzbem.zza((Parcel)parcel2, (int)2, (boolean)paymentDataRequest.zzlao);
        zzbem.zza((Parcel)parcel2, (int)3, (Parcelable)paymentDataRequest.zzlap, (int)n, (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)4, (boolean)paymentDataRequest.zzlaq);
        zzbem.zza((Parcel)parcel2, (int)5, (Parcelable)paymentDataRequest.zzlar, (int)n, (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)6, paymentDataRequest.zzkyr, (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)7, (Parcelable)paymentDataRequest.zzlas, (int)n, (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)8, (Parcelable)paymentDataRequest.zzlat, (int)n, (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)9, (boolean)paymentDataRequest.zzlau);
        zzbem.zzai((Parcel)parcel2, (int)n2);
    }

    public final boolean isEmailRequired() {
        return this.zzlan;
    }

    public final boolean isPhoneNumberRequired() {
        return this.zzlao;
    }

    @Nullable
    public final CardRequirements getCardRequirements() {
        return this.zzlap;
    }

    public final boolean isShippingAddressRequired() {
        return this.zzlaq;
    }

    @Nullable
    public final ShippingAddressRequirements getShippingAddressRequirements() {
        return this.zzlar;
    }

    public final ArrayList<Integer> getAllowedPaymentMethods() {
        return this.zzkyr;
    }

    public final PaymentMethodTokenizationParameters getPaymentMethodTokenizationParameters() {
        return this.zzlas;
    }

    public final TransactionInfo getTransactionInfo() {
        return this.zzlat;
    }

    public final boolean isUiRequired() {
        return this.zzlau;
    }

    public static Builder newBuilder() {
        return new Builder(new PaymentDataRequest(), null);
    }

    public final class Builder {
        private /* synthetic */ PaymentDataRequest zzlav;

        private Builder(PaymentDataRequest paymentDataRequest) {
            this.zzlav = paymentDataRequest;
        }

        public final Builder setEmailRequired(boolean bl) {
            this.zzlav.zzlan = bl;
            return this;
        }

        public final Builder setPhoneNumberRequired(boolean bl) {
            this.zzlav.zzlao = bl;
            return this;
        }

        public final Builder setCardRequirements(@NonNull CardRequirements cardRequirements) {
            this.zzlav.zzlap = cardRequirements;
            return this;
        }

        public final Builder setShippingAddressRequired(boolean bl) {
            this.zzlav.zzlaq = bl;
            return this;
        }

        public final Builder setShippingAddressRequirements(@NonNull ShippingAddressRequirements shippingAddressRequirements) {
            this.zzlav.zzlar = shippingAddressRequirements;
            return this;
        }

        public final Builder addAllowedPaymentMethod(int n) {
            if (this.zzlav.zzkyr == null) {
                this.zzlav.zzkyr = new ArrayList();
            }
            this.zzlav.zzkyr.add(n);
            return this;
        }

        public final Builder addAllowedPaymentMethods(@NonNull Collection<Integer> collection) {
            zzbq.checkArgument((collection != null && !collection.isEmpty() ? 1 : 0) != 0, (Object)"allowedPaymentMethods can't be null or empty!");
            if (this.zzlav.zzkyr == null) {
                this.zzlav.zzkyr = new ArrayList();
            }
            this.zzlav.zzkyr.addAll(collection);
            return this;
        }

        public final Builder setPaymentMethodTokenizationParameters(PaymentMethodTokenizationParameters paymentMethodTokenizationParameters) {
            this.zzlav.zzlas = paymentMethodTokenizationParameters;
            return this;
        }

        public final Builder setTransactionInfo(@NonNull TransactionInfo transactionInfo) {
            this.zzlav.zzlat = transactionInfo;
            return this;
        }

        public final Builder setUiRequired(boolean bl) {
            this.zzlav.zzlau = bl;
            return this;
        }

        public final PaymentDataRequest build() {
            zzbq.checkNotNull(this.zzlav.zzkyr, (Object)"Allowed payment methods must be set! You can set it through addAllowedPaymentMethod() or addAllowedPaymentMethods() in the PaymentDataRequest Builder.");
            zzbq.checkNotNull((Object)((Object)this.zzlav.zzlap), (Object)"Card requirements must be set!");
            if (this.zzlav.zzlas != null) {
                zzbq.checkNotNull((Object)((Object)this.zzlav.zzlat), (Object)"Transaction info must be set if paymentMethodTokenizationParameters is set!");
            }
            return this.zzlav;
        }

        /* synthetic */ Builder(PaymentDataRequest paymentDataRequest, zzad zzad2) {
            this(paymentDataRequest);
        }
    }
}

