/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet;

import android.app.Activity;
import android.app.Fragment;
import android.app.PendingIntent;
import android.content.Intent;
import android.content.IntentSender;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcelable;
import android.os.SystemClock;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.util.Log;
import android.util.SparseArray;
import com.google.android.gms.common.api.ApiException;
import com.google.android.gms.common.api.ResolvableApiException;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.android.gms.wallet.AutoResolvableResult;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class AutoResolveHelper {
    private static final long zzkwj = TimeUnit.MINUTES.toMillis(10L);
    @VisibleForTesting
    static long zzkwk = SystemClock.elapsedRealtime();
    public static final int RESULT_ERROR = 1;

    private AutoResolveHelper() {
    }

    @MainThread
    public static <TResult extends AutoResolvableResult> void resolveTask(@NonNull Task<TResult> task, @NonNull Activity activity, int n) {
        zza<TResult> zza2 = zza.zzd(task);
        String string = "com.google.android.gms.wallet.AutoResolveHelper";
        int n2 = zza2.zzkwo;
        activity.getFragmentManager().beginTransaction().add(zzb.zzp(zza2.zzkwo, n), new StringBuilder(11 + String.valueOf(string).length()).append(string).append(n2).toString()).commit();
    }

    @Nullable
    public static Status getStatusFromIntent(@Nullable Intent intent) {
        if (intent == null) {
            return null;
        }
        return (Status)intent.getParcelableExtra("com.google.android.gms.common.api.AutoResolveHelper.status");
    }

    public static void putStatusIntoIntent(@NonNull Intent intent, @Nullable Status status) {
        if (status == null) {
            intent.removeExtra("com.google.android.gms.common.api.AutoResolveHelper.status");
            return;
        }
        intent.putExtra("com.google.android.gms.common.api.AutoResolveHelper.status", (Parcelable)status);
    }

    public static <TResult> void zza(Status status, TResult TResult, TaskCompletionSource<TResult> taskCompletionSource) {
        if (status.isSuccess()) {
            taskCompletionSource.setResult(TResult);
            return;
        }
        taskCompletionSource.setException((Exception)com.google.android.gms.common.internal.zzb.zzz((Status)status));
    }

    private static void zza(Activity activity, int n, Task<? extends AutoResolvableResult> task) {
        if (activity.isFinishing()) {
            if (Log.isLoggable((String)"AutoResolveHelper", (int)3)) {
                Log.d((String)"AutoResolveHelper", (String)"Ignoring task result for, Activity is finishing.");
                return;
            }
        } else {
            int n2;
            if (task.getException() instanceof ResolvableApiException) {
                ResolvableApiException resolvableApiException = (ResolvableApiException)task.getException();
                try {
                    resolvableApiException.startResolutionForResult(activity, n);
                    return;
                }
                catch (IntentSender.SendIntentException sendIntentException) {
                    if (Log.isLoggable((String)"AutoResolveHelper", (int)6)) {
                        Log.e((String)"AutoResolveHelper", (String)"Error starting pending intent!", (Throwable)sendIntentException);
                    }
                    return;
                }
            }
            Intent intent = new Intent();
            if (task.isSuccessful()) {
                n2 = -1;
                ((AutoResolvableResult)task.getResult()).putIntoIntent(intent);
            } else if (task.getException() instanceof ApiException) {
                ApiException apiException = (ApiException)task.getException();
                n2 = 1;
                AutoResolveHelper.putStatusIntoIntent(intent, new Status(apiException.getStatusCode(), apiException.getMessage(), null));
            } else {
                if (Log.isLoggable((String)"AutoResolveHelper", (int)6)) {
                    Log.e((String)"AutoResolveHelper", (String)"Unexpected non API exception!", (Throwable)task.getException());
                }
                n2 = 1;
                AutoResolveHelper.putStatusIntoIntent(intent, new Status(8, "Unexpected non API exception when trying to deliver the task result to an activity!"));
            }
            AutoResolveHelper.zza(activity, n, n2, intent);
        }
    }

    private static void zza(Activity activity, int n, int n2, Intent intent) {
        block5: {
            PendingIntent pendingIntent = activity.createPendingResult(n, intent, 0x40000000);
            if (pendingIntent == null) {
                if (Log.isLoggable((String)"AutoResolveHelper", (int)5)) {
                    Log.w((String)"AutoResolveHelper", (String)"Null pending result returned when trying to deliver task result!");
                    return;
                }
            } else {
                try {
                    pendingIntent.send(n2);
                    return;
                }
                catch (PendingIntent.CanceledException canceledException) {
                    if (!Log.isLoggable((String)"AutoResolveHelper", (int)6)) break block5;
                    Log.e((String)"AutoResolveHelper", (String)"Exception sending pending result", (Throwable)canceledException);
                }
            }
        }
    }

    @VisibleForTesting
    static final class zza<TResult extends AutoResolvableResult>
    implements OnCompleteListener<TResult>,
    Runnable {
        @VisibleForTesting
        private static Handler zzkwl = new Handler(Looper.getMainLooper());
        @VisibleForTesting
        static final SparseArray<zza<?>> zzkwm = new SparseArray(2);
        private static final AtomicInteger zzkwn = new AtomicInteger();
        int zzkwo;
        private zzb zzkwp;
        private Task<TResult> zzkwq;

        zza() {
        }

        public static <TResult extends AutoResolvableResult> zza<TResult> zzd(Task<TResult> task) {
            zza<TResult> zza2 = new zza<TResult>();
            new zza<TResult>().zzkwo = zzkwn.incrementAndGet();
            zzkwm.put(zza2.zzkwo, zza2);
            zzkwl.postDelayed(zza2, zzkwj);
            task.addOnCompleteListener(zza2);
            return zza2;
        }

        public final void zza(zzb zzb2) {
            this.zzkwp = zzb2;
            this.zzbjn();
        }

        public final void zzb(zzb zzb2) {
            if (this.zzkwp == zzb2) {
                this.zzkwp = null;
            }
        }

        public final void onComplete(@NonNull Task<TResult> task) {
            this.zzkwq = task;
            this.zzbjn();
        }

        @Override
        public final void run() {
            zzkwm.delete(this.zzkwo);
        }

        private final void zzbjn() {
            if (this.zzkwq != null && this.zzkwp != null) {
                zzkwm.delete(this.zzkwo);
                zzkwl.removeCallbacks((Runnable)this);
                this.zzkwp.zze((Task<? extends AutoResolvableResult>)this.zzkwq);
            }
        }
    }

    public static final class zzb
    extends Fragment {
        private static String zzkwr = "resolveCallId";
        private static String zzkws = "requestCode";
        private static String zzkwt = "initializationElapsedRealtime";
        private static String zzkwu = "delivered";
        private int zzfkv;
        private zza<?> zzkwv;
        @VisibleForTesting
        private boolean zzkww;

        private static Fragment zzp(int n, int n2) {
            Bundle bundle = new Bundle();
            bundle.putInt(zzkwr, n);
            bundle.putInt(zzkws, n2);
            bundle.putLong(zzkwt, zzkwk);
            zzb zzb2 = new zzb();
            zzb2.setArguments(bundle);
            return zzb2;
        }

        public final void onCreate(@Nullable Bundle bundle) {
            super.onCreate(bundle);
            this.zzfkv = this.getArguments().getInt(zzkws);
            if (zzkwk != this.getArguments().getLong(zzkwt)) {
                this.zzkwv = null;
            } else {
                int n = this.getArguments().getInt(zzkwr);
                this.zzkwv = (zza)zza.zzkwm.get(n);
            }
            this.zzkww = bundle != null && bundle.getBoolean(zzkwu);
        }

        public final void onResume() {
            super.onResume();
            zzb zzb2 = this;
            if (zzb2.zzkwv != null) {
                zzb2.zzkwv.zza(zzb2);
                return;
            }
            if (Log.isLoggable((String)"AutoResolveHelper", (int)5)) {
                Log.w((String)"AutoResolveHelper", (String)"Sending canceled result for garbage collected task!");
            }
            zzb2.zze(null);
        }

        public final void onSaveInstanceState(Bundle bundle) {
            super.onSaveInstanceState(bundle);
            bundle.putBoolean(zzkwu, this.zzkww);
            this.zzbjo();
        }

        public final void onPause() {
            super.onPause();
            this.zzbjo();
        }

        private final void zzbjo() {
            if (this.zzkwv != null) {
                this.zzkwv.zzb(this);
            }
        }

        private final void zze(@Nullable Task<? extends AutoResolvableResult> task) {
            if (!this.zzkww) {
                this.zzkww = true;
                Activity activity = this.getActivity();
                activity.getFragmentManager().beginTransaction().remove((Fragment)this).commit();
                if (task != null) {
                    AutoResolveHelper.zza(activity, this.zzfkv, (Task<? extends AutoResolvableResult>)task);
                    return;
                }
                AutoResolveHelper.zza(activity, this.zzfkv, 0, new Intent());
            }
        }
    }
}

